/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.infocom.Abbreviations;
import com.bytezone.diskbrowser.infocom.CodeManager;
import com.bytezone.diskbrowser.infocom.Dictionary;
import com.bytezone.diskbrowser.infocom.Globals;
import com.bytezone.diskbrowser.infocom.Grammar;
import com.bytezone.diskbrowser.infocom.InfocomAbstractFile;
import com.bytezone.diskbrowser.infocom.ObjectManager;
import com.bytezone.diskbrowser.infocom.StringManager;
import com.bytezone.diskbrowser.infocom.ZObject;
import java.io.File;

class Header
extends InfocomAbstractFile {
    final String[] propertyNames = new String[32];
    private final File file;
    int version;
    int highMemory;
    int programCounter;
    int dictionaryOffset;
    int objectTableOffset;
    int globalsOffset;
    int staticMemory;
    int abbreviationsTable;
    int fileLength;
    int checksum;
    int stringPointer;
    final Abbreviations abbreviations;
    final ObjectManager objectManager;
    final Globals globals;
    final Grammar grammar;
    final Dictionary dictionary;
    final CodeManager codeManager;
    final StringManager stringManager;

    Header(String name, byte[] buffer, Disk disk) {
        super(name, buffer);
        this.file = disk.getFile();
        this.version = this.getByte(0);
        this.highMemory = this.getWord(4);
        this.programCounter = this.getWord(6);
        this.dictionaryOffset = this.getWord(8);
        this.objectTableOffset = this.getWord(10);
        this.globalsOffset = this.getWord(12);
        this.staticMemory = this.getWord(14);
        this.abbreviationsTable = this.getWord(24);
        this.fileLength = this.getWord(26) * 2;
        this.checksum = this.getWord(28);
        int interpreterNumber = this.getByte(30);
        int interpreterVersion = this.getByte(31);
        int revision = this.getWord(48);
        System.out.printf("Version    : %d%n", this.version);
        System.out.printf("Interpreter: %d.%d%n", interpreterNumber, interpreterVersion);
        System.out.printf("Revision   : %d%n", revision);
        if (this.fileLength == 0) {
            this.fileLength = buffer.length;
        }
        this.abbreviations = new Abbreviations(this);
        this.dictionary = new Dictionary(this);
        this.globals = new Globals(this);
        this.codeManager = new CodeManager(this);
        this.grammar = new Grammar("Grammar", buffer, this);
        this.objectManager = new ObjectManager(this);
        this.stringManager = new StringManager("Strings", buffer, this);
        this.codeManager.addRoutines(this.programCounter);
        this.hexBlocks.add(new InfocomAbstractFile.HexBlock(this, 0, 64, "Header data:"));
    }

    String getPropertyName(int id) {
        if (id >= this.propertyNames.length) {
            return "Bad id : " + id;
        }
        return this.propertyNames[id];
    }

    public String getAbbreviation(int index) {
        return this.abbreviations.getAbbreviation(index);
    }

    public boolean containsWordAt(int address) {
        return this.dictionary.containsWordAt(address);
    }

    public String wordAt(int address) {
        return this.dictionary.wordAt(address);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Disk name                %s%n", this.file.getName()));
        text.append(String.format("Version                  %d%n", this.version));
        text.append("\nDynamic memory:\n");
        text.append(String.format("  Abbreviation table     %04X  %,6d%n", this.abbreviationsTable, this.abbreviationsTable));
        text.append(String.format("  Objects table          %04X  %,6d%n", this.objectTableOffset, this.objectTableOffset));
        text.append(String.format("  Global variables       %04X  %,6d%n", this.globalsOffset, this.globalsOffset));
        text.append("\nStatic memory:\n");
        text.append(String.format("  Grammar table etc      %04X  %,6d%n", this.staticMemory, this.staticMemory));
        text.append(String.format("  Dictionary             %04X  %,6d%n", this.dictionaryOffset, this.dictionaryOffset));
        text.append("\nHigh memory:\n");
        text.append(String.format("  ZCode                  %04X  %,6d%n", this.highMemory, this.highMemory));
        text.append(String.format("  Program counter        %04X  %,6d%n", this.programCounter, this.programCounter));
        text.append(String.format("\nFile length             %05X %,7d%n", this.fileLength, this.fileLength));
        text.append(String.format("Checksum                 %04X  %,6d%n", this.checksum, this.checksum));
        text.append(String.format("%nZString offset          %05X %,7d%n", this.stringPointer, this.stringPointer));
        text.append(String.format("Total strings                     %d%n", this.stringManager.strings.size()));
        text.append(String.format("Total objects                     %d%n", this.objectManager.getObjects().size()));
        text.append(this.getAlternate());
        return text.toString();
    }

    private String getAlternate() {
        StringBuilder text = new StringBuilder("\n\n");
        text.append(this.getLine(0, 1, "version"));
        text.append(this.getLine(1, 3, "flags 1"));
        text.append(this.getLine(4, 2, "high memory"));
        text.append(this.getLine(6, 2, "program counter"));
        text.append(this.getLine(8, 2, "dictionary"));
        text.append(this.getLine(10, 2, "object table"));
        text.append(this.getLine(12, 2, "global variables"));
        text.append(this.getLine(14, 2, "static memory"));
        text.append(this.getLine(16, 2, "flags 2"));
        text.append(this.getLine(24, 2, "abbreviations table"));
        text.append(this.getLine(26, 2, "length of file (x2 = " + this.fileLength + ")"));
        text.append(this.getLine(28, 2, "checksum"));
        text.append(this.getLine(50, 1, "revision number"));
        return text.toString();
    }

    private String getLine(int offset, int size, String description) {
        StringBuilder text = new StringBuilder();
        text.append(String.format("%04X - %04X  ", offset, offset + size - 1));
        int i = 0;
        while (i < size) {
            text.append(String.format("%02X ", this.buffer[offset + i]));
            ++i;
        }
        while (text.length() < 24) {
            text.append(" ");
        }
        text.append(description);
        text.append("\n");
        return text.toString();
    }

    ZObject getObject(int index) {
        return this.objectManager.getObject(index);
    }

    int getByte(int offset) {
        return this.buffer[offset] & 0xFF;
    }

    int getWord(int offset) {
        return this.buffer[offset] << 8 & 0xFF00 | this.buffer[offset + 1] & 0xFF;
    }
}

