/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.ZString;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class Dictionary
extends AbstractFile {
    private final Map<Integer, ZString> dictionary;
    private final int totalEntries;
    private final int totalSeparators;
    private final int dictionaryPtr;
    private final int dictionarySize;
    private final int entryLength;
    private final String separators;
    Map<Integer, List<WordEntry>> synonymList = new TreeMap<Integer, List<WordEntry>>();

    Dictionary(Header header) {
        super("Dictionary", header.buffer);
        this.dictionaryPtr = header.dictionaryOffset;
        this.dictionary = new TreeMap<Integer, ZString>();
        this.totalSeparators = this.buffer[this.dictionaryPtr] & 0xFF;
        StringBuilder sep = new StringBuilder();
        int i = 0;
        while (i < this.totalSeparators) {
            sep.append((char)(this.buffer[this.dictionaryPtr + i + 1] & 0xFF));
            ++i;
        }
        this.separators = sep.toString();
        int ptr = this.dictionaryPtr + this.totalSeparators + 1;
        this.entryLength = this.buffer[ptr++] & 0xFF;
        this.totalEntries = header.getWord(ptr);
        ptr += 2;
        int count = 0;
        int i2 = 0;
        while (i2 < this.totalEntries) {
            ZString string = new ZString(header, ptr);
            this.dictionary.put(ptr, string);
            WordEntry wordEntry = new WordEntry(string, count++);
            List<WordEntry> wordEntryList = this.synonymList.get(wordEntry.key);
            if (wordEntryList == null) {
                wordEntryList = new ArrayList<WordEntry>();
                this.synonymList.put(wordEntry.key, wordEntryList);
            }
            wordEntryList.add(wordEntry);
            if ((this.buffer[ptr + 4] & 0x10) != 0) {
                int b1 = this.buffer[ptr + 5] & 0xFF;
                int b2 = this.buffer[ptr + 6] & 0xFF;
                int property = b2 == 0 ? b1 : b2;
                String propertyName = header.getPropertyName(property &= 0x1F);
                System.out.printf("%02X  %s%n", property, string.value);
                if (propertyName == null || propertyName.length() > string.value.length()) {
                    header.propertyNames[property] = string.value;
                }
            }
            ptr += this.entryLength;
            ++i2;
        }
        this.dictionarySize = this.totalSeparators + 3 + this.entryLength * this.totalEntries;
        i2 = 1;
        while (i2 < header.propertyNames.length) {
            if (header.propertyNames[i2] == null) {
                header.propertyNames[i2] = String.valueOf(i2);
            }
            ++i2;
        }
    }

    public boolean containsWordAt(int address) {
        return this.dictionary.containsKey(address);
    }

    public String wordAt(int address) {
        if (this.dictionary.containsKey(address)) {
            return this.dictionary.get((Object)Integer.valueOf((int)address)).value;
        }
        return "dictionary can't find word @ " + address;
    }

    public List<String> getVerbs(int value) {
        ArrayList<String> words = new ArrayList<String>();
        int ptr = this.dictionaryPtr + this.totalSeparators + 4;
        for (ZString word : this.dictionary.values()) {
            int b1 = this.buffer[ptr + 4] & 0xFF;
            int b2 = this.buffer[ptr + 5] & 0xFF;
            int b3 = this.buffer[ptr + 6] & 0xFF;
            if (b1 == 65 && b2 == value || (b1 == 98 || b1 == 192 || b1 == 68) && b3 == value) {
                words.add(word.value);
            }
            ptr += this.entryLength;
        }
        return words;
    }

    public List<String> getPrepositions(int value) {
        ArrayList<String> words = new ArrayList<String>();
        int ptr = this.dictionaryPtr + this.totalSeparators + 4;
        for (ZString word : this.dictionary.values()) {
            int b1 = this.buffer[ptr + 4] & 0xFF;
            int b2 = this.buffer[ptr + 5] & 0xFF;
            int b3 = this.buffer[ptr + 6] & 0xFF;
            if ((b1 == 8 || b1 == 24 || b1 == 72) && b2 == value || (b1 == 27 || b1 == 12 || b1 == 42) && b3 == value) {
                words.add(word.value);
            }
            ptr += this.entryLength;
        }
        return words;
    }

    @Override
    public String getHexDump() {
        StringBuilder text = new StringBuilder();
        text.append(HexFormatter.format(this.buffer, this.dictionaryPtr, this.dictionarySize));
        return text.toString();
    }

    @Override
    public String getText() {
        String bits;
        StringBuilder text = new StringBuilder();
        text.append(String.format("Entries    : %,6d%n", this.totalEntries));
        text.append(String.format("Separators : %s%n", this.separators));
        text.append(String.format("Offset     : %,6d   %04X%n%n", this.dictionaryPtr, this.dictionaryPtr));
        int count = 0;
        int ptr = this.dictionaryPtr + this.totalSeparators + 4;
        for (ZString word : this.dictionary.values()) {
            bits = Integer.toBinaryString(this.buffer[ptr + 4] & 0xFF);
            if (bits.length() < 8) {
                bits = String.valueOf("00000000".substring(bits.length())) + bits;
            }
            text.append(String.format("%04X   %3d   %-6s   %s  %s", ptr, count++, word.value, bits, HexFormatter.getHexString(this.buffer, ptr + 4, this.entryLength - 4)));
            int b1 = this.buffer[ptr + 4] & 0xFF;
            int b2 = this.buffer[ptr + 5] & 0xFF;
            int b3 = this.buffer[ptr + 6] & 0xFF;
            if (b1 == 65) {
                text.append(String.format("  %3d%n", b2));
            } else if (b1 == 98 || b1 == 192 || b1 == 68) {
                text.append(String.format("  %3d%n", b3));
            } else {
                text.append("\n");
            }
            ptr += this.entryLength;
        }
        text.append("\n");
        int lastValue = 0;
        int bit = 1;
        while (bit < 256) {
            bits = Integer.toBinaryString(bit & 0xFF);
            if (bits.length() < 8) {
                bits = String.valueOf("00000000".substring(bits.length())) + bits;
            }
            text.append(String.format("Bits:                 %s%n", bits));
            for (List<WordEntry> list : this.synonymList.values()) {
                WordEntry wordEntry = list.get(0);
                if ((wordEntry.flags & bit) == 0) continue;
                if (wordEntry.flags != lastValue) {
                    lastValue = wordEntry.flags;
                    text.append("\n");
                }
                if (wordEntry.flags == 128) {
                    for (WordEntry we : list) {
                        text.append(we + "\n");
                    }
                    continue;
                }
                text.append(wordEntry + "\n");
            }
            text.append("\n");
            bit *= 2;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    private class WordEntry
    implements Comparable<WordEntry> {
        ZString word;
        int seq;
        int flags;
        int key;
        String bits;

        public WordEntry(ZString word, int seq) {
            this.word = word;
            this.seq = seq;
            int b1 = Dictionary.this.buffer[word.startPtr + 4] & 0xFF;
            int b2 = Dictionary.this.buffer[word.startPtr + 5] & 0xFF;
            int b3 = Dictionary.this.buffer[word.startPtr + 6] & 0xFF;
            this.key = b1 << 16 | b2 << 8 | b3;
            this.flags = b1;
            this.bits = Integer.toBinaryString(b1);
            if (this.bits.length() < 8) {
                this.bits = String.valueOf("00000000".substring(this.bits.length())) + this.bits;
            }
        }

        @Override
        public int compareTo(WordEntry o) {
            return this.flags - o.flags;
        }

        public String toString() {
            StringBuilder list = new StringBuilder("[");
            if ((this.key & 0x800000) == 0) {
                for (WordEntry we : Dictionary.this.synonymList.get(this.key)) {
                    list.append(String.valueOf(we.word.value) + ", ");
                }
                list.deleteCharAt(list.length() - 1);
                list.deleteCharAt(list.length() - 1);
            } else {
                list.append(this.word.value);
            }
            list.append("]");
            StringBuilder text = new StringBuilder();
            text.append(String.format("%04X   %3d   %-6s   %s  %s   %s", this.word.startPtr, this.seq, this.word.value, this.bits, HexFormatter.getHexString(Dictionary.this.buffer, this.word.startPtr + 4, Dictionary.this.entryLength - 4), list.toString()));
            return text.toString();
        }
    }
}

