/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.infocom.Grammar;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.InfocomDisk;
import com.bytezone.diskbrowser.infocom.Routine;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.tree.DefaultMutableTreeNode;

class CodeManager
extends AbstractFile {
    private final Header header;
    private int codeSize;
    private final Map<Integer, Routine> routines = new TreeMap<Integer, Routine>();

    CodeManager(Header header) {
        super("Code", header.buffer);
        this.header = header;
    }

    void addNodes(DefaultMutableTreeNode root, InfocomDisk disk) {
        root.setAllowsChildren(true);
        this.codeSize = this.header.stringPointer - this.header.highMemory;
        int count = 0;
        for (Routine routine : this.routines.values()) {
            String name = String.format("%3d %s (%04X)", ++count, routine.getName(), routine.startPtr / 2);
            DefaultAppleFileSource dafs = new DefaultAppleFileSource(name, routine, (FormattedDisk)disk);
            dafs.setSectors(this.getSectors(routine, disk.getDisk()));
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(dafs);
            node.setAllowsChildren(false);
            root.add(node);
        }
    }

    private List<DiskAddress> getSectors(Routine routine, Disk disk) {
        int blockNo = routine.startPtr / 256 + 48;
        int size = routine.length;
        ArrayList<DiskAddress> blocks = new ArrayList<DiskAddress>();
        while (size > 0) {
            blocks.add(disk.getDiskAddress(blockNo++));
            size -= 256;
        }
        return blocks;
    }

    void addRoutines(int programCounter) {
        this.addRoutine(programCounter - 1, -1);
        this.addActionRoutines();
        this.addCodeRoutines();
        this.addGlobalRoutines();
        this.addMissingRoutines();
    }

    private int checkAlignment(int ptr) {
        if (ptr % 2 == 1) {
            ++ptr;
        }
        return ptr;
    }

    private void addGlobalRoutines() {
    }

    private void addMissingRoutines() {
        System.out.printf("%nWalking the code block%n%n", new Object[0]);
        int total = this.routines.size();
        int ptr = this.header.highMemory;
        while (ptr < this.header.stringPointer) {
            if (this.routines.containsKey(ptr = this.checkAlignment(ptr))) {
                int length = this.getRoutine((int)ptr).length;
                if (length == 0) break;
                ptr += length;
                continue;
            }
            Routine routine = this.addRoutine(ptr, 0);
            if (routine == null) {
                System.out.printf("Invalid routine found : %05X%n", ptr);
                ptr = this.findNextRoutine(ptr + 1);
                System.out.printf("skipping to %05X%n", ptr);
                if (ptr != 0) continue;
                break;
            }
            ptr += routine.length;
            System.out.printf("Routine found: %05X%n", routine.startPtr);
        }
        System.out.printf("%n%d new routines found by walking the code block%n%n", this.routines.size() - total);
    }

    private int findNextRoutine(int address) {
        for (Routine routine : this.routines.values()) {
            if (routine.startPtr <= address) continue;
            return routine.startPtr;
        }
        return 0;
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        int count = 0;
        int nextAddress = this.header.highMemory;
        text.append("  #   Address   Size   Lines  Strings   Called   Calls   Gap   Pack\n");
        text.append("---   -------   ----   -----  -------   ------   -----   ---   ----\n");
        for (Routine r : this.routines.values()) {
            int gap = r.startPtr - nextAddress;
            text.append(String.format("%3d    %05X   %5d     %3d      %2d      %3d     %3d   %4d   %04X%n", ++count, r.startPtr, r.length, r.instructions.size(), r.strings, r.calledBy.size(), r.calls.size(), gap, r.startPtr / 2));
            nextAddress = r.startPtr + r.length;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    private void addCodeRoutines() {
        List<Integer> routines = this.header.objectManager.getCodeRoutines();
        System.out.println("Adding " + routines.size() + " code routines");
        for (Integer address : routines) {
            this.addRoutine(address, 0);
        }
    }

    private void addActionRoutines() {
        int total = this.routines.size();
        for (Grammar.SentenceGroup sentenceGroup : this.header.grammar.getSentenceGroups()) {
            for (Grammar.Sentence sentence : sentenceGroup) {
                if (sentence.preActionRoutine > 0) {
                    this.addRoutine(sentence.preActionRoutine, sentence.startPtr);
                }
                this.addRoutine(sentence.actionRoutine, sentence.startPtr);
            }
        }
        System.out.printf("Added %d action routines%n", this.routines.size() - total);
    }

    Routine addRoutine(int address, int caller) {
        if (address == 0) {
            return null;
        }
        if (address > this.header.fileLength) {
            return null;
        }
        if (this.routines.containsKey(address)) {
            Routine routine = this.routines.get(address);
            routine.addCaller(caller);
            return routine;
        }
        Routine routine = new Routine(address, this.header, caller);
        if (!routine.isValid()) {
            return null;
        }
        this.routines.put(address, routine);
        for (int ptr : routine.calls) {
            this.addRoutine(ptr, address);
        }
        return routine;
    }

    Routine getRoutine(int address) {
        return this.routines.get(address);
    }

    @Override
    public String getHexDump() {
        return HexFormatter.format(this.buffer, this.header.highMemory, this.codeSize);
    }
}

