/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.prefs.Preferences;
import javax.swing.JFrame;

class WindowSaver {
    private final Preferences prefs;
    private final JFrame frame;
    private final String key;

    WindowSaver(Preferences prefs, JFrame frame, String key) {
        this.prefs = prefs;
        this.frame = frame;
        this.key = key;
    }

    void saveWindow() {
        this.prefs.putInt(String.valueOf(this.key) + "X", this.frame.getX());
        this.prefs.putInt(String.valueOf(this.key) + "Y", this.frame.getY());
        this.prefs.putInt(String.valueOf(this.key) + "Height", this.frame.getHeight());
        this.prefs.putInt(String.valueOf(this.key) + "Width", this.frame.getWidth());
    }

    boolean restoreWindow() {
        int x = this.prefs.getInt(String.valueOf(this.key) + "X", -1);
        int y = this.prefs.getInt(String.valueOf(this.key) + "Y", -1);
        int height = this.prefs.getInt(String.valueOf(this.key) + "Height", -1);
        int width = this.prefs.getInt(String.valueOf(this.key) + "Width", -1);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (width < 0) {
            this.frame.setLocation(100, 100);
            this.frame.setSize(1000, 600);
            this.frame.setLocationRelativeTo(null);
            return false;
        }
        if ((double)width > screen.getWidth()) {
            width = (int)screen.getWidth();
        }
        this.frame.setSize(width, height);
        this.frame.setLocation(x, y);
        return true;
    }
}

