/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.applefile.BasicProgram;
import com.bytezone.diskbrowser.applefile.BasicTextFile;
import com.bytezone.diskbrowser.applefile.HiResImage;
import com.bytezone.diskbrowser.applefile.Palette;
import com.bytezone.diskbrowser.applefile.PaletteFactory;
import com.bytezone.diskbrowser.disk.DataDisk;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.gui.AssemblerPreferences;
import com.bytezone.diskbrowser.gui.AssemblerPreferencesListener;
import com.bytezone.diskbrowser.gui.BasicPreferences;
import com.bytezone.diskbrowser.gui.BasicPreferencesListener;
import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.DiskSelectionListener;
import com.bytezone.diskbrowser.gui.ExecuteDiskAction;
import com.bytezone.diskbrowser.gui.FileSelectedEvent;
import com.bytezone.diskbrowser.gui.FileSelectionListener;
import com.bytezone.diskbrowser.gui.FontAction;
import com.bytezone.diskbrowser.gui.InterleaveAction;
import com.bytezone.diskbrowser.gui.ProdosPreferences;
import com.bytezone.diskbrowser.gui.ProdosPreferencesListener;
import com.bytezone.diskbrowser.gui.QuitListener;
import com.bytezone.diskbrowser.gui.SaveDiskAction;
import com.bytezone.diskbrowser.gui.SaveFileAction;
import com.bytezone.diskbrowser.gui.SaveSectorsAction;
import com.bytezone.diskbrowser.gui.TextPreferences;
import com.bytezone.diskbrowser.gui.TextPreferencesListener;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import com.bytezone.diskbrowser.utilities.EnvironmentAction;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

class MenuHandler
implements DiskSelectionListener,
FileSelectionListener,
QuitListener {
    static final String PREFS_LINE_WRAP = "line wrap";
    private static final String PREFS_SHOW_CATALOG = "show catalog";
    private static final String PREFS_SHOW_LAYOUT = "show layout";
    private static final String PREFS_SHOW_FREE_SECTORS = "show free sectors";
    private static final String PREFS_COLOUR_QUIRKS = "colour quirks";
    private static final String PREFS_MONOCHROME = "monochrome";
    private static final String PREFS_SCALE = "scale";
    private static final String PREFS_SHOW_HEADER = "showHeader";
    private static final String PREFS_SHOW_ALL_FORMAT = "formatApplesoft";
    private static final String PREFS_SHOW_ALL_XREF = "showAllXref";
    private static final String PREFS_APPLE_LINE_WRAP = "appleLineWrap";
    private static final String PREFS_SPLIT_REMARKS = "splitRemarks";
    private static final String PREFS_SPLIT_DIM = "splitDim";
    private static final String PREFS_ALIGN_ASSIGN = "alignAssign";
    private static final String PREFS_SHOW_CARET = "showCaret";
    private static final String PREFS_SHOW_THEN = "showThen";
    private static final String PREFS_BLANK_AFTER_RETURN = "blankAfterReturn";
    private static final String PREFS_FORMAT_REM = "formatRem";
    private static final String PREFS_DELETE_EXTRA_DATA_SPACE = "deleteExtraDataSpace";
    private static final String PREFS_SHOW_GOSUB_GOTO = "showXref";
    private static final String PREFS_SHOW_CALLS = "showCalls";
    private static final String PREFS_SHOW_SYMBOLS = "showSymbols";
    private static final String PREFS_SHOW_FUNCTIONS = "showFunctions";
    private static final String PREFS_SHOW_CONSTANTS = "showConstants";
    private static final String PREFS_SHOW_DUPLICATE_SYMBOLS = "showDuplicateSymbols";
    private static final String PREFS_SHOW_ASSEMBLER_TARGETS = "showAssemblerTargets";
    private static final String PREFS_SHOW_ASSEMBLER_STRINGS = "showAssemblerStrings";
    private static final String PREFS_SHOW_ASSEMBLER_HEADER = "showAssemblerHeader";
    private static final String PREFS_PRODOS_SORT_DIRECTORIES = "prodosSortDirectories";
    private static final String PREFS_TEXT_SHOW_OFFSETS = "showTextOffsets";
    private static final String PREFS_TEXT_SHOW_HEADER = "showTextHeader";
    private static final String PREFS_PALETTE = "palette";
    final SaveDiskAction saveDiskAction = new SaveDiskAction();
    final SaveFileAction saveFileAction = new SaveFileAction();
    final SaveSectorsAction saveSectorsAction = new SaveSectorsAction();
    private final BasicPreferences basicPreferences = new BasicPreferences();
    private final List<BasicPreferencesListener> basicPreferencesListeners = new ArrayList<BasicPreferencesListener>();
    private final AssemblerPreferences assemblerPreferences = new AssemblerPreferences();
    private final List<AssemblerPreferencesListener> assemblerPreferencesListeners = new ArrayList<AssemblerPreferencesListener>();
    private final ProdosPreferences prodosPreferences = new ProdosPreferences();
    private final List<ProdosPreferencesListener> prodosPreferencesListeners = new ArrayList<ProdosPreferencesListener>();
    private final TextPreferences textPreferences = new TextPreferences();
    private final List<TextPreferencesListener> textPreferencesListeners = new ArrayList<TextPreferencesListener>();
    private List<JMenuItem> applesoftFormatItems;
    private List<JMenuItem> applesoftXrefItems;
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu("File");
    JMenu formatMenu = new JMenu("Format");
    JMenu imageMenu = new JMenu("Images");
    JMenu applesoftMenu = new JMenu("Applesoft");
    JMenu textMenu = new JMenu("Text");
    JMenu assemblerMenu = new JMenu("Assembler");
    JMenu prodosMenu = new JMenu("Prodos");
    JMenu helpMenu = new JMenu("Help");
    final JMenuItem rootItem = new JMenuItem("Set root folder...");
    final JMenuItem refreshTreeItem = new JMenuItem("Refresh current tree");
    final JMenuItem executeDiskItem = new JMenuItem();
    final JMenuItem saveDiskItem = new JMenuItem("Save converted disk as...");
    final JMenuItem saveFileItem = new JMenuItem("Save file...");
    final JMenuItem saveSectorsItem = new JMenuItem("Save sectors as...");
    final JMenuItem printItem = new JMenuItem("Print output panel...");
    final JMenuItem closeTabItem = new JMenuItem();
    final JMenuItem duplicateItem = new JMenuItem();
    final FontAction fontAction = new FontAction();
    final JMenuItem debuggingItem = new JCheckBoxMenuItem("Debugging");
    final JMenuItem lineWrapItem = new JCheckBoxMenuItem("Line wrap");
    final JMenuItem showLayoutItem = new JCheckBoxMenuItem("Show layout panel");
    final JMenuItem showCatalogItem = new JCheckBoxMenuItem("Show catalog panel");
    final JMenuItem showFreeSectorsItem = new JCheckBoxMenuItem("Show free sectors");
    final JMenuItem sector256Item = new JRadioButtonMenuItem("256 byte sectors");
    final JMenuItem sector512Item = new JRadioButtonMenuItem("512 byte blocks");
    final JMenuItem interleave0Item = new JRadioButtonMenuItem(new InterleaveAction(0));
    final JMenuItem interleave1Item = new JRadioButtonMenuItem(new InterleaveAction(1));
    final JMenuItem interleave2Item = new JRadioButtonMenuItem(new InterleaveAction(2));
    final JMenuItem interleave3Item = new JRadioButtonMenuItem(new InterleaveAction(3));
    final JMenuItem colourQuirksItem = new JCheckBoxMenuItem("Colour quirks");
    final JMenuItem monochromeItem = new JCheckBoxMenuItem("Monochrome");
    final JMenuItem nextPaletteItem = new JMenuItem("Next Palette");
    final JMenuItem prevPaletteItem = new JMenuItem("Previous Palette");
    final JMenuItem scale1Item = new JRadioButtonMenuItem("Scale 1");
    final JMenuItem scale2Item = new JRadioButtonMenuItem("Scale 1.5");
    final JMenuItem scale3Item = new JRadioButtonMenuItem("Scale 2");
    final JMenuItem showHeaderItem = new JCheckBoxMenuItem("Show header");
    final JMenuItem showAllFormatItem = new JCheckBoxMenuItem("Enable Format options");
    final JMenuItem showAllXrefItem = new JCheckBoxMenuItem("Enable XREF options");
    final JMenuItem appleLineWrapItem = new JCheckBoxMenuItem("Applesoft 40 column line wrap");
    final JMenuItem splitRemarkItem = new JCheckBoxMenuItem("Split REM");
    final JMenuItem splitDimItem = new JCheckBoxMenuItem("Split DIM");
    final JMenuItem alignAssignItem = new JCheckBoxMenuItem("Align consecutive assign");
    final JMenuItem showCaretItem = new JCheckBoxMenuItem("Show caret");
    final JMenuItem showThenItem = new JCheckBoxMenuItem("Show THEN after IF");
    final JMenuItem blankAfterReturnItem = new JCheckBoxMenuItem("Blank line after RETURN");
    final JMenuItem formatRemItem = new JCheckBoxMenuItem("Allow formatted REM");
    final JMenuItem deleteExtraDataSpace = new JCheckBoxMenuItem("Delete extra DATA space");
    final JMenuItem showXrefItem = new JCheckBoxMenuItem("List GOSUB/GOTO");
    final JMenuItem showCallsItem = new JCheckBoxMenuItem("List CALLs");
    final JMenuItem showSymbolsItem = new JCheckBoxMenuItem("List variables");
    final JMenuItem showFunctionsItem = new JCheckBoxMenuItem("List functions");
    final JMenuItem showConstantsItem = new JCheckBoxMenuItem("List constants");
    final JMenuItem showDuplicateSymbolsItem = new JCheckBoxMenuItem("List duplicate variables");
    final JMenuItem showAssemblerTargetsItem = new JCheckBoxMenuItem("Show targets");
    final JMenuItem showAssemblerStringsItem = new JCheckBoxMenuItem("List possible strings");
    final JMenuItem showAssemblerHeaderItem = new JCheckBoxMenuItem("Show header");
    final JMenuItem prodosSortDirectoriesItem = new JCheckBoxMenuItem("Sort directories");
    final JMenuItem showTextOffsetsItem = new JCheckBoxMenuItem("Show offsets");
    final JMenuItem showTextHeaderItem = new JCheckBoxMenuItem("Show header");
    ButtonGroup paletteGroup = new ButtonGroup();
    FormattedDisk currentDisk;

    MenuHandler() {
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.formatMenu);
        this.menuBar.add(this.imageMenu);
        this.menuBar.add(this.prodosMenu);
        this.menuBar.add(this.applesoftMenu);
        this.menuBar.add(this.assemblerMenu);
        this.menuBar.add(this.textMenu);
        this.menuBar.add(this.helpMenu);
        this.fileMenu.add(this.rootItem);
        this.fileMenu.add(this.refreshTreeItem);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.saveDiskItem);
        this.fileMenu.add(this.saveFileItem);
        this.fileMenu.add(this.saveSectorsItem);
        this.fileMenu.addSeparator();
        this.addLauncherMenu();
        this.fileMenu.add(this.printItem);
        this.fileMenu.add(this.closeTabItem);
        JMenuItem fontItem = new JMenuItem(this.fontAction);
        this.fileMenu.add(fontItem);
        this.fontAction.setSampleText("120  FOR Z = 14 TO 24:\n  VTAB 5:\n  HTAB Z:\n  PRINT AB$:\n  FOR TI = 1 TO 50:\n  NEXT :\n  POKE 0,Z + 40:\n  POKE 1,9:\n  CALL MU:\n  VTAB 5:\n  HTAB Z:\n  PRINT SPC(12):\nNEXT :\nVTAB 5:\nHTAB 24:\nPRINT AB$\n");
        this.fileMenu.add(this.duplicateItem);
        this.fileMenu.add(this.debuggingItem);
        this.formatMenu.add(this.lineWrapItem);
        this.formatMenu.add(this.showCatalogItem);
        this.formatMenu.add(this.showLayoutItem);
        this.formatMenu.add(this.showFreeSectorsItem);
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.interleave0Item);
        this.formatMenu.add(this.interleave1Item);
        this.formatMenu.add(this.interleave2Item);
        this.formatMenu.add(this.interleave3Item);
        this.formatMenu.addSeparator();
        this.formatMenu.add(this.sector256Item);
        this.formatMenu.add(this.sector512Item);
        List<Palette> palettes = HiResImage.getPalettes();
        int i = 0;
        while (i < palettes.size()) {
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem("x");
            this.paletteGroup.add(menuItem);
            this.imageMenu.add(menuItem);
            ++i;
        }
        this.imageMenu.addSeparator();
        this.imageMenu.add(this.colourQuirksItem);
        this.imageMenu.add(this.monochromeItem);
        this.imageMenu.addSeparator();
        this.imageMenu.add(this.nextPaletteItem);
        this.imageMenu.add(this.prevPaletteItem);
        this.imageMenu.addSeparator();
        this.imageMenu.add(this.scale1Item);
        this.imageMenu.add(this.scale2Item);
        this.imageMenu.add(this.scale3Item);
        this.applesoftMenu.add(this.showHeaderItem);
        this.applesoftMenu.add(this.showAllFormatItem);
        this.applesoftMenu.add(this.showAllXrefItem);
        this.applesoftMenu.addSeparator();
        this.applesoftMenu.add(this.appleLineWrapItem);
        this.applesoftMenu.addSeparator();
        this.applesoftMenu.add(this.splitRemarkItem);
        this.applesoftMenu.add(this.splitDimItem);
        this.applesoftMenu.add(this.alignAssignItem);
        this.applesoftMenu.add(this.showCaretItem);
        this.applesoftMenu.add(this.showThenItem);
        this.applesoftMenu.add(this.blankAfterReturnItem);
        this.applesoftMenu.add(this.formatRemItem);
        this.applesoftMenu.add(this.deleteExtraDataSpace);
        this.applesoftMenu.addSeparator();
        this.applesoftMenu.add(this.showXrefItem);
        this.applesoftMenu.add(this.showCallsItem);
        this.applesoftMenu.add(this.showSymbolsItem);
        this.applesoftMenu.add(this.showFunctionsItem);
        this.applesoftMenu.add(this.showConstantsItem);
        this.applesoftMenu.add(this.showDuplicateSymbolsItem);
        this.assemblerMenu.add(this.showAssemblerHeaderItem);
        this.assemblerMenu.add(this.showAssemblerTargetsItem);
        this.assemblerMenu.add(this.showAssemblerStringsItem);
        this.textMenu.add(this.showTextHeaderItem);
        this.textMenu.add(this.showTextOffsetsItem);
        this.prodosMenu.add(this.prodosSortDirectoriesItem);
        this.applesoftFormatItems = new ArrayList<JMenuItem>(Arrays.asList(this.splitRemarkItem, this.splitDimItem, this.alignAssignItem, this.showCaretItem, this.showThenItem, this.blankAfterReturnItem, this.formatRemItem, this.deleteExtraDataSpace));
        this.applesoftXrefItems = new ArrayList<JMenuItem>(Arrays.asList(this.showXrefItem, this.showCallsItem, this.showSymbolsItem, this.showFunctionsItem, this.showConstantsItem, this.showDuplicateSymbolsItem));
        ActionListener basicPreferencesAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuHandler.this.setBasicPreferences();
                MenuHandler.this.notifyBasicPreferencesListeners();
            }
        };
        ActionListener assemblerPreferencesAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuHandler.this.setAssemblerPreferences();
                MenuHandler.this.notifyAssemblerPreferencesListeners();
            }
        };
        ActionListener prodosPreferencesAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuHandler.this.setProdosPreferences();
                MenuHandler.this.notifyProdosPreferencesListeners();
            }
        };
        ActionListener textPreferencesAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuHandler.this.setTextPreferences();
                MenuHandler.this.notifyTextPreferencesListeners();
            }
        };
        this.showHeaderItem.addActionListener(basicPreferencesAction);
        this.showAllFormatItem.addActionListener(basicPreferencesAction);
        this.showAllXrefItem.addActionListener(basicPreferencesAction);
        this.appleLineWrapItem.addActionListener(basicPreferencesAction);
        for (JMenuItem item : this.applesoftFormatItems) {
            item.addActionListener(basicPreferencesAction);
        }
        for (JMenuItem item : this.applesoftXrefItems) {
            item.addActionListener(basicPreferencesAction);
        }
        this.showAssemblerTargetsItem.addActionListener(assemblerPreferencesAction);
        this.showAssemblerStringsItem.addActionListener(assemblerPreferencesAction);
        this.showAssemblerHeaderItem.addActionListener(assemblerPreferencesAction);
        this.prodosSortDirectoriesItem.addActionListener(prodosPreferencesAction);
        this.showTextOffsetsItem.addActionListener(textPreferencesAction);
        this.showTextHeaderItem.addActionListener(textPreferencesAction);
        this.helpMenu.add(new JMenuItem(new EnvironmentAction()));
        this.sector256Item.setActionCommand("256");
        this.sector256Item.setAccelerator(KeyStroke.getKeyStroke("alt 4"));
        this.sector512Item.setActionCommand("512");
        this.sector512Item.setAccelerator(KeyStroke.getKeyStroke("alt 5"));
        ButtonGroup sectorGroup = new ButtonGroup();
        ButtonGroup interleaveGroup = new ButtonGroup();
        ButtonGroup scaleGroup = new ButtonGroup();
        sectorGroup.add(this.sector256Item);
        sectorGroup.add(this.sector512Item);
        interleaveGroup.add(this.interleave0Item);
        interleaveGroup.add(this.interleave1Item);
        interleaveGroup.add(this.interleave2Item);
        interleaveGroup.add(this.interleave3Item);
        scaleGroup.add(this.scale1Item);
        scaleGroup.add(this.scale2Item);
        scaleGroup.add(this.scale3Item);
        this.saveDiskItem.setAction(this.saveDiskAction);
        this.saveFileItem.setAction(this.saveFileAction);
        this.saveSectorsItem.setAction(this.saveSectorsAction);
        KeyStroke keyStroke1 = KeyStroke.getKeyStroke(83, 512);
        this.showAllFormatItem.setAccelerator(keyStroke1);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(76, 512);
        this.showAllXrefItem.setAccelerator(keyStroke2);
    }

    private void setBasicPreferences() {
        this.basicPreferences.showHeader = this.showHeaderItem.isSelected();
        this.basicPreferences.userFormat = this.showAllFormatItem.isSelected();
        this.basicPreferences.showAllXref = this.showAllXrefItem.isSelected();
        this.basicPreferences.appleLineWrap = this.appleLineWrapItem.isSelected();
        this.basicPreferences.splitRem = this.splitRemarkItem.isSelected();
        this.basicPreferences.splitDim = this.splitDimItem.isSelected();
        this.basicPreferences.alignAssign = this.alignAssignItem.isSelected();
        this.basicPreferences.showCaret = this.showCaretItem.isSelected();
        this.basicPreferences.showThen = this.showThenItem.isSelected();
        this.basicPreferences.blankAfterReturn = this.blankAfterReturnItem.isSelected();
        this.basicPreferences.formatRem = this.formatRemItem.isSelected();
        this.basicPreferences.deleteExtraDataSpace = this.deleteExtraDataSpace.isSelected();
        this.basicPreferences.showGosubGoto = this.showXrefItem.isSelected();
        this.basicPreferences.showCalls = this.showCallsItem.isSelected();
        this.basicPreferences.showSymbols = this.showSymbolsItem.isSelected();
        this.basicPreferences.showFunctions = this.showFunctionsItem.isSelected();
        this.basicPreferences.showConstants = this.showConstantsItem.isSelected();
        this.basicPreferences.showDuplicateSymbols = this.showDuplicateSymbolsItem.isSelected();
        BasicProgram.setBasicPreferences(this.basicPreferences);
        for (JMenuItem item : this.applesoftFormatItems) {
            item.setEnabled(this.basicPreferences.userFormat);
        }
        this.appleLineWrapItem.setEnabled(!this.basicPreferences.userFormat);
        for (JMenuItem item : this.applesoftXrefItems) {
            item.setEnabled(this.basicPreferences.showAllXref);
        }
    }

    void addBasicPreferencesListener(BasicPreferencesListener listener) {
        if (!this.basicPreferencesListeners.contains(listener)) {
            this.basicPreferencesListeners.add(listener);
            listener.setBasicPreferences(this.basicPreferences);
        }
    }

    void notifyBasicPreferencesListeners() {
        for (BasicPreferencesListener listener : this.basicPreferencesListeners) {
            listener.setBasicPreferences(this.basicPreferences);
        }
    }

    private void setAssemblerPreferences() {
        this.assemblerPreferences.showTargets = this.showAssemblerTargetsItem.isSelected();
        this.assemblerPreferences.showStrings = this.showAssemblerStringsItem.isSelected();
        this.assemblerPreferences.showHeader = this.showAssemblerHeaderItem.isSelected();
        AssemblerProgram.setAssemblerPreferences(this.assemblerPreferences);
    }

    void addAssemblerPreferencesListener(AssemblerPreferencesListener listener) {
        if (!this.assemblerPreferencesListeners.contains(listener)) {
            this.assemblerPreferencesListeners.add(listener);
            listener.setAssemblerPreferences(this.assemblerPreferences);
        }
    }

    void notifyAssemblerPreferencesListeners() {
        for (AssemblerPreferencesListener listener : this.assemblerPreferencesListeners) {
            listener.setAssemblerPreferences(this.assemblerPreferences);
        }
    }

    private void setProdosPreferences() {
        this.prodosPreferences.sortDirectories = this.prodosSortDirectoriesItem.isSelected();
        ProdosDisk.setProdosPreferences(this.prodosPreferences);
    }

    void addProdosPreferencesListener(ProdosPreferencesListener listener) {
        if (!this.prodosPreferencesListeners.contains(listener)) {
            this.prodosPreferencesListeners.add(listener);
            listener.setProdosPreferences(this.prodosPreferences);
        }
    }

    void notifyProdosPreferencesListeners() {
        for (ProdosPreferencesListener listener : this.prodosPreferencesListeners) {
            listener.setProdosPreferences(this.prodosPreferences);
        }
    }

    private void setTextPreferences() {
        this.textPreferences.showTextOffsets = this.showTextOffsetsItem.isSelected();
        this.textPreferences.showHeader = this.showTextHeaderItem.isSelected();
        BasicTextFile.setTextPreferences(this.textPreferences);
    }

    void addTextPreferencesListener(TextPreferencesListener listener) {
        if (!this.textPreferencesListeners.contains(listener)) {
            this.textPreferencesListeners.add(listener);
            listener.setTextPreferences(this.textPreferences);
        }
    }

    void notifyTextPreferencesListeners() {
        for (TextPreferencesListener listener : this.textPreferencesListeners) {
            listener.setTextPreferences(this.textPreferences);
        }
    }

    private void addLauncherMenu() {
        if (!Desktop.isDesktopSupported()) {
            return;
        }
        boolean openSupported = false;
        Desktop.Action[] actionArray = Desktop.Action.values();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Desktop.Action action = actionArray[n2];
            if (action.toString().equals("OPEN")) {
                openSupported = true;
                break;
            }
            ++n2;
        }
        if (!openSupported) {
            return;
        }
        this.executeDiskItem.setAction(new ExecuteDiskAction(this));
        this.fileMenu.add(this.executeDiskItem);
        this.fileMenu.addSeparator();
    }

    @Override
    public void restore(Preferences prefs) {
        this.lineWrapItem.setSelected(prefs.getBoolean(PREFS_LINE_WRAP, true));
        this.showLayoutItem.setSelected(prefs.getBoolean(PREFS_SHOW_LAYOUT, true));
        this.showCatalogItem.setSelected(prefs.getBoolean(PREFS_SHOW_CATALOG, true));
        this.showFreeSectorsItem.setSelected(prefs.getBoolean(PREFS_SHOW_FREE_SECTORS, false));
        this.colourQuirksItem.setSelected(prefs.getBoolean(PREFS_COLOUR_QUIRKS, false));
        this.monochromeItem.setSelected(prefs.getBoolean(PREFS_MONOCHROME, false));
        switch (prefs.getInt(PREFS_SCALE, 2)) {
            case 1: {
                this.scale1Item.doClick();
                break;
            }
            case 2: {
                this.scale2Item.doClick();
                break;
            }
            case 3: {
                this.scale3Item.doClick();
            }
        }
        this.showHeaderItem.setSelected(prefs.getBoolean(PREFS_SHOW_HEADER, true));
        this.showAllFormatItem.setSelected(prefs.getBoolean(PREFS_SHOW_ALL_FORMAT, true));
        this.showAllXrefItem.setSelected(prefs.getBoolean(PREFS_SHOW_ALL_XREF, true));
        this.appleLineWrapItem.setSelected(prefs.getBoolean(PREFS_APPLE_LINE_WRAP, false));
        this.splitRemarkItem.setSelected(prefs.getBoolean(PREFS_SPLIT_REMARKS, false));
        this.splitDimItem.setSelected(prefs.getBoolean(PREFS_SPLIT_DIM, false));
        this.alignAssignItem.setSelected(prefs.getBoolean(PREFS_ALIGN_ASSIGN, true));
        this.showCaretItem.setSelected(prefs.getBoolean(PREFS_SHOW_CARET, false));
        this.showThenItem.setSelected(prefs.getBoolean(PREFS_SHOW_THEN, true));
        this.blankAfterReturnItem.setSelected(prefs.getBoolean(PREFS_BLANK_AFTER_RETURN, false));
        this.formatRemItem.setSelected(prefs.getBoolean(PREFS_FORMAT_REM, false));
        this.deleteExtraDataSpace.setSelected(prefs.getBoolean(PREFS_DELETE_EXTRA_DATA_SPACE, false));
        this.showXrefItem.setSelected(prefs.getBoolean(PREFS_SHOW_GOSUB_GOTO, false));
        this.showCallsItem.setSelected(prefs.getBoolean(PREFS_SHOW_CALLS, false));
        this.showSymbolsItem.setSelected(prefs.getBoolean(PREFS_SHOW_SYMBOLS, false));
        this.showFunctionsItem.setSelected(prefs.getBoolean(PREFS_SHOW_FUNCTIONS, false));
        this.showConstantsItem.setSelected(prefs.getBoolean(PREFS_SHOW_CONSTANTS, false));
        this.showDuplicateSymbolsItem.setSelected(prefs.getBoolean(PREFS_SHOW_DUPLICATE_SYMBOLS, false));
        this.showAssemblerTargetsItem.setSelected(prefs.getBoolean(PREFS_SHOW_ASSEMBLER_TARGETS, true));
        this.showAssemblerStringsItem.setSelected(prefs.getBoolean(PREFS_SHOW_ASSEMBLER_STRINGS, true));
        this.showAssemblerHeaderItem.setSelected(prefs.getBoolean(PREFS_SHOW_ASSEMBLER_HEADER, true));
        this.prodosSortDirectoriesItem.setSelected(prefs.getBoolean(PREFS_PRODOS_SORT_DIRECTORIES, true));
        this.showTextOffsetsItem.setSelected(prefs.getBoolean(PREFS_TEXT_SHOW_OFFSETS, true));
        this.showTextHeaderItem.setSelected(prefs.getBoolean(PREFS_TEXT_SHOW_HEADER, true));
        this.setBasicPreferences();
        this.setAssemblerPreferences();
        this.setProdosPreferences();
        this.setTextPreferences();
        int paletteIndex = prefs.getInt(PREFS_PALETTE, 0);
        PaletteFactory paletteFactory = HiResImage.getPaletteFactory();
        paletteFactory.setCurrentPalette(paletteIndex);
        Palette palette = paletteFactory.getCurrentPalette();
        Enumeration<AbstractButton> enumeration = this.paletteGroup.getElements();
        while (enumeration.hasMoreElements()) {
            JCheckBoxMenuItem item = (JCheckBoxMenuItem)enumeration.nextElement();
            if (!item.getText().equals(palette.getName())) continue;
            item.setSelected(true);
            break;
        }
        HiResImage.setDefaultColourQuirks(this.colourQuirksItem.isSelected());
        HiResImage.setDefaultMonochrome(this.monochromeItem.isSelected());
        AbstractFile.setDefaultDebug(this.debuggingItem.isSelected());
        this.fontAction.restore(prefs);
    }

    @Override
    public void quit(Preferences prefs) {
        prefs.putBoolean(PREFS_LINE_WRAP, this.lineWrapItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_LAYOUT, this.showLayoutItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_CATALOG, this.showCatalogItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_FREE_SECTORS, this.showFreeSectorsItem.isSelected());
        prefs.putBoolean(PREFS_COLOUR_QUIRKS, this.colourQuirksItem.isSelected());
        prefs.putBoolean(PREFS_MONOCHROME, this.monochromeItem.isSelected());
        prefs.putInt(PREFS_PALETTE, HiResImage.getPaletteFactory().getCurrentPaletteIndex());
        this.fontAction.quit(prefs);
        int scale = this.scale1Item.isSelected() ? 1 : (this.scale2Item.isSelected() ? 2 : 3);
        prefs.putInt(PREFS_SCALE, scale);
        prefs.putBoolean(PREFS_SHOW_HEADER, this.showHeaderItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_ALL_FORMAT, this.showAllFormatItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_ALL_XREF, this.showAllXrefItem.isSelected());
        prefs.putBoolean(PREFS_APPLE_LINE_WRAP, this.appleLineWrapItem.isSelected());
        prefs.putBoolean(PREFS_SPLIT_REMARKS, this.splitRemarkItem.isSelected());
        prefs.putBoolean(PREFS_SPLIT_DIM, this.splitDimItem.isSelected());
        prefs.putBoolean(PREFS_ALIGN_ASSIGN, this.alignAssignItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_CARET, this.showCaretItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_THEN, this.showThenItem.isSelected());
        prefs.putBoolean(PREFS_BLANK_AFTER_RETURN, this.blankAfterReturnItem.isSelected());
        prefs.putBoolean(PREFS_FORMAT_REM, this.formatRemItem.isSelected());
        prefs.putBoolean(PREFS_DELETE_EXTRA_DATA_SPACE, this.deleteExtraDataSpace.isSelected());
        prefs.putBoolean(PREFS_SHOW_GOSUB_GOTO, this.showXrefItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_CALLS, this.showCallsItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_SYMBOLS, this.showSymbolsItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_FUNCTIONS, this.showFunctionsItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_CONSTANTS, this.showConstantsItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_DUPLICATE_SYMBOLS, this.showDuplicateSymbolsItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_ASSEMBLER_TARGETS, this.showAssemblerTargetsItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_ASSEMBLER_STRINGS, this.showAssemblerStringsItem.isSelected());
        prefs.putBoolean(PREFS_SHOW_ASSEMBLER_HEADER, this.showAssemblerHeaderItem.isSelected());
        prefs.putBoolean(PREFS_PRODOS_SORT_DIRECTORIES, this.prodosSortDirectoriesItem.isSelected());
        prefs.putBoolean(PREFS_TEXT_SHOW_OFFSETS, this.showTextOffsetsItem.isSelected());
        prefs.putBoolean(PREFS_TEXT_SHOW_HEADER, this.showTextHeaderItem.isSelected());
    }

    @Override
    public void diskSelected(DiskSelectedEvent event) {
        this.currentDisk = event.getFormattedDisk();
        this.adjustMenus(this.currentDisk);
    }

    @Override
    public void fileSelected(FileSelectedEvent event) {
        if (event.appleFileSource.getFormattedDisk() != this.currentDisk) {
            this.currentDisk = event.appleFileSource.getFormattedDisk();
            this.adjustMenus(this.currentDisk);
        }
    }

    private void adjustMenus(final FormattedDisk disk) {
        if (disk != null) {
            this.sector256Item.setSelected(disk.getDisk().getBlockSize() == 256);
            this.sector512Item.setSelected(disk.getDisk().getBlockSize() == 512);
            this.interleave0Item.setSelected(disk.getDisk().getInterleave() == 0);
            this.interleave1Item.setSelected(disk.getDisk().getInterleave() == 1);
            this.interleave2Item.setSelected(disk.getDisk().getInterleave() == 2);
            this.interleave3Item.setSelected(disk.getDisk().getInterleave() == 3);
        }
        boolean isDataDisk = disk instanceof DataDisk;
        this.sector256Item.setEnabled(isDataDisk);
        this.sector512Item.setEnabled(isDataDisk);
        this.interleave0Item.setEnabled(isDataDisk);
        this.interleave1Item.setEnabled(isDataDisk);
        this.interleave2Item.setEnabled(isDataDisk);
        this.interleave3Item.setEnabled(isDataDisk);
        if (isDataDisk) {
            ActionListener sectorListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int size = Integer.parseInt(e.getActionCommand());
                    disk.getDisk().setBlockSize(size);
                }
            };
            this.sector256Item.addActionListener(sectorListener);
            this.sector512Item.addActionListener(sectorListener);
            ((InterleaveAction)this.interleave0Item.getAction()).setDisk(this.currentDisk);
            ((InterleaveAction)this.interleave1Item.getAction()).setDisk(this.currentDisk);
            ((InterleaveAction)this.interleave2Item.getAction()).setDisk(this.currentDisk);
            ((InterleaveAction)this.interleave3Item.getAction()).setDisk(this.currentDisk);
        }
    }
}

