/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private static final int BACKGROUND = 245;
    private BufferedImage image;
    private double scale = 1.0;
    private double userScale = 0.5;

    public ImagePanel() {
        this.setBackground(new Color(245, 245, 245));
    }

    public void setScale(double scale) {
        this.userScale = scale;
    }

    public void setImage(BufferedImage image) {
        int height;
        int width;
        this.image = image;
        if (image != null) {
            Graphics2D g2 = image.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            width = image.getWidth();
            height = image.getHeight();
        } else {
            height = 0;
            width = 0;
        }
        this.scale = width < 400 && width > 0 ? (double)(399 / width + 1) : 1.0;
        if (this.scale > 4.0) {
            this.scale = 4.0;
        }
        this.scale *= this.userScale;
        this.setPreferredSize(new Dimension((int)((double)width * this.scale), (int)((double)height * this.scale)));
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.image != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.transform(AffineTransform.getScaleInstance(this.scale, this.scale));
            g2.drawImage((Image)this.image, (int)(((double)this.getWidth() - (double)this.image.getWidth() * this.scale) / 2.0 / this.scale), 4, this);
        }
    }
}

