/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.gui.FontAction;
import com.bytezone.input.ButtonPanel;
import com.bytezone.input.ColumnPanel;
import com.bytezone.input.InputPanel;
import com.bytezone.input.RadioButtonPanel;
import com.bytezone.input.RowPanel;
import com.bytezone.input.ScrollPanel;
import com.bytezone.input.TextAreaPanel;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontFrame
extends JFrame {
    private final JList<String> fontList = new JList(new DefaultListModel());
    private final FontAction fontAction;
    private String initialFont;
    private String initialSize;
    private RadioButtonPanel fontSizePanel;
    private TextAreaPanel textPanel;
    private JButton btnCancel;
    private JButton btnOK;
    private JButton btnApply;

    public FontFrame(FontAction fontAction) {
        super("Font Selection");
        this.fontAction = fontAction;
        this.buildLayout();
        this.getFonts();
        this.setListeners();
    }

    private void buildLayout() {
        this.fontList.setSelectionMode(0);
        JScrollPane sp = new JScrollPane(this.fontList);
        sp.setVerticalScrollBarPolicy(22);
        ScrollPanel listPanel = new ScrollPanel(sp, 200, 300);
        this.fontSizePanel = new RadioButtonPanel(new String[][]{{"6 point", "7 point", "8 point", "9 point", "10 point", "11 point", "12 point", "13 point", "14 point", "15 point", "16 point", "18 point"}});
        InputPanel.setTextLength(80);
        this.textPanel = new TextAreaPanel(10);
        ButtonPanel buttonPanel = new ButtonPanel(new String[]{"Cancel", "OK", "Apply"});
        this.btnCancel = buttonPanel.getItem(0);
        this.btnOK = buttonPanel.getItem(1);
        this.btnApply = buttonPanel.getItem(2);
        RowPanel rp = new RowPanel(new RowPanel("Font", listPanel), new RowPanel("Size", this.fontSizePanel), new RowPanel("Sample code", this.textPanel));
        this.add(new ColumnPanel(rp, buttonPanel));
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
    }

    public void setText(String text) {
        this.textPanel.getItem(0).setText(text);
    }

    public String getSelectedValue() {
        return this.fontList.getSelectedValue();
    }

    public void setSelectedValue(String fontName) {
        this.fontList.setSelectedValue(fontName, true);
        this.initialFont = fontName;
    }

    public String getSelectedSize() {
        return this.fontSizePanel.getSelectedText();
    }

    public void setSelectedSize(String fontSize) {
        this.fontSizePanel.setSelected(fontSize);
        this.initialSize = fontSize;
    }

    private void getFonts() {
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        String[] pf = new String[]{"Andale Mono", "Anonymous Pro", "Anonymous Pro Minus", "Apple II Display Pro", "Apple II Pro", "Apple2Forever", "Apple2Forever80", "Bitstream Vera Sans Mono", "Consolas", "Courier", "Courier New", "DejaVu Sans Mono", "Envy Code R", "Inconsolata", "Input Mono", "Input Mono Narrow", "Iosevka", "Lucida Sans Typewriter", "Luculent", "Menlo", "Monaco", "monofur", "Monospaced", "Nimbus Mono L", "PCMyungjo", "PR Number 3", "Pragmata", "Print Char 21", "ProFont", "ProFontX", "Proggy", "PT Mono", "Source Code Pro", "Ubuntu Mono"};
        DefaultListModel lm = (DefaultListModel)this.fontList.getModel();
        int ptr = 0;
        String[] stringArray = fonts;
        int n = fonts.length;
        int n2 = 0;
        while (n2 < n) {
            String fontName = stringArray[n2];
            while (ptr < pf.length) {
                int result = fontName.compareToIgnoreCase(pf[ptr]);
                if (result < 0) break;
                ++ptr;
                if (result > 0) continue;
                lm.addElement(fontName);
                break;
            }
            ++n2;
        }
        this.fontList.setSelectedValue(this.initialFont, true);
    }

    private void setListeners() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                if (FontFrame.this.fontList.getModel().getSize() == 0) {
                    FontFrame.this.getFonts();
                }
                FontFrame.this.initialFont = FontFrame.this.getSelectedValue();
                FontFrame.this.initialSize = FontFrame.this.getSelectedSize();
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.fontList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontFrame.this.setVisible(false);
                FontFrame.this.setSelectedValue(FontFrame.this.initialFont);
                FontFrame.this.setSelectedSize(FontFrame.this.initialSize);
            }
        });
        this.btnOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontFrame.this.setVisible(false);
                FontFrame.this.setSelection();
            }
        });
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontFrame.this.setSelection();
            }
        });
        this.fontList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                Font font = FontFrame.this.getCurrentFont();
                if (font != null) {
                    FontFrame.this.textPanel.getItem(0).setFont(font);
                }
            }
        });
        this.fontSizePanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontFrame.this.textPanel.getItem(0).setFont(FontFrame.this.getCurrentFont());
            }
        });
    }

    private Font getCurrentFont() {
        String fontSize = this.getSelectedSize();
        if (fontSize.isEmpty()) {
            return null;
        }
        int pos = fontSize.indexOf(32);
        int size = Integer.parseInt(fontSize.substring(0, pos));
        return new Font(this.getSelectedValue(), 0, size);
    }

    private void setSelection() {
        this.initialFont = this.getSelectedValue();
        this.initialSize = this.getSelectedSize();
        int pos = this.initialSize.indexOf(32);
        int size = Integer.parseInt(this.initialSize.substring(0, pos));
        Font font = new Font(this.initialFont, 0, size);
        this.fontAction.fireFontChangeEvent(font);
    }
}

