/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.disk.DiskFactory;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.gui.AbstractTab;
import com.bytezone.diskbrowser.gui.DiskAndFileSelector;
import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.FileNodeSelectedEvent;
import com.bytezone.diskbrowser.gui.RedoHandler;
import com.bytezone.diskbrowser.gui.TreeBuilder;
import java.awt.Font;
import java.io.File;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;

class FileSystemTab
extends AbstractTab {
    File rootFolder;

    public FileSystemTab(File folder, DiskAndFileSelector selector, RedoHandler redoHandler, Font font, DiskSelectedEvent diskEvent) {
        super(redoHandler, selector, font);
        DefaultMutableTreeNode node;
        this.rootFolder = folder;
        TreeBuilder tb = new TreeBuilder(folder);
        this.setTree(tb.getTree());
        this.setSelectionListener(this.tree);
        if (diskEvent == null && (node = this.findFirstLeafNode()) != null) {
            TreeBuilder.FileNode fn = (TreeBuilder.FileNode)node.getUserObject();
            diskEvent = new DiskSelectedEvent(this, DiskFactory.createDisk(fn.file));
        }
        if (diskEvent != null) {
            redoHandler.diskSelected(diskEvent);
        } else {
            System.out.println("No disk event");
        }
    }

    public FileSystemTab(File folder, DiskAndFileSelector selector, RedoHandler navMan, Font font) {
        this(folder, selector, navMan, font, null);
    }

    @Override
    public void activate() {
        this.tree.setSelectionPath(null);
        this.redoHandler.setCurrentData(this.redoData);
    }

    @Override
    public void refresh() {
        String currentDiskName = ((TreeBuilder.FileNode)this.getSelectedObject()).file.getAbsolutePath();
        TreeBuilder tb = new TreeBuilder(this.rootFolder);
        this.setTree(tb.getTree());
        if (currentDiskName != null) {
            this.showNode(this.findNode(currentDiskName));
        }
        this.setSelectionListener(this.tree);
    }

    void redoEvent(RedoHandler.RedoEvent event) {
        DefaultMutableTreeNode node = null;
        if (event.type.equals("FileNodeEvent")) {
            TreeBuilder.FileNode fn = ((FileNodeSelectedEvent)event.value).getFileNode();
            node = fn.parentNode;
        } else {
            FormattedDisk disk = ((DiskSelectedEvent)event.value).getFormattedDisk();
            node = this.findNode(disk.getAbsolutePath());
        }
        if (node == null) {
            node = this.findNode(2);
        }
        if (node != null) {
            this.showNode(node);
        } else {
            System.out.println("Disk node not found");
        }
    }

    void selectDisk(String path) {
        DefaultMutableTreeNode node = this.findNode(String.valueOf(this.rootFolder.getAbsolutePath()) + path);
        if (node != null) {
            this.showNode(node);
        } else {
            System.out.println("Path not found: " + this.rootFolder.getAbsolutePath() + path);
        }
    }

    private DefaultMutableTreeNode findNode(String absolutePath) {
        return this.search(this.getRootNode(), absolutePath);
    }

    private DefaultMutableTreeNode search(DefaultMutableTreeNode node, String absolutePath) {
        TreeBuilder.FileNode fn = (TreeBuilder.FileNode)node.getUserObject();
        int children = node.getChildCount();
        if (children == 0) {
            fn.readFiles();
            children = node.getChildCount();
        }
        int i = 0;
        while (i < children) {
            DefaultMutableTreeNode node2;
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)node.getChildAt(i);
            TreeBuilder.FileNode fn2 = (TreeBuilder.FileNode)childNode.getUserObject();
            String path = fn2.file.getAbsolutePath();
            if (absolutePath.equals(path)) {
                return childNode;
            }
            if (fn2.file.isDirectory() && absolutePath.startsWith(path) && absolutePath.charAt(path.length()) == File.separatorChar && (node2 = this.search(childNode, absolutePath)) != null) {
                return node2;
            }
            ++i;
        }
        return null;
    }

    public void replaceDisk(FormattedDisk disk) {
        TreeBuilder.FileNode fn = (TreeBuilder.FileNode)this.getSelectedObject();
        if (fn != null && fn.replaceDisk(disk)) {
            return;
        }
        DefaultMutableTreeNode rootNode = this.getRootNode();
        Enumeration<TreeNode> children = rootNode.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            fn = (TreeBuilder.FileNode)node.getUserObject();
            if (fn.replaceDisk(disk)) break;
        }
    }

    private void setSelectionListener(JTree tree) {
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreeBuilder.FileNode fn = (TreeBuilder.FileNode)FileSystemTab.this.getSelectedObject();
                if (fn != null) {
                    FileSystemTab.this.eventHandler.fireDiskSelectionEvent(fn);
                }
            }
        });
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent e) throws ExpandVetoException {
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
                TreeBuilder.FileNode fn = (TreeBuilder.FileNode)node.getUserObject();
                if (node.getChildCount() == 0) {
                    fn.readFiles();
                }
            }
        });
    }
}

