/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.duplicates.DiskDetails;
import com.bytezone.diskbrowser.duplicates.RootFolderData;
import com.bytezone.diskbrowser.utilities.DefaultAction;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class DuplicateAction
extends DefaultAction
implements PropertyChangeListener {
    RootFolderData rootFolderData;

    public DuplicateAction(RootFolderData rootFolderData) {
        super("List disks...", "Display a sortable list of disks", "/com/bytezone/diskbrowser/icons/");
        this.rootFolderData = rootFolderData;
        this.setIcon("SmallIcon", "save_delete_16.png");
        this.setIcon("SwingLargeIconKey", "save_delete_32.png");
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, mask));
        this.setEnabled(rootFolderData.getRootFolder() != null);
    }

    private void rootDirectoryChanged(File oldRootFolder, File newRootFolder) {
        assert (this.rootFolderData.getRootFolder() == newRootFolder);
        this.setEnabled(this.rootFolderData.getRootFolder() != null);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("RootDirectory")) {
            this.rootDirectoryChanged((File)evt.getOldValue(), (File)evt.getNewValue());
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (this.rootFolderData.disksWindow == null) {
            Object[] options = new Object[]{"Generate checksums", "Disk names only", "Cancel"};
            int option = JOptionPane.showOptionDialog(null, "This command will list all of the disks in the root folder (including\nnested folders). If you wish to generate a checksum for each disk, it\nmay slow the process down considerably.\n\nDo you wish to generate checksums?", "Generate Disk Listing", 1, 3, null, options, options[1]);
            if (option < 2) {
                this.rootFolderData.count(option == 0);
            }
        } else {
            this.rootFolderData.disksWindow.setVisible(true);
        }
    }

    public void addTableSelectionListener(DiskTableSelectionListener listener) {
        if (!this.rootFolderData.listeners.contains(listener)) {
            this.rootFolderData.listeners.add(listener);
        }
    }

    public static interface DiskTableSelectionListener {
        public void diskSelected(DiskDetails var1);
    }
}

