/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DiskLayoutPanel;
import com.bytezone.diskbrowser.gui.DiskLayoutSelection;
import com.bytezone.diskbrowser.gui.DiskPanel;
import com.bytezone.diskbrowser.gui.RedoHandler;
import com.bytezone.diskbrowser.gui.SectorSelectedEvent;
import com.bytezone.diskbrowser.gui.SectorSelectionListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Scrollable;

class DiskLayoutImage
extends DiskPanel
implements Scrollable,
RedoHandler.RedoListener {
    private static final Cursor crosshairCursor = new Cursor(1);
    private static final Color[] lightColors = new Color[]{Color.WHITE, Color.YELLOW, Color.PINK, Color.CYAN, Color.ORANGE, Color.GREEN};
    private boolean showFreeSectors;
    private final DiskLayoutSelection selectionHandler = new DiskLayoutSelection();
    private boolean redo;
    private int gridWidth = 8;
    private int gridHeight = 35;

    public DiskLayoutImage() {
        this.setPreferredSize(new Dimension(241, 526));
        this.addMouseListener(new MyMouseListener());
        this.setBackground(this.backgroundColor);
        this.addKeyListener(new MyKeyListener());
    }

    @Override
    public void setDisk(FormattedDisk disk, DiskLayoutPanel.LayoutDetails details) {
        super.setDisk(disk, details);
        this.gridWidth = this.layoutDetails.grid.width;
        this.gridHeight = this.layoutDetails.grid.height;
        this.setPreferredSize(new Dimension(this.gridWidth * this.blockWidth + 1, this.gridHeight * this.blockHeight + 1));
        this.selectionHandler.setSelection(null);
        this.repaint();
    }

    public FormattedDisk getDisk() {
        return this.formattedDisk;
    }

    public void setShowFreeSectors(boolean showFree) {
        if (showFree != this.showFreeSectors) {
            this.showFreeSectors = showFree;
            this.repaint();
        }
    }

    void setSelection(List<DiskAddress> sectors) {
        this.selectionHandler.setSelection(sectors);
        if (sectors != null && sectors.size() > 0) {
            this.scrollRectToVisible(this.layoutDetails.getLocation(sectors.get(0)));
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.formattedDisk == null) {
            return;
        }
        Rectangle clipRect = g.getClipBounds();
        Point topLeft = new Point(clipRect.x / this.blockWidth * this.blockWidth, clipRect.y / this.blockHeight * this.blockHeight);
        Point bottomRight = new Point((clipRect.x + clipRect.width - 1) / this.blockWidth * this.blockWidth, (clipRect.y + clipRect.height - 1) / this.blockHeight * this.blockHeight);
        int maxBlock = this.gridWidth * this.gridHeight;
        Disk d = this.formattedDisk.getDisk();
        int y = topLeft.y;
        while (y <= bottomRight.y) {
            int x = topLeft.x;
            while (x <= bottomRight.x) {
                int blockNo = y / this.blockHeight * this.gridWidth + x / this.blockWidth;
                if (blockNo < maxBlock) {
                    SectorType type = this.formattedDisk.getSectorType(blockNo);
                    if (type == null) {
                        System.out.println("Sector type is null " + blockNo);
                    } else {
                        DiskAddress da = d.getDiskAddress(blockNo);
                        boolean free = this.showFreeSectors && this.formattedDisk.isSectorFree(da);
                        boolean selected = this.selectionHandler.isSelected(da);
                        this.drawBlock((Graphics2D)g, type, x, y, free, selected);
                    }
                }
                x += this.blockWidth;
            }
            y += this.blockHeight;
        }
    }

    private void drawBlock(Graphics2D g, SectorType type, int x, int y, boolean flagFree, boolean selected) {
        g.setColor(type.colour);
        g.fillRect(x + 1, y + 1, this.blockWidth - 1, this.blockHeight - 1);
        if (flagFree || selected) {
            g.setColor(this.getContrastColor(type));
            if (flagFree) {
                g.drawOval(x + this.centerOffset - 2, y + 4, 7, 7);
            }
            if (selected) {
                g.fillOval(x + this.centerOffset, y + 6, 3, 3);
            }
        }
    }

    private Color getContrastColor(SectorType type) {
        Color[] colorArray = lightColors;
        int n = lightColors.length;
        int n2 = 0;
        while (n2 < n) {
            Color color = colorArray[n2];
            if (type.colour == color) {
                return Color.BLACK;
            }
            ++n2;
        }
        return Color.WHITE;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(241, 526);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 0 ? this.blockWidth : this.blockHeight;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 0 ? this.blockWidth * 4 : this.blockHeight * 10;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public void redo(RedoHandler.RedoEvent redoEvent) {
        this.redo = true;
        SectorSelectedEvent event = (SectorSelectedEvent)redoEvent.value;
        this.setSelection(event.getSectors());
        this.fireSectorSelectionEvent(event);
        this.redo = false;
        this.requestFocusInWindow();
    }

    private void fireSectorSelectionEvent() {
        SectorSelectedEvent event = new SectorSelectedEvent(this, this.selectionHandler.getHighlights(), this.formattedDisk);
        this.fireSectorSelectionEvent(event);
    }

    private void fireSectorSelectionEvent(SectorSelectedEvent event) {
        SectorSelectionListener[] listeners;
        event.redo = this.redo;
        SectorSelectionListener[] sectorSelectionListenerArray = listeners = (SectorSelectionListener[])this.listenerList.getListeners(SectorSelectionListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SectorSelectionListener listener = sectorSelectionListenerArray[n2];
            listener.sectorSelected(event);
            ++n2;
        }
    }

    public void addSectorSelectionListener(SectorSelectionListener listener) {
        this.listenerList.add(SectorSelectionListener.class, listener);
    }

    public void removeSectorSelectionListener(SectorSelectionListener listener) {
        this.listenerList.remove(SectorSelectionListener.class, listener);
    }

    class MyKeyListener
    extends KeyAdapter {
        MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    DiskLayoutImage.this.selectionHandler.cursorMove(DiskLayoutImage.this.formattedDisk, e);
                    DiskLayoutImage.this.fireSectorSelectionEvent();
                    DiskLayoutImage.this.repaint();
                }
            }
        }
    }

    class MyMouseListener
    extends MouseAdapter {
        private Cursor currentCursor;

        MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int x = e.getX() / DiskLayoutImage.this.blockWidth;
            int y = e.getY() / DiskLayoutImage.this.blockHeight;
            int blockNo = y * DiskLayoutImage.this.gridWidth + x;
            DiskAddress da = DiskLayoutImage.this.formattedDisk.getDisk().getDiskAddress(blockNo);
            boolean extend = (e.getModifiersEx() & 0x40) > 0;
            boolean append = (e.getModifiersEx() & 0x80) > 0;
            DiskLayoutImage.this.selectionHandler.doClick(DiskLayoutImage.this.formattedDisk.getDisk(), da, extend, append);
            DiskLayoutImage.this.fireSectorSelectionEvent();
            DiskLayoutImage.this.repaint();
            DiskLayoutImage.this.requestFocusInWindow();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.currentCursor = DiskLayoutImage.this.getCursor();
            DiskLayoutImage.this.setCursor(crosshairCursor);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            DiskLayoutImage.this.setCursor(this.currentCursor);
        }
    }
}

