/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.duplicates.RootFolderData;
import com.bytezone.diskbrowser.gui.CatalogPanel;
import com.bytezone.diskbrowser.gui.CloseTabAction;
import com.bytezone.diskbrowser.gui.DiskLayoutPanel;
import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.DiskSelectionListener;
import com.bytezone.diskbrowser.gui.DuplicateAction;
import com.bytezone.diskbrowser.gui.HideCatalogAction;
import com.bytezone.diskbrowser.gui.HideLayoutAction;
import com.bytezone.diskbrowser.gui.MenuHandler;
import com.bytezone.diskbrowser.gui.OutputPanel;
import com.bytezone.diskbrowser.gui.PrintAction;
import com.bytezone.diskbrowser.gui.QuitListener;
import com.bytezone.diskbrowser.gui.RedoHandler;
import com.bytezone.diskbrowser.gui.RefreshTreeAction;
import com.bytezone.diskbrowser.gui.RootDirectoryAction;
import com.bytezone.diskbrowser.gui.ScaleAction;
import com.bytezone.diskbrowser.gui.ShowFreeSectorsAction;
import com.bytezone.diskbrowser.gui.WindowSaver;
import com.bytezone.diskbrowser.gui.WindowState;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.UIManager;

public class DiskBrowser
extends JFrame
implements DiskSelectionListener,
QuitListener,
PropertyChangeListener {
    private static String[] args;
    private static final String windowTitle = "Apple ][ Disk Browser";
    private final Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private WindowSaver windowSaver;
    private static final String OS;
    private static final boolean MAC;
    private final RootFolderData rootFolderData = new RootFolderData();
    private final List<QuitListener> quitListeners = new ArrayList<QuitListener>();
    private final JPanel catalogBorderPanel;
    private final JPanel layoutBorderPanel;
    private final HideCatalogAction hideCatalogAction = new HideCatalogAction();
    private final HideLayoutAction hideLayoutAction = new HideLayoutAction();

    static {
        OS = System.getProperty("os.name").toLowerCase();
        MAC = OS.startsWith("mac os");
    }

    public DiskBrowser() {
        super(windowTitle);
        if (args.length > 0 && "-reset".equals(args[0])) {
            new WindowState(this.prefs).clear();
        }
        JToolBar toolBar = new JToolBar("Toolbar", 0);
        MenuHandler menuHandler = new MenuHandler();
        this.setJMenuBar(menuHandler.menuBar);
        this.setLayout(new BorderLayout());
        this.add((Component)toolBar, "North");
        RedoHandler redoHandler = new RedoHandler(this.getRootPane(), toolBar);
        toolBar.addSeparator();
        CatalogPanel catalogPanel = new CatalogPanel(redoHandler);
        this.catalogBorderPanel = this.addPanel(catalogPanel, "Catalog", "West");
        OutputPanel dataPanel = new OutputPanel(menuHandler);
        this.addPanel(dataPanel, "Output", "Center");
        DiskLayoutPanel diskLayoutPanel = new DiskLayoutPanel();
        this.layoutBorderPanel = this.addPanel(diskLayoutPanel, "Disk layout", "East");
        DuplicateAction duplicateAction = new DuplicateAction(this.rootFolderData);
        RootDirectoryAction rootDirectoryAction = new RootDirectoryAction();
        RefreshTreeAction refreshTreeAction = new RefreshTreeAction(catalogPanel);
        PrintAction print = new PrintAction(dataPanel);
        ShowFreeSectorsAction showFreeAction = new ShowFreeSectorsAction();
        CloseTabAction closeTabAction = new CloseTabAction(catalogPanel);
        this.hideCatalogAction.addPropertyChangeListener(this);
        this.hideLayoutAction.addPropertyChangeListener(this);
        toolBar.add(rootDirectoryAction);
        toolBar.add(refreshTreeAction);
        toolBar.add(duplicateAction);
        toolBar.add(print);
        rootDirectoryAction.addPropertyChangeListener(this.rootFolderData);
        rootDirectoryAction.addPropertyChangeListener(catalogPanel);
        rootDirectoryAction.addPropertyChangeListener(duplicateAction);
        catalogPanel.addDiskSelectionListener(this, dataPanel, diskLayoutPanel, redoHandler, menuHandler, menuHandler.saveDiskAction);
        catalogPanel.addFileSelectionListener(dataPanel, diskLayoutPanel, redoHandler, menuHandler, menuHandler.saveFileAction);
        catalogPanel.addFileNodeSelectionListener(dataPanel, redoHandler);
        diskLayoutPanel.addSectorSelectionListener(dataPanel, redoHandler, catalogPanel, menuHandler.saveSectorsAction);
        duplicateAction.addTableSelectionListener(catalogPanel);
        menuHandler.scale1Item.setAction(new ScaleAction(dataPanel, 1.0, 1));
        menuHandler.scale2Item.setAction(new ScaleAction(dataPanel, 1.5, 2));
        menuHandler.scale3Item.setAction(new ScaleAction(dataPanel, 2.0, 3));
        redoHandler.addRedoListener(catalogPanel);
        redoHandler.addRedoListener(diskLayoutPanel);
        menuHandler.fontAction.addFontChangeListener(dataPanel);
        menuHandler.fontAction.addFontChangeListener(catalogPanel);
        menuHandler.printItem.setAction(print);
        menuHandler.refreshTreeItem.setAction(refreshTreeAction);
        menuHandler.rootItem.setAction(rootDirectoryAction);
        menuHandler.showCatalogItem.setAction(this.hideCatalogAction);
        menuHandler.showLayoutItem.setAction(this.hideLayoutAction);
        menuHandler.showFreeSectorsItem.setAction(showFreeAction);
        menuHandler.duplicateItem.setAction(duplicateAction);
        menuHandler.closeTabItem.setAction(closeTabAction);
        showFreeAction.addPropertyChangeListener(diskLayoutPanel);
        this.quitListeners.add(rootDirectoryAction);
        this.quitListeners.add(menuHandler);
        this.quitListeners.add(catalogPanel);
        this.quitListeners.add(this);
        if (Desktop.isDesktopSupported()) {
            Desktop desktop = Desktop.getDesktop();
            if (desktop.isSupported(Desktop.Action.APP_ABOUT)) {
                desktop.setAboutHandler(e -> JOptionPane.showMessageDialog(null, "Author - Denis Molony\nGitHub - https://github.com/dmolony/DiskBrowser", "About DiskBrowser", 1));
            }
            if (desktop.isSupported(Desktop.Action.APP_QUIT_HANDLER)) {
                desktop.setQuitHandler((e, r) -> this.fireQuitEvent());
            }
            this.setQuitHandler();
        } else {
            System.out.println("Desktop not supported");
            this.setQuitHandler();
        }
        catalogPanel.setCloseTabAction(closeTabAction);
        this.pack();
        this.fireRestoreEvent();
        diskLayoutPanel.setFree(menuHandler.showFreeSectorsItem.isSelected());
        dataPanel.setLineWrap(menuHandler.lineWrapItem.isSelected());
        if (!menuHandler.showLayoutItem.isSelected()) {
            this.setLayoutPanel(false);
        }
        if (!menuHandler.showCatalogItem.isSelected()) {
            this.setCatalogPanel(false);
        }
        menuHandler.addBasicPreferencesListener(dataPanel);
        menuHandler.addAssemblerPreferencesListener(dataPanel);
        menuHandler.addTextPreferencesListener(dataPanel);
        catalogPanel.activate();
    }

    private void setQuitHandler() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DiskBrowser.this.fireQuitEvent();
            }
        });
    }

    private JPanel addPanel(JComponent pane, String title, String location) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.WHITE);
        panel.setBorder(BorderFactory.createTitledBorder(title));
        panel.add(pane);
        this.add((Component)panel, location);
        return panel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.hideCatalogAction) {
            this.setCatalogPanel((Boolean)evt.getNewValue());
        } else if (evt.getSource() == this.hideLayoutAction) {
            this.setLayoutPanel((Boolean)evt.getNewValue());
        }
    }

    private void setCatalogPanel(boolean show) {
        if (show) {
            this.add((Component)this.catalogBorderPanel, "West");
        } else {
            this.remove(this.catalogBorderPanel);
        }
        this.validate();
    }

    private void setLayoutPanel(boolean show) {
        if (show) {
            this.add((Component)this.layoutBorderPanel, "East");
        } else {
            this.remove(this.layoutBorderPanel);
        }
        this.validate();
    }

    @Override
    public void diskSelected(DiskSelectedEvent e) {
        this.setTitle(windowTitle + e.getFormattedDisk() == null ? "" : e.getFormattedDisk().getName());
    }

    @Override
    public void quit(Preferences preferences) {
        this.windowSaver.saveWindow();
    }

    @Override
    public void restore(Preferences preferences) {
        this.windowSaver = new WindowSaver(this.prefs, this, "DiskBrowser");
        this.windowSaver.restoreWindow();
    }

    private static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            if (MAC) {
                System.setProperty("apple.laf.useScreenMenuBar", "true");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void fireQuitEvent() {
        for (QuitListener listener : this.quitListeners) {
            listener.quit(this.prefs);
        }
        System.exit(0);
    }

    private void fireRestoreEvent() {
        for (QuitListener listener : this.quitListeners) {
            listener.restore(this.prefs);
        }
    }

    public static void main(String[] args) {
        DiskBrowser.args = args;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiskBrowser.setLookAndFeel();
                new DiskBrowser().setVisible(true);
            }
        });
    }
}

