/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.DiskSelectionListener;
import com.bytezone.diskbrowser.gui.FileNodeSelectedEvent;
import com.bytezone.diskbrowser.gui.FileNodeSelectionListener;
import com.bytezone.diskbrowser.gui.FileSelectedEvent;
import com.bytezone.diskbrowser.gui.FileSelectionListener;
import com.bytezone.diskbrowser.gui.TreeBuilder;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;

class DiskAndFileSelector {
    EventListenerList listenerList = new EventListenerList();
    FormattedDisk currentDisk;
    boolean redo;

    DiskAndFileSelector() {
    }

    public void addDiskSelectionListener(DiskSelectionListener listener) {
        this.listenerList.add(DiskSelectionListener.class, listener);
    }

    public void removeDiskSelectionListener(DiskSelectionListener listener) {
        this.listenerList.remove(DiskSelectionListener.class, listener);
    }

    public void addFileNodeSelectionListener(FileNodeSelectionListener listener) {
        this.listenerList.add(FileNodeSelectionListener.class, listener);
    }

    public void removeFileNodeSelectionListener(FileNodeSelectionListener listener) {
        this.listenerList.remove(FileNodeSelectionListener.class, listener);
    }

    void fireDiskSelectionEvent(TreeBuilder.FileNode node) {
        if (node.file.isDirectory()) {
            this.fireFileNodeSelectionEvent(node);
            this.currentDisk = null;
        } else {
            FormattedDisk fd = node.getFormattedDisk();
            if (fd == null) {
                JOptionPane.showMessageDialog(null, "Unrecognised file format", "Format error", 0);
            } else {
                this.fireDiskSelectionEvent(fd);
            }
        }
    }

    void fireFileNodeSelectionEvent(TreeBuilder.FileNode node) {
        FileNodeSelectionListener[] listeners;
        FileNodeSelectedEvent e = new FileNodeSelectedEvent(this, node);
        e.redo = this.redo;
        FileNodeSelectionListener[] fileNodeSelectionListenerArray = listeners = (FileNodeSelectionListener[])this.listenerList.getListeners(FileNodeSelectionListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            FileNodeSelectionListener listener = fileNodeSelectionListenerArray[n2];
            listener.fileNodeSelected(e);
            ++n2;
        }
    }

    void fireDiskSelectionEvent(FormattedDisk disk) {
        DiskSelectionListener[] listeners;
        if (disk == this.currentDisk) {
            return;
        }
        if (disk == null) {
            System.out.println("Null disk in fireDiskSelectionEvent()");
            return;
        }
        DiskSelectedEvent e = new DiskSelectedEvent(this, disk);
        e.redo = this.redo;
        DiskSelectionListener[] diskSelectionListenerArray = listeners = (DiskSelectionListener[])this.listenerList.getListeners(DiskSelectionListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            DiskSelectionListener listener = diskSelectionListenerArray[n2];
            listener.diskSelected(e);
            ++n2;
        }
        this.currentDisk = disk;
    }

    public void addFileSelectionListener(FileSelectionListener listener) {
        this.listenerList.add(FileSelectionListener.class, listener);
    }

    public void removeFileSelectionListener(FileSelectionListener listener) {
        this.listenerList.remove(FileSelectionListener.class, listener);
    }

    void fireFileSelectionEvent(AppleFileSource file) {
        FileSelectionListener[] listeners;
        assert (file != null);
        this.currentDisk = null;
        FileSelectedEvent e = new FileSelectedEvent(this, file);
        e.redo = this.redo;
        FileSelectionListener[] fileSelectionListenerArray = listeners = (FileSelectionListener[])this.listenerList.getListeners(FileSelectionListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            FileSelectionListener listener = fileSelectionListenerArray[n2];
            listener.fileSelected(e);
            ++n2;
        }
    }
}

