/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.disk.DiskFactory;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.HybridDisk;
import com.bytezone.diskbrowser.gui.AbstractTab;
import com.bytezone.diskbrowser.gui.DiskAndFileSelector;
import com.bytezone.diskbrowser.gui.FileSelectedEvent;
import com.bytezone.diskbrowser.gui.RedoHandler;
import com.bytezone.diskbrowser.gui.SectorSelectedEvent;
import java.awt.Font;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class AppleDiskTab
extends AbstractTab {
    FormattedDisk disk;

    public AppleDiskTab(FormattedDisk disk, DiskAndFileSelector selector, RedoHandler redoHandler, Font font, FileSelectedEvent event) {
        super(redoHandler, selector, font);
        this.create(disk);
        redoHandler.fileSelected(event);
    }

    public AppleDiskTab(FormattedDisk disk, DiskAndFileSelector selector, RedoHandler redoHandler, Font font, SectorSelectedEvent event) {
        super(redoHandler, selector, font);
        this.create(disk);
        redoHandler.sectorSelected(event);
    }

    public AppleDiskTab(FormattedDisk disk, DiskAndFileSelector selector, RedoHandler redoHandler, Font font, String lastFileUsed) {
        super(redoHandler, selector, font);
        this.create(disk);
        DefaultMutableTreeNode node = this.findNode(lastFileUsed);
        if (node != null) {
            AppleFileSource afs = (AppleFileSource)node.getUserObject();
            FileSelectedEvent event = new FileSelectedEvent(this, afs);
            redoHandler.fileSelected(event);
        }
    }

    public AppleDiskTab(FormattedDisk disk, DiskAndFileSelector selector, RedoHandler redoHandler, Font font) {
        super(redoHandler, selector, font);
        this.create(disk);
        AppleFileSource afs = (AppleFileSource)this.findNode(2).getUserObject();
        if (afs == null) {
            afs = (AppleFileSource)this.findNode(1).getUserObject();
        }
        redoHandler.fileSelected(new FileSelectedEvent(this, afs));
    }

    private void create(FormattedDisk disk) {
        this.disk = disk;
        this.setTree(disk.getCatalogTree());
        this.setSelectionListener(this.tree);
    }

    @Override
    public void activate() {
        this.eventHandler.redo = true;
        this.eventHandler.fireDiskSelectionEvent(this.disk);
        this.eventHandler.redo = false;
        this.tree.setSelectionPath(null);
        this.redoHandler.setCurrentData(this.redoData);
    }

    @Override
    public void refresh() {
        Object o = this.getSelectedObject();
        String currentFile = o == null ? null : ((AppleFileSource)o).getUniqueName();
        this.disk = DiskFactory.createDisk(this.disk.getAbsolutePath());
        this.setTree(this.disk.getCatalogTree());
        this.setSelectionListener(this.tree);
        this.selectNode(currentFile);
    }

    private void selectNode(String nodeName) {
        DefaultMutableTreeNode selectNode = null;
        if (nodeName != null) {
            selectNode = this.findNode(nodeName);
        }
        if (selectNode == null) {
            selectNode = this.findNode(2);
        }
        if (selectNode != null) {
            this.showNode(selectNode);
        } else {
            System.out.println("First node not found");
        }
    }

    void redoEvent(RedoHandler.RedoEvent event) {
        AppleFileSource afs = ((FileSelectedEvent)event.value).appleFileSource;
        FileSelectedEvent fileSelectedEvent = (FileSelectedEvent)event.value;
        if (fileSelectedEvent.volumeNo >= 0) {
            HybridDisk ddd = (HybridDisk)afs.getFormattedDisk().getParent();
            ddd.setCurrentDiskNo(fileSelectedEvent.volumeNo);
        }
        this.selectNode(fileSelectedEvent.appleFileSource.getUniqueName());
    }

    private DefaultMutableTreeNode findNode(String nodeName) {
        DefaultMutableTreeNode rootNode = this.getRootNode();
        FormattedDisk fd = ((AppleFileSource)rootNode.getUserObject()).getFormattedDisk();
        if (fd instanceof HybridDisk var4_5) {
            int volume = hd.getCurrentDiskNo();
            rootNode = (DefaultMutableTreeNode)rootNode.getChildAt(volume);
        }
        Enumeration<TreeNode> children = rootNode.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            Object userObject = node.getUserObject();
            Object object = userObject;
            if (!(object instanceof AppleFileSource) || (var9_10 = (AppleFileSource)object) != (AppleFileSource)object || !nodeName.equals(afs.getUniqueName())) continue;
            return node;
        }
        return null;
    }

    public boolean contains(FormattedDisk disk) {
        return this.disk.getAbsolutePath().equals(disk.getAbsolutePath());
    }

    private void setSelectionListener(JTree tree) {
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AppleFileSource afs = (AppleFileSource)AppleDiskTab.this.getSelectedObject();
                if (afs != null) {
                    AppleDiskTab.this.eventHandler.fireFileSelectionEvent(afs);
                }
            }
        });
    }
}

