/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.duplicates;

import com.bytezone.diskbrowser.duplicates.DiskDetails;
import com.bytezone.diskbrowser.duplicates.RootFolderData;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class DiskTableModel
extends AbstractTableModel {
    static final String[] headers = new String[]{"Path", "Name", "Type", "Size", "# names", "Checksum", "# checksums"};
    private final List<TableLine> lines = new ArrayList<TableLine>();
    private final RootFolderData rootFolderData;

    DiskTableModel(RootFolderData rootFolderData) {
        this.rootFolderData = rootFolderData;
        for (String key : rootFolderData.fileNameMap.keySet()) {
            DiskDetails original = rootFolderData.fileNameMap.get(key);
            this.lines.add(new TableLine(original, rootFolderData));
            for (DiskDetails duplicate : original.getDuplicateNames()) {
                this.lines.add(new TableLine(duplicate, rootFolderData));
            }
        }
    }

    public DiskDetails getDiskDetails(int rowIndex) {
        return this.lines.get((int)rowIndex).diskDetails;
    }

    @Override
    public String getColumnName(int column) {
        return headers[column];
    }

    @Override
    public int getRowCount() {
        return this.lines.size();
    }

    @Override
    public int getColumnCount() {
        if (this.rootFolderData.doChecksums) {
            return headers.length;
        }
        return headers.length - 1;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.lines.isEmpty() ? Object.class : this.getValueAt(0, columnIndex).getClass();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TableLine line = this.lines.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return line.path;
            }
            case 1: {
                return line.fileName;
            }
            case 2: {
                return line.type;
            }
            case 3: {
                return line.size;
            }
            case 4: {
                return line.duplicateNames;
            }
            case 5: {
                return line.checksum;
            }
            case 6: {
                return line.duplicateChecksums;
            }
        }
        return "???";
    }

    public String getCSV(int rowIndex) {
        TableLine line = this.lines.get(rowIndex);
        return String.format("\"%s\",\"%s\",%s,%d,%s,%s,%d%n", line.path, line.shortName, line.type, line.size, line.duplicateNames, line.duplicateChecksums, line.checksum);
    }

    void updateChecksum(int rowIndex) {
        TableLine line = this.lines.get(rowIndex);
        line.checksum = line.diskDetails.calculateChecksum();
        this.fireTableCellUpdated(rowIndex, 5);
    }

    class TableLine {
        private final String shortName;
        private final String fileName;
        private final String path;
        private long checksum;
        private final int duplicateNames;
        private final int duplicateChecksums;
        final DiskDetails diskDetails;
        private final String type;
        private final long size;

        public TableLine(DiskDetails diskDetails, RootFolderData rootFolderData) {
            DiskDetails original;
            this.diskDetails = diskDetails;
            this.shortName = diskDetails.getShortName();
            this.fileName = diskDetails.getFileName();
            this.checksum = diskDetails.getChecksum();
            this.type = diskDetails.getType();
            this.size = diskDetails.getFile().length();
            String rootName = diskDetails.getRootName();
            this.path = rootName.substring(0, rootName.length() - this.shortName.length());
            if (rootFolderData.doChecksums) {
                if (diskDetails.isDuplicateChecksum()) {
                    original = rootFolderData.checksumMap.get(diskDetails.getChecksum());
                    this.duplicateChecksums = original.getDuplicateChecksums().size() + 1;
                } else {
                    this.duplicateChecksums = diskDetails.getDuplicateChecksums().size() + 1;
                }
            } else {
                this.duplicateChecksums = 0;
            }
            if (diskDetails.isDuplicateName()) {
                original = rootFolderData.fileNameMap.get(diskDetails.getShortName());
                this.duplicateNames = original.getDuplicateNames().size() + 1;
            } else {
                this.duplicateNames = diskDetails.getDuplicateNames().size() + 1;
            }
        }
    }
}

