/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.duplicates;

import com.bytezone.diskbrowser.utilities.Utility;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class DiskDetails {
    private final File file;
    private long checksum;
    private final String rootName;
    private final String shortName;
    private final String type;
    private final long size;
    private final List<DiskDetails> duplicateChecksums = new ArrayList<DiskDetails>();
    private final List<DiskDetails> duplicateNames = new ArrayList<DiskDetails>();
    private boolean isDuplicateName;
    private boolean isDuplicateChecksum;

    public DiskDetails(File file, String rootName, String shortName, boolean doChecksum) {
        this.file = file;
        this.rootName = rootName;
        this.shortName = shortName;
        this.type = Utility.getSuffix(shortName);
        this.size = file.length();
        this.checksum = doChecksum ? Utility.getChecksumValue(file) : 0L;
    }

    public File getFile() {
        return this.file;
    }

    public void addDuplicateChecksum(DiskDetails diskDetails) {
        if (this.checksum == diskDetails.checksum) {
            this.duplicateChecksums.add(diskDetails);
            diskDetails.isDuplicateChecksum = true;
        }
    }

    public void addDuplicateName(DiskDetails diskDetails) {
        if (this.shortName.equals(diskDetails.shortName)) {
            this.duplicateNames.add(diskDetails);
            diskDetails.isDuplicateName = true;
        }
    }

    public List<DiskDetails> getDuplicateChecksums() {
        return this.duplicateChecksums;
    }

    public List<DiskDetails> getDuplicateNames() {
        return this.duplicateNames;
    }

    public boolean isDuplicateChecksum() {
        return this.isDuplicateChecksum;
    }

    public boolean isDuplicateName() {
        return this.isDuplicateName;
    }

    public String getRootName() {
        return this.rootName;
    }

    public String getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getFileName() {
        return this.file.getName();
    }

    public long calculateChecksum() {
        this.checksum = Utility.getChecksumValue(this.file);
        return this.checksum;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public String toString() {
        return String.format("%3d %1.1s %3d %1.1s %-40s  ", this.duplicateChecksums.size(), this.isDuplicateChecksum, this.duplicateNames.size(), this.isDuplicateName, this.rootName);
    }
}

