/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.dos;

import com.bytezone.diskbrowser.disk.AbstractSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.dos.DosCatalogSector;
import com.bytezone.diskbrowser.dos.DosDisk;
import com.bytezone.diskbrowser.utilities.Utility;

class DosVTOCSector
extends AbstractSector {
    DosDisk parentDisk;
    int volume;
    int dosVersion;
    int maxTSPairs;
    int lastAllocTrack;
    int direction;
    int freeSectors;
    int usedSectors;
    int sectorSize;
    int maxSectors;
    int maxTracks;

    DosVTOCSector(DosDisk parentDisk, Disk disk, byte[] buffer, DiskAddress diskAddress) {
        super(disk, buffer, diskAddress);
        this.parentDisk = parentDisk;
        this.dosVersion = buffer[3];
        this.volume = buffer[6] & 0xFF;
        this.maxTSPairs = buffer[39];
        this.lastAllocTrack = buffer[48];
        this.direction = buffer[49];
        this.maxTracks = buffer[52] & 0xFF;
        this.maxSectors = buffer[53] & 0xFF;
        this.sectorSize = Utility.getShort(buffer, 54);
        this.flagSectors();
    }

    @Override
    public String createText() {
        return this.dosVersion <= 3 ? this.createDos3Text() : this.createDos4Text();
    }

    private String createDos3Text() {
        StringBuilder text = this.getHeader("VTOC Sector");
        this.addText(text, this.buffer, 0, 1, "Not used");
        this.addText(text, this.buffer, 1, 2, "First directory track/sector");
        this.addText(text, this.buffer, 3, 1, "DOS release number");
        this.addText(text, this.buffer, 4, 2, "Not used");
        this.addTextAndDecimal(text, this.buffer, 6, 1, "Diskette volume");
        this.addText(text, this.buffer, 7, 4, "Not used");
        this.addText(text, this.buffer, 11, 4, "Not used");
        this.addText(text, this.buffer, 15, 4, "Not used");
        this.addText(text, this.buffer, 19, 4, "Not used");
        this.addText(text, this.buffer, 23, 4, "Not used");
        this.addText(text, this.buffer, 27, 4, "Not used");
        this.addText(text, this.buffer, 31, 4, "Not used");
        this.addText(text, this.buffer, 35, 4, "Not used");
        this.addTextAndDecimal(text, this.buffer, 39, 1, "Maximum TS pairs");
        this.addText(text, this.buffer, 40, 4, "Not used");
        this.addText(text, this.buffer, 44, 4, "Not used");
        this.addTextAndDecimal(text, this.buffer, 48, 1, "Last allocated track");
        this.addText(text, this.buffer, 49, 1, "Direction to look when allocating the next file");
        this.addText(text, this.buffer, 50, 2, "Not used");
        this.addTextAndDecimal(text, this.buffer, 52, 1, "Maximum tracks");
        if (this.maxTracks != this.disk.getTotalTracks()) {
            text.deleteCharAt(text.length() - 1);
            text.append(String.format("            <-- Should be 0x%02X !!%n", this.disk.getTotalTracks()));
        }
        this.addTextAndDecimal(text, this.buffer, 53, 1, "Maximum sectors");
        this.addTextAndDecimal(text, this.buffer, 54, 2, "Bytes per sector");
        boolean bootSectorEmpty = this.parentDisk.getDisk().isBlockEmpty(0);
        int firstSector = 56;
        int max = this.maxTracks * 4 + firstSector;
        int i = firstSector;
        while (i < max) {
            String extra = "";
            if (i == firstSector && bootSectorEmpty) {
                extra = "(unusable)";
            }
            String bits = this.getBitmap(this.buffer, i);
            int track = (i - firstSector) / 4;
            this.addText(text, this.buffer, i, 4, String.format("Track %02X  %s  %s", track, bits, extra));
            i += 4;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    private String createDos4Text() {
        StringBuilder text = this.getHeader("DOS 4 VTOC Sector");
        this.addText(text, this.buffer, 0, 1, "Not used");
        this.addText(text, this.buffer, 1, 2, "First directory track/sector");
        this.addText(text, this.buffer, 3, 1, "DOS release number");
        this.addText(text, this.buffer, 4, 1, "Build number");
        this.addText(text, this.buffer, 5, 1, "Ram DOS " + (char)(this.buffer[5] & 0x7F));
        this.addTextAndDecimal(text, this.buffer, 6, 1, "Diskette volume");
        String diskType = this.buffer[7] == -60 ? " = Data" : (this.buffer[7] == -62 ? " = Boot" : "");
        this.addText(text, this.buffer, 7, 1, "Volume type: " + (char)(this.buffer[7] & 0x7F) + diskType);
        int ptr = 8;
        this.addText(text, this.buffer, ptr, 4, "Volume name: " + DosCatalogSector.getName(this.buffer, ptr, 30));
        int j = 4;
        while (j < 24) {
            this.addText(text, this.buffer, ptr + j, 4, "");
            j += 4;
        }
        this.addText(text, this.buffer, 32, 3, "Date/time initialised: " + Utility.getDateTime(this.buffer, 32));
        this.addText(text, this.buffer, 35, 3, "");
        this.addText(text, this.buffer, 38, 1, "VTOC Phase");
        this.addTextAndDecimal(text, this.buffer, 39, 1, "Maximum TS pairs");
        this.addText(text, this.buffer, 40, 2, "Volume library");
        this.addText(text, this.buffer, 42, 3, "Date/time modified: " + Utility.getDateTime(this.buffer, 42));
        this.addText(text, this.buffer, 45, 3, "");
        this.addTextAndDecimal(text, this.buffer, 48, 1, "Last allocated track");
        this.addText(text, this.buffer, 49, 1, "Direction to look when allocating the next file");
        this.addText(text, this.buffer, 50, 2, "Not used");
        this.addTextAndDecimal(text, this.buffer, 52, 1, "Maximum tracks");
        this.addTextAndDecimal(text, this.buffer, 53, 1, "Maximum sectors");
        this.addTextAndDecimal(text, this.buffer, 54, 2, "Bytes per sector");
        boolean bootSectorEmpty = this.parentDisk.getDisk().isBlockEmpty(0);
        int firstSector = 56;
        int max = this.maxTracks * 4 + firstSector;
        int i = firstSector;
        while (i < max) {
            String extra = "";
            if (i == firstSector && bootSectorEmpty) {
                extra = "(unusable)";
            } else if (i == 124) {
                extra = "(VTOC and Catalog)";
            }
            this.addText(text, this.buffer, i, 4, String.format("Track %02X  %s  %s", (i - firstSector) / 4, this.getBitmap(this.buffer, i), extra));
            i += 4;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    private String getBitmap(byte[] buffer, int offset) {
        int value = Utility.getLongBigEndian(buffer, offset);
        String bits = "0000000000000000000000000000000" + Integer.toBinaryString(value);
        bits = bits.substring(bits.length() - 32);
        bits = bits.substring(0, this.maxSectors);
        bits = bits.replace('0', 'X');
        bits = bits.replace('1', '.');
        return new StringBuilder(bits).reverse().toString();
    }

    private void flagSectors() {
        int firstSector = 56;
        int max = this.disk.getTotalTracks() * 4 + firstSector;
        int i = firstSector;
        while (i < max) {
            int track = (i - firstSector) / 4;
            String bits = this.getBitmap(this.buffer, i);
            int blockNo = track * this.maxSectors;
            char[] chars = bits.toCharArray();
            int sector = 0;
            while (sector < this.maxSectors) {
                if (chars[sector] == '.') {
                    this.parentDisk.setSectorFree(blockNo, true);
                    ++this.freeSectors;
                } else {
                    this.parentDisk.setSectorFree(blockNo, false);
                    ++this.usedSectors;
                }
                ++blockNo;
                ++sector;
            }
            i += 4;
        }
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        text.append("DOS version      : 3." + this.dosVersion);
        text.append("\nVolume           : " + this.volume);
        text.append("\nMax TS pairs     : " + this.maxTSPairs);
        text.append("\nLast allocated T : " + this.lastAllocTrack);
        text.append("\nDirection        : " + this.direction);
        return text.toString();
    }
}

