/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.dos;

import com.bytezone.diskbrowser.disk.AbstractSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.dos.DosDisk;
import com.bytezone.diskbrowser.utilities.Utility;

class DosTSListSector
extends AbstractSector {
    private final String name;

    DosTSListSector(String name, Disk disk, byte[] buffer, DiskAddress diskAddress) {
        super(disk, buffer, diskAddress);
        this.name = name;
    }

    public boolean isValid(DosDisk dosDisk) {
        int i = 12;
        while (i < this.buffer.length) {
            DiskAddress da = this.getValidAddress(this.buffer, i);
            if (da == null) {
                System.out.println("Invalid sector address : null");
                break;
            }
            if (da.getBlockNo() > 0 && dosDisk.stillAvailable(da)) {
                System.out.println("Invalid sector address : " + da);
                break;
            }
            i += 2;
        }
        return true;
    }

    protected DiskAddress getValidAddress(byte[] buffer, int offset) {
        if (this.disk.isValidAddress(buffer[offset], buffer[offset + 1])) {
            return this.disk.getDiskAddress(buffer[offset], buffer[offset + 1]);
        }
        return null;
    }

    @Override
    public String createText() {
        DiskAddress da = this.disk.getDiskAddress(this.buffer[1], this.buffer[2]);
        if (da == null) {
            return String.format("Invalid address: %02X %02X", this.buffer[1], this.buffer[2]);
        }
        String msg = da.matches(this.diskAddress) ? " (circular reference)" : "";
        StringBuilder text = this.getHeader("TS List Sector : " + this.name);
        this.addText(text, this.buffer, 0, 1, "Not used");
        this.addText(text, this.buffer, 1, 2, "Next TS list track/sector" + msg);
        if ((this.buffer[3] != 0 || this.buffer[4] != 0) && this.diskAddress.getTrackNo() == (this.buffer[3] & 0xFF) && this.diskAddress.getSectorNo() == (this.buffer[4] & 0xFF)) {
            this.addText(text, this.buffer, 3, 2, "Self-reference");
        } else {
            this.addText(text, this.buffer, 3, 2, "Not used");
        }
        this.addTextAndDecimal(text, this.buffer, 5, 2, "Sector base number");
        this.addText(text, this.buffer, 7, 4, "Not used");
        this.addText(text, this.buffer, 11, 1, "Not used");
        int sectorBase = Utility.getShort(this.buffer, 5);
        int i = 12;
        while (i <= 255) {
            if (this.buffer[i] == 0 && this.buffer[i + 1] == 0) {
                msg = "";
            } else {
                String msg2 = this.buffer[i] == 64 ? "  - track zero" : "";
                msg = String.format("Track/sector of file sector %04X (%<,d)%s", (i - 12) / 2 + sectorBase, msg2);
            }
            this.addText(text, this.buffer, i, 2, msg);
            i += 2;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }
}

