/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.dos;

import com.bytezone.diskbrowser.disk.AbstractSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.dos.DosDisk;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;

class DosCatalogSector
extends AbstractSector {
    private static final String[] fileTypes = new String[]{"Text file", "Integer Basic program", "Applesoft Basic program", "Binary file", "SS file", "Relocatable file", "AA file", "Lisa file"};
    private static int CATALOG_ENTRY_SIZE = 35;
    private final DosDisk dosDisk;

    DosCatalogSector(DosDisk dosDisk, Disk disk, byte[] buffer, DiskAddress diskAddress) {
        super(disk, buffer, diskAddress);
        this.dosDisk = dosDisk;
    }

    @Override
    public String createText() {
        StringBuilder text = this.getHeader("DOS " + this.dosDisk.getVersionText() + " Catalog Sector");
        this.addText(text, this.buffer, 0, 1, "Not used");
        this.addText(text, this.buffer, 1, 2, "Next catalog track/sector");
        this.addText(text, this.buffer, 3, 4, "Not used");
        this.addText(text, this.buffer, 7, 4, "Not used");
        boolean dos4 = this.dosDisk.getVersion() > 3;
        int i = 11;
        while (i <= 255) {
            text.append("\n");
            if (dos4) {
                this.createDos4Text(text, i);
            } else {
                this.createDos3Text(text, i);
            }
            i += CATALOG_ENTRY_SIZE;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    private void createDos4Text(StringBuilder text, int i) {
        boolean lockedFlag;
        int track = this.buffer[i] & 0x3F;
        int sector = this.buffer[i + 1] & 0x1F;
        int fileType = this.buffer[i + 2] & 0x7F;
        boolean deleteFlag = (this.buffer[i] & 0x80) != 0;
        boolean zeroTrackFlag = (this.buffer[i] & 0x40) != 0;
        boolean bl = lockedFlag = (this.buffer[i + 2] & 0x80) != 0;
        if (this.buffer[i] == 0 && !zeroTrackFlag) {
            this.addText(text, this.buffer, i + 0, 2, "");
            this.addText(text, this.buffer, i + 2, 1, "");
            this.addText(text, this.buffer, i + 3, 4, "");
            this.addText(text, this.buffer, i + 33, 2, "");
        } else {
            this.addText(text, this.buffer, i, 1, String.format("TS list track (%s, %s)", deleteFlag ? "deleted" : "not deleted", zeroTrackFlag ? "track zero" : "not track zero"));
            this.addText(text, this.buffer, i + 1, 1, "TS list sector");
            this.addText(text, this.buffer, i + 2, 1, String.format("File type (%s)", lockedFlag ? "locked" : "unlocked"));
            this.addText(text, this.buffer, i + 3, 4, DosCatalogSector.getName(this.buffer, i + 3, 24));
            int j = 0;
            while (j < 20) {
                this.addText(text, this.buffer, i + 7 + j, 4, "");
                j += 4;
            }
            this.addText(text, this.buffer, i + 27, 3, "Date/time initialised: " + Utility.getDateTime(this.buffer, i + 27));
            this.addText(text, this.buffer, i + 30, 3, "");
            this.addTextAndDecimal(text, this.buffer, i + 33, 2, "File size");
        }
    }

    private void createDos3Text(StringBuilder text, int i) {
        if (this.buffer[i] == -1) {
            this.addText(text, this.buffer, i, 2, "DEL: file @ " + HexFormatter.format2(this.buffer[i + 32]) + " " + HexFormatter.format2(this.buffer[i + 1]));
            this.addText(text, this.buffer, i + 2, 1, "DEL: File type " + this.getType(this.buffer[i + 2]));
            if (this.buffer[i + 3] == 0) {
                this.addText(text, this.buffer, i + 3, 4, "");
            } else {
                this.addText(text, this.buffer, i + 3, 4, "DEL: " + DosCatalogSector.getName(this.buffer, i + 3, 29));
            }
            this.addTextAndDecimal(text, this.buffer, i + 33, 2, "DEL: Sector count");
        } else if (this.buffer[i] > 0) {
            this.addText(text, this.buffer, i, 2, "TS list track/sector");
            this.addText(text, this.buffer, i + 2, 1, "File type " + this.getType(this.buffer[i + 2]));
            if (this.buffer[i + 3] == 0) {
                this.addText(text, this.buffer, i + 3, 4, "");
            } else {
                this.addText(text, this.buffer, i + 3, 4, DosCatalogSector.getName(this.buffer, i + 3, 30));
                int j = 0;
                while (j < 24) {
                    this.addText(text, this.buffer, i + j + 7, 4, "");
                    j += 4;
                }
                this.addText(text, this.buffer, i + 31, 2, "");
            }
            this.addTextAndDecimal(text, this.buffer, i + 33, 2, "Sector count");
        } else {
            this.addText(text, this.buffer, i + 0, 2, "");
            this.addText(text, this.buffer, i + 2, 1, "");
            this.addText(text, this.buffer, i + 3, 4, "");
            this.addText(text, this.buffer, i + 33, 2, "");
        }
    }

    static String getName(byte[] buffer, int offset, int length) {
        StringBuilder text = new StringBuilder();
        int i = offset;
        while (i < offset + length) {
            int c = buffer[i] & 0xFF;
            if (c == 136) {
                if (text.length() > 0) {
                    text.deleteCharAt(text.length() - 1);
                }
            } else {
                if (c > 127) {
                    c -= c < 160 ? 64 : 128;
                }
                if (c < 32) {
                    text.append("^" + (char)(c + 64));
                } else {
                    text.append((char)c);
                }
            }
            ++i;
        }
        return text.toString();
    }

    private String getType(byte value) {
        int type = value & 0x7F;
        boolean locked = (value & 0x80) > 0;
        int val = 7;
        int i = 64;
        while (i > type) {
            --val;
            i /= 2;
        }
        return "(" + fileTypes[val] + (locked ? ", locked)" : ", unlocked)");
    }
}

