/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.dos;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.applefile.ApplesoftBasicProgram;
import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.applefile.BasicTextFile;
import com.bytezone.diskbrowser.applefile.DefaultAppleFile;
import com.bytezone.diskbrowser.applefile.DoubleHiResImage;
import com.bytezone.diskbrowser.applefile.ErrorMessageFile;
import com.bytezone.diskbrowser.applefile.FontFile;
import com.bytezone.diskbrowser.applefile.HiResImage;
import com.bytezone.diskbrowser.applefile.IntegerBasicProgram;
import com.bytezone.diskbrowser.applefile.MagicWindowText;
import com.bytezone.diskbrowser.applefile.MerlinSource;
import com.bytezone.diskbrowser.applefile.OriginalHiResImage;
import com.bytezone.diskbrowser.applefile.PrintShopGraphic;
import com.bytezone.diskbrowser.applefile.ShapeTable;
import com.bytezone.diskbrowser.applefile.VisicalcFile;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.dos.CatalogEntry;
import com.bytezone.diskbrowser.dos.DosDisk;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.utilities.Utility;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

abstract class AbstractCatalogEntry
implements AppleFileSource {
    protected Disk disk;
    protected DosDisk dosDisk;
    protected String name;
    protected String catalogName;
    protected String displayName;
    protected DosDisk.FileType fileType;
    protected int reportedSize;
    protected boolean locked;
    protected DataSource appleFile;
    protected LocalDateTime lastModified;
    protected DiskAddress catalogSectorDA;
    protected final List<DiskAddress> dataSectors = new ArrayList<DiskAddress>();
    protected final List<DiskAddress> tsSectors = new ArrayList<DiskAddress>();
    private CatalogEntry link;

    AbstractCatalogEntry(DosDisk dosDisk, DiskAddress catalogSector, byte[] entryBuffer) {
        this.dosDisk = dosDisk;
        this.disk = dosDisk.getDisk();
        this.catalogSectorDA = catalogSector;
        this.name = this.getName("", entryBuffer);
        this.reportedSize = Utility.getShort(entryBuffer, 33);
        int type = entryBuffer[2] & 0x7F;
        this.locked = (entryBuffer[2] & 0x80) != 0;
        switch (type) {
            case 0: {
                DosDisk.FileType fileType = DosDisk.FileType.Text;
                break;
            }
            case 1: {
                DosDisk.FileType fileType = DosDisk.FileType.IntegerBasic;
                break;
            }
            case 2: {
                DosDisk.FileType fileType = DosDisk.FileType.ApplesoftBasic;
                break;
            }
            case 4: {
                DosDisk.FileType fileType = DosDisk.FileType.Binary;
                break;
            }
            case 8: {
                DosDisk.FileType fileType = DosDisk.FileType.SS;
                break;
            }
            case 16: {
                DosDisk.FileType fileType = DosDisk.FileType.Relocatable;
                break;
            }
            case 32: {
                DosDisk.FileType fileType = DosDisk.FileType.AA;
                break;
            }
            case 64: {
                DosDisk.FileType fileType = DosDisk.FileType.BB;
                break;
            }
            default: {
                DosDisk.FileType fileType = this.fileType = DosDisk.FileType.Binary;
            }
        }
        if (dosDisk.getVersion() >= 65) {
            this.lastModified = Utility.getDateTime(entryBuffer, 27);
        }
        String base = String.format("%s%s %03d ", this.locked ? "*" : " ", this.getFileType(), this.reportedSize & 0xFF);
        this.catalogName = this.getName(base, entryBuffer);
        this.displayName = this.getDisplayName(entryBuffer);
    }

    private String getName(String base, byte[] buffer) {
        int max;
        StringBuilder text = new StringBuilder(base);
        int n = max = buffer[0] == -1 ? 32 : 33;
        if (this.dosDisk.getVersion() >= 65) {
            max = 27;
        }
        int i = 3;
        while (i < max) {
            int c = buffer[i] & 0xFF;
            if (!(c != 136 && c != 138 || base.isEmpty())) {
                if (text.length() > 0) {
                    text.deleteCharAt(text.length() - 1);
                }
            } else {
                if (c > 127) {
                    c -= c < 160 ? 64 : 128;
                }
                if (c < 32) {
                    text.append((char)(c + 64));
                } else {
                    text.append((char)c);
                }
            }
            ++i;
        }
        while (text.length() > 0 && text.charAt(text.length() - 1) == ' ') {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    private String getDisplayName(byte[] buffer) {
        int max;
        StringBuilder text = new StringBuilder();
        int n = max = buffer[0] == -1 ? 32 : 33;
        if (this.dosDisk.getVersion() >= 65) {
            max = 27;
        }
        int i = 3;
        while (i < max) {
            int c = buffer[i] & 0xFF;
            if (c != 136 && c != 138) {
                if (c > 127) {
                    c -= c < 160 ? 64 : 128;
                }
                if (c < 32) {
                    text.append((char)(c + 64));
                } else {
                    text.append((char)c);
                }
            }
            ++i;
        }
        while (text.length() > 0 && text.charAt(text.length() - 1) == ' ') {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    protected String getFileType() {
        if (this.fileType == null) {
            return "?";
        }
        switch (this.fileType) {
            case Text: {
                return "T";
            }
            case IntegerBasic: {
                return "I";
            }
            case ApplesoftBasic: {
                return "A";
            }
            case Binary: {
                return "B";
            }
            case SS: {
                return "S";
            }
            case Relocatable: {
                return "R";
            }
            case AA: {
                return "A";
            }
            case BB: {
                return "L";
            }
        }
        System.out.println("Unknown file type : " + (Object)((Object)this.fileType));
        return "?";
    }

    protected DiskAddress getValidAddress(byte[] buffer, int offset) {
        if (this.disk.isValidAddress(buffer[offset], buffer[offset + 1])) {
            return this.disk.getDiskAddress(buffer[offset], buffer[offset + 1]);
        }
        return null;
    }

    @Override
    public DataSource getDataSource() {
        if (this.appleFile != null) {
            return this.appleFile;
        }
        byte[] buffer = this.disk.readBlocks(this.dataSectors);
        if (buffer.length == 0) {
            this.appleFile = new DefaultAppleFile(this.name, buffer);
            return this.appleFile;
        }
        try {
            switch (this.fileType) {
                case Text: {
                    if (VisicalcFile.isVisicalcFile(buffer)) {
                        this.appleFile = new VisicalcFile(this.name, buffer);
                        break;
                    }
                    this.appleFile = new BasicTextFile(this.name, buffer);
                    break;
                }
                case IntegerBasic: {
                    int reportedLength = Utility.getShort(buffer, 0);
                    byte[] exactBuffer = new byte[reportedLength];
                    System.arraycopy(buffer, 2, exactBuffer, 0, reportedLength);
                    this.appleFile = new IntegerBasicProgram(this.name, exactBuffer);
                    break;
                }
                case ApplesoftBasic: {
                    int reportedLength = Utility.getShort(buffer, 0);
                    byte[] exactBuffer = new byte[reportedLength];
                    if (reportedLength > buffer.length) {
                        reportedLength = buffer.length - 2;
                    }
                    System.arraycopy(buffer, 2, exactBuffer, 0, reportedLength);
                    this.appleFile = new ApplesoftBasicProgram(this.name, exactBuffer);
                    break;
                }
                case Binary: 
                case Relocatable: 
                case BB: {
                    int loadAddress = Utility.getShort(buffer, 0);
                    int reportedLength = Utility.getShort(buffer, 2);
                    if (reportedLength == 0) {
                        System.out.println(String.valueOf(this.name.trim()) + " reported length : 0 - reverting to " + (buffer.length - 4));
                        reportedLength = buffer.length - 4;
                    }
                    byte[] exactBuffer = reportedLength + 4 <= buffer.length ? new byte[reportedLength] : new byte[buffer.length - 4];
                    System.arraycopy(buffer, 4, exactBuffer, 0, exactBuffer.length);
                    if ((this.name.endsWith(".FONT") || this.name.endsWith(" FONT") || this.name.endsWith(".SET") || this.name.startsWith("ASCII.")) && FontFile.isFont(exactBuffer)) {
                        this.appleFile = new FontFile(this.name, exactBuffer, loadAddress);
                        break;
                    }
                    if (this.name.endsWith(".MW")) {
                        this.appleFile = new MagicWindowText(this.name, exactBuffer);
                        break;
                    }
                    if (ShapeTable.isShapeTable(exactBuffer)) {
                        this.appleFile = new ShapeTable(this.name, exactBuffer);
                        break;
                    }
                    if (this.name.endsWith(".S")) {
                        this.appleFile = new MerlinSource(this.name, exactBuffer, loadAddress);
                        break;
                    }
                    if (HiResImage.isGif(exactBuffer)) {
                        this.appleFile = new OriginalHiResImage(this.name, exactBuffer, loadAddress);
                        break;
                    }
                    if (HiResImage.isPng(exactBuffer)) {
                        this.appleFile = new OriginalHiResImage(this.name, exactBuffer, loadAddress);
                        break;
                    }
                    if (this.name.endsWith(".BMP") && HiResImage.isBmp(buffer)) {
                        this.appleFile = new OriginalHiResImage(this.name, buffer, loadAddress);
                        break;
                    }
                    if (this.name.endsWith(".PAC")) {
                        this.appleFile = new DoubleHiResImage(this.name, exactBuffer);
                        break;
                    }
                    if (this.link != null) {
                        byte[] auxBuffer = this.link.disk.readBlocks(this.link.dataSectors);
                        byte[] exactAuxBuffer = this.getExactBuffer(auxBuffer);
                        if (this.name.endsWith(".AUX")) {
                            this.appleFile = new DoubleHiResImage(this.name, exactAuxBuffer, exactBuffer);
                            break;
                        }
                        this.appleFile = new DoubleHiResImage(this.name, exactBuffer, exactAuxBuffer);
                        break;
                    }
                    if (loadAddress == 8192 || loadAddress == 16384) {
                        if (reportedLength > 7936 && reportedLength <= 16384) {
                            this.appleFile = new OriginalHiResImage(this.name, exactBuffer, loadAddress);
                            break;
                        }
                        if (this.isScrunched(reportedLength)) {
                            this.appleFile = new OriginalHiResImage(this.name, exactBuffer, loadAddress, true);
                            break;
                        }
                        this.appleFile = new AssemblerProgram(this.name, exactBuffer, loadAddress);
                        break;
                    }
                    if (reportedLength == 576 && (loadAddress == 22528 || loadAddress == 24576 || loadAddress == 30720)) {
                        this.appleFile = new PrintShopGraphic(this.name, exactBuffer);
                        break;
                    }
                    if (this.isRunCommand(exactBuffer)) {
                        byte[] buf = new byte[exactBuffer.length - 4];
                        System.arraycopy(exactBuffer, 4, buf, 0, buf.length);
                        this.appleFile = new ApplesoftBasicProgram(this.name, buf);
                        System.out.printf("Possible basic binary: %s%n", this.name);
                        break;
                    }
                    this.appleFile = new AssemblerProgram(this.name, exactBuffer, loadAddress);
                    if (exactBuffer.length + 4 < buffer.length) {
                        ((AssemblerProgram)this.appleFile).setExtraBuffer(buffer, exactBuffer.length + 4, buffer.length - (exactBuffer.length + 4));
                    }
                    break;
                }
                case SS: {
                    System.out.println("SS file");
                    this.appleFile = new DefaultAppleFile(this.name, buffer);
                    break;
                }
                case AA: {
                    System.out.println("AA file");
                    this.appleFile = new DefaultAppleFile(this.name, buffer);
                    break;
                }
                default: {
                    System.out.println("Unknown file type : " + (Object)((Object)this.fileType));
                    this.appleFile = new DefaultAppleFile(this.name, buffer);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.appleFile = new ErrorMessageFile(this.name, buffer, e);
            e.printStackTrace();
        }
        return this.appleFile;
    }

    private byte[] getExactBuffer(byte[] buffer) {
        int reportedLength = Utility.getShort(buffer, 2);
        if (reportedLength == 0) {
            System.out.println(String.valueOf(this.name.trim()) + " reported length : 0 - reverting to " + (buffer.length - 4));
            reportedLength = buffer.length - 4;
        }
        byte[] exactBuffer = reportedLength + 4 <= buffer.length ? new byte[reportedLength] : new byte[buffer.length - 4];
        System.arraycopy(buffer, 4, exactBuffer, 0, exactBuffer.length);
        return exactBuffer;
    }

    private boolean isRunCommand(byte[] buffer) {
        return buffer[0] == 76 && buffer[1] == -4 && buffer[2] == -92 && buffer[3] == 0;
    }

    private boolean isScrunched(int reportedLength) {
        if ((this.name.equals("FLY LOGO") || this.name.equals("FLY LOGO SCRUNCHED")) && reportedLength == 5370) {
            return true;
        }
        return this.name.equals("BBROS LOGO SCRUNCHED") && reportedLength == 4077;
    }

    @Override
    public boolean contains(DiskAddress da) {
        for (DiskAddress sector : this.tsSectors) {
            if (!sector.matches(da)) continue;
            return true;
        }
        for (DiskAddress sector : this.dataSectors) {
            if (sector == null || !sector.matches(da)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getUniqueName() {
        return this.name;
    }

    @Override
    public FormattedDisk getFormattedDisk() {
        return this.dosDisk;
    }

    @Override
    public List<DiskAddress> getSectors() {
        ArrayList<DiskAddress> sectors = new ArrayList<DiskAddress>();
        sectors.add(this.catalogSectorDA);
        sectors.addAll(this.tsSectors);
        sectors.addAll(this.dataSectors);
        return sectors;
    }

    void link(CatalogEntry catalogEntry) {
        this.link = catalogEntry;
    }

    public String toString() {
        return this.catalogName;
    }
}

