/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.utilities.Utility;

public class Prefix2mg {
    String[] creators = new String[]{"!nfc", "B2TR", "CTKG", "CdrP", "ShIm", "WOOF", "XGS!"};
    String[] images = new String[]{"Dos3.3", "Prodos", "Nibbized"};
    String prefix;
    String creator;
    int headerSize;
    int version;
    int format;
    int flags;
    int length;
    int blocks;
    int offset;
    int commentOffset;
    int commentLength;
    int creatorOffset;
    int creatorLength;
    boolean flagsLocked;
    int flagsVolume;

    public Prefix2mg(byte[] buffer) {
        this.prefix = new String(buffer, 0, 4);
        this.creator = new String(buffer, 4, 4);
        this.headerSize = Utility.getShort(buffer, 8);
        this.version = Utility.getShort(buffer, 10);
        this.format = Utility.getLong(buffer, 12);
        this.flags = Utility.getLong(buffer, 16);
        this.blocks = Utility.getLong(buffer, 20);
        this.offset = Utility.getLong(buffer, 24);
        this.length = Utility.getLong(buffer, 28);
        this.commentOffset = Utility.getLong(buffer, 32);
        this.commentLength = Utility.getLong(buffer, 36);
        this.creatorOffset = Utility.getLong(buffer, 40);
        this.creatorLength = Utility.getLong(buffer, 44);
        boolean bl = this.flagsLocked = (this.flags & Integer.MIN_VALUE) != 0;
        if ((this.flags & 0x100) != 0) {
            this.flagsVolume = this.flags & 0xFF;
        }
        if (this.format == 0 && this.flagsVolume == 0) {
            this.flagsVolume = 254;
        }
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Prefix         : %s%n", this.prefix));
        text.append(String.format("Creator        : %s%n", this.creator));
        text.append(String.format("Header         : %d%n", this.headerSize));
        text.append(String.format("Version        : %d%n", this.version));
        text.append(String.format("Format         : %02X%n", this.format));
        text.append(String.format("Flags          : %,d%n", this.flags));
        text.append(String.format("Locked         : %s%n", this.flagsLocked));
        text.append(String.format("DOS Volume     : %,d%n", this.flagsVolume));
        text.append(String.format("Blocks         : %,d%n", this.blocks));
        text.append(String.format("Offset         : %,d%n", this.offset));
        text.append(String.format("Length         : %08X (%<,d)%n", this.length));
        text.append(String.format("Comment Offset : %,d%n", this.commentOffset));
        text.append(String.format("Comment Length : %08X (%<,d)%n", this.commentLength));
        text.append(String.format("Creator Offset : %,d%n", this.creatorOffset));
        text.append(String.format("Creator Length : %08X (%<,d)", this.creatorLength));
        return text.toString();
    }
}

