/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DataSource;
import java.awt.Dimension;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class HybridDisk
implements FormattedDisk {
    private final List<FormattedDisk> disks = new ArrayList<FormattedDisk>(2);
    private int currentDisk;
    private final JTree tree;

    public HybridDisk(FormattedDisk disk0, FormattedDisk disk1) {
        assert (disk0 != disk1);
        String diskName = disk0.getDisk().getFile().getName();
        String text = "This disk is a hybrid of two or more OS\n\n" + disk0.getDisk() + "\n\n" + disk1.getDisk();
        DefaultAppleFileSource dafs = new DefaultAppleFileSource(diskName, text, (FormattedDisk)this);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(dafs);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(treeModel);
        treeModel.setAsksAllowsChildren(true);
        this.disks.add(disk0);
        this.disks.add(disk1);
        disk0.setParent(this);
        disk1.setParent(this);
        DefaultMutableTreeNode root0 = (DefaultMutableTreeNode)disk0.getCatalogTree().getModel().getRoot();
        DefaultMutableTreeNode root1 = (DefaultMutableTreeNode)disk1.getCatalogTree().getModel().getRoot();
        root.add((DefaultMutableTreeNode)root0.getChildAt(0));
        root.add((DefaultMutableTreeNode)root1.getChildAt(0));
    }

    @Override
    public JTree getCatalogTree() {
        return this.tree;
    }

    @Override
    public List<DiskAddress> getFileSectors(int fileNo) {
        return this.disks.get(this.currentDisk).getFileSectors(fileNo);
    }

    @Override
    public List<AppleFileSource> getCatalogList() {
        return this.disks.get(this.currentDisk).getCatalogList();
    }

    @Override
    public DataSource getFormattedSector(DiskAddress da) {
        return this.disks.get(this.currentDisk).getFormattedSector(da);
    }

    @Override
    public SectorType getSectorType(DiskAddress da) {
        return this.disks.get(this.currentDisk).getSectorType(da);
    }

    @Override
    public SectorType getSectorType(int track, int sector) {
        return this.disks.get(this.currentDisk).getSectorType(track, sector);
    }

    @Override
    public SectorType getSectorType(int block) {
        return this.disks.get(this.currentDisk).getSectorType(block);
    }

    @Override
    public List<SectorType> getSectorTypeList() {
        return this.disks.get(this.currentDisk).getSectorTypeList();
    }

    @Override
    public Disk getDisk() {
        return this.disks.get(this.currentDisk).getDisk();
    }

    public void setCurrentDisk(FormattedDisk fd) {
        int i = 0;
        while (i < this.disks.size()) {
            if (this.disks.get(i) == fd) {
                this.currentDisk = i;
                break;
            }
            ++i;
        }
    }

    public void setCurrentDiskNo(int n) {
        this.currentDisk = n;
    }

    public int getCurrentDiskNo() {
        return this.currentDisk;
    }

    public FormattedDisk getCurrentDisk() {
        return this.disks.get(this.currentDisk);
    }

    @Override
    public void writeFile(AbstractFile file) {
        this.disks.get(this.currentDisk).writeFile(file);
    }

    @Override
    public AppleFileSource getCatalog() {
        StringBuilder text = new StringBuilder();
        for (FormattedDisk disk : this.disks) {
            text.append(disk.getCatalog().getDataSource().getText());
            text.append("\n\n");
        }
        text.deleteCharAt(text.length() - 1);
        text.deleteCharAt(text.length() - 1);
        return new DefaultAppleFileSource("text", text.toString(), (FormattedDisk)this);
    }

    @Override
    public AppleFileSource getFile(String uniqueName) {
        return this.disks.get(this.currentDisk).getFile(uniqueName);
    }

    @Override
    public int clearOrphans() {
        return this.disks.get(this.currentDisk).clearOrphans();
    }

    @Override
    public boolean isSectorFree(DiskAddress da) {
        return this.disks.get(this.currentDisk).isSectorFree(da);
    }

    @Override
    public void verify() {
        this.disks.get(this.currentDisk).verify();
    }

    @Override
    public boolean stillAvailable(DiskAddress da) {
        return this.disks.get(this.currentDisk).stillAvailable(da);
    }

    @Override
    public void setSectorType(int block, SectorType type) {
        this.disks.get(this.currentDisk).setSectorType(block, type);
    }

    @Override
    public void setSectorFree(int block, boolean free) {
        this.disks.get(this.currentDisk).setSectorFree(block, free);
    }

    @Override
    public int falseNegativeBlocks() {
        return this.disks.get(this.currentDisk).falseNegativeBlocks();
    }

    @Override
    public int falsePositiveBlocks() {
        return this.disks.get(this.currentDisk).falsePositiveBlocks();
    }

    @Override
    public Dimension getGridLayout() {
        return this.disks.get(this.currentDisk).getGridLayout();
    }

    @Override
    public boolean isSectorFree(int block) {
        return this.disks.get(this.currentDisk).isSectorFree(block);
    }

    @Override
    public boolean stillAvailable(int block) {
        return this.disks.get(this.currentDisk).stillAvailable(block);
    }

    @Override
    public void setOriginalPath(Path path) {
        this.disks.get(this.currentDisk).setOriginalPath(path);
    }

    @Override
    public String getAbsolutePath() {
        return this.disks.get(this.currentDisk).getAbsolutePath();
    }

    @Override
    public String getDisplayPath() {
        return this.disks.get(this.currentDisk).getDisplayPath();
    }

    @Override
    public FormattedDisk getParent() {
        return this.disks.get(this.currentDisk).getParent();
    }

    @Override
    public void setParent(FormattedDisk disk) {
        this.disks.get(this.currentDisk).setParent(disk);
    }

    @Override
    public String getSectorFilename(DiskAddress da) {
        return this.disks.get(this.currentDisk).getSectorFilename(da);
    }

    @Override
    public String getName() {
        return this.disks.get(this.currentDisk).getName();
    }

    @Override
    public boolean isTempDisk() {
        return this.disks.get(this.currentDisk).isTempDisk();
    }

    @Override
    public Path getOriginalPath() {
        return this.disks.get(this.currentDisk).getOriginalPath();
    }
}

