/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.cpm.CPMDisk;
import com.bytezone.diskbrowser.disk.AppleDisk;
import com.bytezone.diskbrowser.disk.DataDisk;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.HybridDisk;
import com.bytezone.diskbrowser.dos.DosDisk;
import com.bytezone.diskbrowser.infocom.InfocomDisk;
import com.bytezone.diskbrowser.nib.NibFile;
import com.bytezone.diskbrowser.nib.V2dFile;
import com.bytezone.diskbrowser.nib.WozFile;
import com.bytezone.diskbrowser.nufx.Binary2;
import com.bytezone.diskbrowser.nufx.NuFX;
import com.bytezone.diskbrowser.pascal.PascalDisk;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import com.bytezone.diskbrowser.utilities.FileFormatException;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import com.bytezone.diskbrowser.wizardry.Wizardry4BootDisk;
import com.bytezone.diskbrowser.wizardry.WizardryScenarioDisk;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class DiskFactory {
    private static boolean debug = false;
    private static final int DISK_800K = 819200;
    private static final int DISK_143K = 143360;
    private static final int DISK_116K = 116480;
    private static NuFX nuFX;
    private static Binary2 binary2;

    private DiskFactory() {
    }

    public static FormattedDisk createDisk(File file) {
        return DiskFactory.createDisk(file.getAbsolutePath());
    }

    public static FormattedDisk createDisk(String pathName) {
        AppleDisk appleDisk;
        byte[] diskBuffer;
        FileOutputStream fos;
        Object tmp;
        if (debug) {
            System.out.println("\nFactory : " + pathName);
        }
        nuFX = null;
        binary2 = null;
        Object file = new File(pathName);
        if (!((File)file).exists()) {
            return null;
        }
        String suffix = pathName.substring(pathName.lastIndexOf(".") + 1).toLowerCase();
        Boolean compressed = false;
        Path originalPath = Paths.get(pathName, new String[0]);
        if ("gz".equals(suffix)) {
            if (debug) {
                System.out.println(" ** gzip **");
            }
            try {
                int bytesRead;
                GZIPInputStream in = new GZIPInputStream(new FileInputStream(pathName));
                tmp = File.createTempFile("gzip", null);
                fos = new FileOutputStream((File)tmp);
                byte[] buffer = new byte[1024];
                while ((bytesRead = ((InputStream)in).read(buffer)) > 0) {
                    fos.write(buffer, 0, bytesRead);
                }
                fos.close();
                ((InputStream)in).close();
                ((File)tmp).deleteOnExit();
                suffix = Utility.getSuffix(((File)file).getName());
                file = tmp;
                compressed = true;
            }
            catch (IOException e) {
                System.out.printf("Error unpacking: %s%n", ((File)file).getAbsolutePath());
                return null;
            }
        }
        if ("zip".equals(suffix)) {
            if (debug) {
                System.out.println(" ** zip **");
            }
            try {
                ZipFile zipFile = new ZipFile(pathName);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    int bytesRead;
                    ZipEntry entry = entries.nextElement();
                    if (!Utility.validFileType(entry.getName())) continue;
                    InputStream stream = zipFile.getInputStream(entry);
                    File tmp2 = File.createTempFile("zip", null);
                    FileOutputStream fos2 = new FileOutputStream(tmp2);
                    byte[] buffer = new byte[1024];
                    while ((bytesRead = stream.read(buffer)) > 0) {
                        fos2.write(buffer, 0, bytesRead);
                    }
                    stream.close();
                    fos2.close();
                    tmp2.deleteOnExit();
                    suffix = Utility.getSuffix(((File)file).getName());
                    file = tmp2;
                    compressed = true;
                    break;
                }
                zipFile.close();
            }
            catch (IOException e) {
                System.out.printf("Error unpacking: %s%n", ((File)file).getAbsolutePath());
                return null;
            }
        }
        if ("sdk".equals(suffix) || "shk".equals(suffix) || "bxy".equals(suffix)) {
            block116: {
                block115: {
                    if (debug) {
                        System.out.println(" ** sdk/shk/bxy **");
                    }
                    try {
                        nuFX = new NuFX(((File)file).toPath());
                        if (nuFX.getTotalDisks() != 0 || nuFX.getTotalFiles() != 0) break block115;
                        return null;
                    }
                    catch (Exception e) {
                        if (e.getMessage() == null) {
                            System.out.println(e);
                        } else {
                            System.out.println(e.getMessage());
                        }
                        System.out.printf("Error unpacking: %s%n", ((File)file).getAbsolutePath());
                        return null;
                    }
                }
                diskBuffer = nuFX.getDiskBuffer();
                if (diskBuffer != null) break block116;
                return null;
            }
            tmp = File.createTempFile(suffix, null);
            fos = new FileOutputStream((File)tmp);
            fos.write(diskBuffer);
            fos.close();
            ((File)tmp).deleteOnExit();
            file = tmp;
            suffix = "dsk";
            compressed = true;
        }
        if ("bny".equals(suffix)) {
            if (debug) {
                System.out.println(" ** bny **");
            }
            try {
                binary2 = new Binary2(((File)file).toPath());
                diskBuffer = binary2.getDiskBuffer();
                tmp = File.createTempFile(suffix, null);
                fos = new FileOutputStream((File)tmp);
                fos.write(diskBuffer);
                fos.close();
                ((File)tmp).deleteOnExit();
                file = tmp;
                suffix = "dsk";
                compressed = true;
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.printf("Error unpacking: %s%n", ((File)file).getAbsolutePath());
                return null;
            }
        } else if ("bsq".equals(suffix)) {
            if (debug) {
                System.out.println(" ** bsq **");
            }
            byte[] prefix = DiskFactory.getPrefix((File)file);
            System.out.println(HexFormatter.format(prefix));
            tmp = "FiLeStArTfIlEsTaRt";
        }
        FormattedDisk disk = null;
        FormattedDisk disk2 = null;
        if (suffix.equals("hdv")) {
            FormattedDisk prodosDisk;
            if (debug) {
                System.out.println(" ** hdv **");
            }
            if ((prodosDisk = DiskFactory.checkHardDisk((File)file)) != null) {
                return prodosDisk;
            }
            disk = DiskFactory.check2mgDisk((File)file);
            if (disk != null) {
                if (compressed.booleanValue()) {
                    disk.setOriginalPath(originalPath);
                }
                return disk;
            }
            AppleDisk appleDisk2 = new AppleDisk((File)file, (int)((File)file).length() / 4096, 8);
            return new DataDisk(appleDisk2);
        }
        if (suffix.equals("2mg")) {
            if (debug) {
                System.out.println(" ** 2mg **");
            }
            if ((disk = DiskFactory.check2mgDisk((File)file)) != null) {
                if (compressed.booleanValue()) {
                    disk.setOriginalPath(originalPath);
                }
                return disk;
            }
            appleDisk = new AppleDisk((File)file, (int)((File)file).length() / 4096, 8);
            return new DataDisk(appleDisk);
        }
        if ((suffix.equals("img") || suffix.equals("dimg")) && (disk = DiskFactory.checkDiskCopyDisk((File)file)) != null) {
            return disk;
        }
        if ((suffix.equals("po") || suffix.equals("dsk") || suffix.equals("do")) && ((File)file).length() > 143360L) {
            if (((File)file).length() < 143500L) {
                System.out.println("File length is wrong: " + ((File)file).length());
                disk = DiskFactory.checkDos(new AppleDisk((File)file, 35, 16));
                if (disk != null) {
                    return DiskFactory.check(disk);
                }
            }
            if (debug) {
                System.out.printf("  Checking po or dsk hard drive: %,d%n", ((File)file).length());
            }
            if ((disk = DiskFactory.checkHardDisk((File)file)) != null) {
                if (compressed.booleanValue()) {
                    disk.setOriginalPath(originalPath);
                }
                return DiskFactory.check(disk);
            }
            if (((File)file).length() == 819200L) {
                if (debug) {
                    System.out.println("UniDos ?");
                }
                AppleDisk appleDisk1 = new AppleDisk((File)file, 50, 32);
                AppleDisk appleDisk2 = new AppleDisk((File)file, 50, 32, 409600);
                disk = DiskFactory.checkUnidos(appleDisk1, 1);
                disk2 = DiskFactory.checkUnidos(appleDisk2, 2);
                if (disk != null && disk2 != null) {
                    return new HybridDisk(disk, disk2);
                }
            }
            if (debug) {
                System.out.println("  Creating a data disk from bad length");
            }
            try {
                appleDisk = new AppleDisk((File)file, (int)((File)file).length() / 4096, 8);
                if (debug) {
                    System.out.println("  created data disk");
                }
                return new DataDisk(appleDisk);
            }
            catch (FileFormatException e) {
                if (debug) {
                    System.out.println("  Creating AppleDisk failed");
                }
                return null;
            }
        }
        if (suffix.equals("woz")) {
            if (debug) {
                System.out.println("Checking woz");
            }
            try {
                WozFile wozFile = new WozFile((File)file);
                if (wozFile.getSectorsPerTrack() == 13) {
                    AppleDisk appleDisk3 = new AppleDisk(wozFile, 35, 13);
                    disk = DiskFactory.checkDos(appleDisk3);
                    return disk == null ? new DataDisk(appleDisk3) : disk;
                }
                if (wozFile.getSectorsPerTrack() == 16) {
                    if (wozFile.getDiskType() == 2) {
                        AppleDisk disk800;
                        if (debug) {
                            System.out.println("Checking woz 3.5");
                        }
                        if (ProdosDisk.isCorrectFormat(disk800 = new AppleDisk(wozFile, 100 * wozFile.getSides(), 8))) {
                            if (debug) {
                                System.out.println("  --> PRODOS hard disk");
                            }
                            return new ProdosDisk(disk800);
                        }
                        disk = new DataDisk(disk800);
                    } else {
                        AppleDisk appleDisk256 = new AppleDisk(wozFile, wozFile.getTracks(), 16);
                        disk = DiskFactory.checkDos(appleDisk256);
                        if (disk == null) {
                            disk = DiskFactory.checkProdos(new AppleDisk(wozFile, 35, 8));
                        }
                        if (disk == null) {
                            disk = DiskFactory.checkPascalDisk(new AppleDisk(wozFile, 35, 8));
                        }
                        if (disk == null) {
                            disk = new DataDisk(appleDisk256);
                        }
                    }
                }
                return disk;
            }
            catch (Exception e) {
                System.out.println(e);
                return null;
            }
        }
        if (suffix.equals("v2d")) {
            V2dFile v2dDisk = new V2dFile((File)file);
            AppleDisk appleDisk256 = new AppleDisk(v2dDisk, 35, 16);
            disk = DiskFactory.checkDos(appleDisk256);
            if (disk == null) {
                disk = DiskFactory.checkProdos(new AppleDisk(v2dDisk, 35, 8));
            }
            if (disk == null) {
                disk = new DataDisk(appleDisk256);
            }
            return disk;
        }
        if (suffix.equals("nib")) {
            if (debug) {
                System.out.println(" ** nib **");
            }
            NibFile nibDisk = new NibFile((File)file);
            AppleDisk appleDisk16 = new AppleDisk(nibDisk);
            disk = DiskFactory.checkDos(appleDisk16);
            return null;
        }
        long length = ((File)file).length();
        if (length == 116480L) {
            AppleDisk appleDisk4;
            if (debug) {
                System.out.println(" ** 13 sector **");
            }
            if (!suffix.equals("d13")) {
                System.out.printf("%s should have a d13 suffix%n", ((File)file).getName());
            }
            return (disk = DiskFactory.checkDos(appleDisk4 = new AppleDisk((File)file, 35, 13))) == null ? new DataDisk(appleDisk4) : disk;
        }
        if (length != 143360L) {
            System.out.printf("%s: invalid file length : %,d%n", ((File)file).getName(), ((File)file).length());
            return null;
        }
        AppleDisk appleDisk256 = new AppleDisk((File)file, 35, 16);
        AppleDisk appleDisk512 = new AppleDisk((File)file, 35, 8);
        long checksum = 0L;
        if (checksum == 227968344L) {
            if (debug) {
                System.out.println("  empty sector checksum : " + checksum);
            }
        } else if (checksum == 3176296590L || checksum == 108825457L || checksum == 1439356606L || checksum == 1550012074L || checksum == 1614602459L || checksum == 940889336L || checksum == 2936955085L || checksum == 1348415927L || checksum == 3340889101L || checksum == 18315788L || checksum == 993895235L || checksum == 2378342794L) {
            if (debug) {
                System.out.println("  known DOS checksum : " + checksum);
            }
            disk = DiskFactory.checkDos(appleDisk256);
            if (disk2 != null && disk != null) {
                if (debug) {
                    System.out.println("  --> Dual dos/prodos 1");
                }
                System.out.println("** impossible **");
                disk = new HybridDisk(disk, disk2);
            }
        } else if (checksum == 1737448647L || checksum == 170399908L || checksum == 990032697L) {
            if (debug) {
                System.out.println("  known PRODOS checksum : " + checksum);
            }
            disk = DiskFactory.checkProdos(appleDisk512);
            disk2 = DiskFactory.checkDos(appleDisk256);
            if (disk2 != null && disk != null) {
                if (debug) {
                    System.out.println("  --> Dual prodos/dos 2");
                }
                disk = new HybridDisk(disk, disk2);
            }
        } else if (checksum == 2803644711L || checksum == 3317783349L || checksum == 1728863694L || checksum == 198094178L) {
            if (debug) {
                System.out.println("  known PASCAL checksum : " + checksum);
            }
            disk = DiskFactory.checkPascalDisk(appleDisk512);
            disk2 = DiskFactory.checkDos(appleDisk256);
            if (disk2 != null) {
                disk = new HybridDisk(disk, disk2);
            }
        } else if (checksum == 3028642627L || checksum == 2070151659L) {
            if (debug) {
                System.out.println("  known INFOCOM checksum : " + checksum);
            }
            disk = DiskFactory.checkInfocomDisk(appleDisk256);
        } else if (debug) {
            System.out.println("  unknown checksum : " + checksum);
        }
        if (disk != null) {
            if (compressed.booleanValue()) {
                disk.setOriginalPath(originalPath);
            }
            return DiskFactory.check(disk);
        }
        if (debug) {
            System.out.println("  checksum no help");
        }
        if (debug) {
            System.out.println("  Suffix : " + suffix);
        }
        if (suffix.equals("dsk") || suffix.equals("do")) {
            disk = DiskFactory.checkDos(appleDisk256);
            if (disk == null) {
                disk = DiskFactory.checkProdos(appleDisk512);
            } else {
                if (debug) {
                    System.out.println("Checking DualDos disk");
                }
                if ((disk2 = DiskFactory.checkProdos(appleDisk512)) != null) {
                    disk = new HybridDisk(disk, disk2);
                    return disk;
                }
                AppleDisk appleDisk5 = new AppleDisk((File)file, 35, 16);
                disk2 = DiskFactory.checkCPMDisk(appleDisk5);
                if (disk2 != null) {
                    disk = new HybridDisk(disk, disk2);
                    return disk;
                }
                disk2 = DiskFactory.checkPascalDisk(appleDisk512);
                if (disk2 != null) {
                    disk = new HybridDisk(disk, disk2);
                    return disk;
                }
            }
        } else if (suffix.equals("po") && (disk = DiskFactory.checkProdos(appleDisk512)) == null) {
            disk = DiskFactory.checkDos(appleDisk256);
        }
        if (disk == null) {
            disk = DiskFactory.checkPascalDisk(appleDisk512);
        }
        if (disk == null) {
            disk = DiskFactory.checkCPMDisk(appleDisk256);
        }
        if (disk == null && (disk2 = DiskFactory.checkInfocomDisk(appleDisk256)) != null) {
            disk = disk2;
        }
        if (disk == null) {
            disk = new DataDisk(appleDisk256);
        }
        if (debug) {
            System.out.println("Factory creating disk : " + disk.getDisk().getFile().getAbsolutePath());
        }
        if (disk != null && compressed.booleanValue()) {
            disk.setOriginalPath(originalPath);
        }
        return DiskFactory.check(disk);
    }

    /*
     * WARNING - void declaration
     */
    private static FormattedDisk check(FormattedDisk disk) {
        void var2_1;
        AppleDisk appleDisk;
        Disk disk2 = disk.getDisk();
        if (disk2 instanceof AppleDisk && (appleDisk = (AppleDisk)disk2) == (AppleDisk)var2_1) {
            if (nuFX != null) {
                appleDisk.setNuFX(nuFX);
            } else if (binary2 != null) {
                appleDisk.setBinary2(binary2);
            }
        }
        return disk;
    }

    private static DosDisk checkDos(AppleDisk disk) {
        if (debug) {
            System.out.println("Checking DOS disk");
        }
        try {
            if (DosDisk.isCorrectFormat(disk)) {
                if (debug) {
                    System.out.println("  --> DOS");
                }
                DosDisk dosDisk = new DosDisk(disk);
                return dosDisk;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (debug) {
            System.out.println("  not a DOS disk");
        }
        return null;
    }

    private static ProdosDisk checkProdos(AppleDisk disk) {
        if (debug) {
            System.out.println("Checking Prodos disk");
        }
        try {
            if (ProdosDisk.isCorrectFormat(disk)) {
                if (debug) {
                    System.out.println("  --> PRODOS");
                }
                return new ProdosDisk(disk);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (debug) {
            System.out.println("  not a Prodos disk");
        }
        return null;
    }

    private static DosDisk checkUnidos(AppleDisk disk, int side) {
        if (debug) {
            System.out.println("Checking UniDOS disk");
        }
        try {
            if (DosDisk.isCorrectFormat(disk)) {
                if (debug) {
                    System.out.println("  --> UniDOS");
                }
                return new DosDisk(disk, side);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (debug) {
            System.out.println("  not a UniDOS disk");
        }
        return null;
    }

    private static FormattedDisk checkHardDisk(File file) {
        if (debug) {
            System.out.println("\nChecking Prodos hard disk");
            System.out.printf("Total blocks : %f%n", Float.valueOf((float)file.length() / 512.0f));
            System.out.printf("Total tracks : %f%n", Float.valueOf((float)file.length() / 4096.0f));
            System.out.printf("File length  : %d%n", file.length());
            System.out.println();
        }
        if (file.length() % 512L != 0L) {
            if (debug) {
                System.out.printf("file length not divisible by 512 : %,d%n%n", file.length());
            }
            return null;
        }
        try {
            AppleDisk disk;
            int tracks = (int)(file.length() - 1L) / 4096 + 1;
            if ((long)(tracks * 4096) != file.length()) {
                System.out.println("*** extended ***");
            }
            if (ProdosDisk.isCorrectFormat(disk = new AppleDisk(file, tracks, 8))) {
                if (debug) {
                    System.out.println("  --> PRODOS hard disk");
                }
                return new ProdosDisk(disk);
            }
            if (PascalDisk.isCorrectFormat(disk, debug)) {
                if (debug) {
                    System.out.println("  --> Pascal hard disk");
                }
                return new PascalDisk(disk);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
            System.out.println("Prodos hard disk had error");
        }
        if (debug) {
            System.out.println("  not a Prodos hard disk\n");
        }
        return null;
    }

    private static FormattedDisk check2mgDisk(File file) {
        if (debug) {
            System.out.println("Checking 2mg disk");
        }
        try {
            AppleDisk disk = new AppleDisk(file, 0, 0);
            if (disk.getTotalBlocks() > 0) {
                if (ProdosDisk.isCorrectFormat(disk)) {
                    return new ProdosDisk(disk);
                }
                if (file.length() == 143424L) {
                    disk.switchToDos();
                    if (DosDisk.isCorrectFormat(disk)) {
                        return new DosDisk(disk);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (debug) {
            System.out.println("Not a 2mg disk");
        }
        return null;
    }

    private static FormattedDisk checkDiskCopyDisk(File file) {
        if (debug) {
            System.out.println("Checking DiskCopy disk");
        }
        try {
            AppleDisk disk = new AppleDisk(file, 0, 0);
            if (disk.getTotalBlocks() > 0 && ProdosDisk.isCorrectFormat(disk)) {
                return new ProdosDisk(disk);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (debug) {
            System.out.println("Not a DiskCopy disk");
        }
        return null;
    }

    private static FormattedDisk checkPascalDisk(AppleDisk disk) {
        if (debug) {
            System.out.println("Checking Pascal disk");
        }
        File file = disk.getFile();
        if (!PascalDisk.isCorrectFormat(disk, debug)) {
            return null;
        }
        if (debug) {
            System.out.println("Pascal disk OK - Checking Wizardry disk");
        }
        if (WizardryScenarioDisk.isWizardryFormat(disk, debug)) {
            return new WizardryScenarioDisk(disk);
        }
        if (debug) {
            System.out.println("Not a Wizardry 1-3 disk");
        }
        if (file.getName().endsWith(".tmp")) {
            return new PascalDisk(disk);
        }
        if (Wizardry4BootDisk.isWizardryIVorV(disk, debug)) {
            int requiredDisks;
            int pos;
            String fileName = file.getAbsolutePath().toLowerCase();
            char c = fileName.charAt((pos = file.getAbsolutePath().indexOf(46)) - 1);
            int n = c == '1' ? 6 : (requiredDisks = c == 'a' ? 10 : 0);
            if (requiredDisks > 0) {
                AppleDisk[] disks = new AppleDisk[requiredDisks];
                disks[0] = new AppleDisk(file, 256, 8);
                disks[0].setInterleave(1);
                disks[1] = new AppleDisk(file, 256, 8);
                disks[1].setInterleave(1);
                if (pos > 0 && requiredDisks > 0 && DiskFactory.collectDataDisks(file.getAbsolutePath(), pos, disks)) {
                    return new Wizardry4BootDisk(disks);
                }
            }
        }
        if (debug) {
            System.out.println("Not a Wizardry IV disk");
        }
        PascalDisk pascalDisk = new PascalDisk(disk);
        return pascalDisk;
    }

    private static boolean collectDataDisks(String fileName, int dotPos, AppleDisk[] disks) {
        char c = fileName.charAt(dotPos - 1);
        String suffix = fileName.substring(dotPos + 1);
        int i = 2;
        while (i < disks.length) {
            String rep;
            String old = new String(String.valueOf(c) + "." + suffix);
            File f = new File(fileName.replace(old, rep = new String(String.valueOf((char)(c + i - 1)) + "." + suffix)));
            if (!f.exists() || !f.isFile()) {
                return false;
            }
            AppleDisk dataDisk = new AppleDisk(f, 35, 8);
            dataDisk.setInterleave(1);
            disks[i] = dataDisk;
            ++i;
        }
        return true;
    }

    private static InfocomDisk checkInfocomDisk(AppleDisk disk) {
        if (debug) {
            System.out.println("Checking Infocom disk");
        }
        if (InfocomDisk.isCorrectFormat(disk)) {
            if (debug) {
                System.out.println("  --> INFOCOM");
            }
            return new InfocomDisk(disk);
        }
        if (debug) {
            System.out.println("Not an InfocomDisk disk");
        }
        return null;
    }

    private static CPMDisk checkCPMDisk(AppleDisk disk) {
        if (debug) {
            System.out.println("Checking CPM disk");
        }
        if (CPMDisk.isCorrectFormat(disk)) {
            return new CPMDisk(disk);
        }
        if (debug) {
            System.out.println("Not a CPM disk");
        }
        return null;
    }

    private static byte[] getPrefix(File file) {
        byte[] buffer = new byte[1024];
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
                bis.read(buffer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return buffer;
    }
}

