/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;

public class AppleDiskAddress
implements DiskAddress {
    private final int block;
    private final int track;
    private final int sector;
    public final Disk owner;
    private boolean zeroFlag;

    public AppleDiskAddress(Disk owner, int block) {
        this.owner = owner;
        this.block = block;
        int sectorsPerTrack = owner.getBlocksPerTrack();
        if (sectorsPerTrack == 0) {
            this.track = 0;
            this.sector = 0;
        } else {
            this.track = block / sectorsPerTrack;
            this.sector = block % sectorsPerTrack;
        }
    }

    public AppleDiskAddress(Disk owner, int track, int sector) {
        this.owner = owner;
        this.zeroFlag = (track & 0x40) == 64;
        this.track = track & 0x3F;
        this.sector = sector & 0x1F;
        this.block = this.track * owner.getBlocksPerTrack() + this.sector;
    }

    public boolean zeroFlag() {
        return this.zeroFlag;
    }

    @Override
    public int compareTo(DiskAddress that) {
        return this.block - that.getBlockNo();
    }

    @Override
    public boolean matches(DiskAddress that) {
        if (that == null) {
            return false;
        }
        return this.block == that.getBlockNo();
    }

    @Override
    public boolean isZero() {
        return this.block == 0;
    }

    @Override
    public int getBlockNo() {
        return this.block;
    }

    @Override
    public int getSectorNo() {
        return this.sector;
    }

    @Override
    public int getTrackNo() {
        return this.track;
    }

    @Override
    public Disk getDisk() {
        return this.owner;
    }

    public String toString() {
        return String.format("[Block=%02X, Track=%02X, Sector=%02X, Zero=%s]", this.block, this.track, this.sector, this.zeroFlag);
    }
}

