/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.cpm;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.cpm.CPMCatalogSector;
import com.bytezone.diskbrowser.cpm.DirectoryEntry;
import com.bytezone.diskbrowser.disk.AbstractFormattedDisk;
import com.bytezone.diskbrowser.disk.AppleDisk;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

public class CPMDisk
extends AbstractFormattedDisk {
    private static final int EMPTY_BYTE_VALUE = 229;
    private final Color green = new Color(0, 200, 0);
    public final SectorType catalogSector = new SectorType("Catalog", this.green);
    public final SectorType prnSector = new SectorType("PRN", Color.lightGray);
    public final SectorType comSector = new SectorType("COM", Color.red);
    public final SectorType otherSector = new SectorType("Other", Color.blue);
    public final SectorType docSector = new SectorType("DOC", Color.cyan);
    public final SectorType basSector = new SectorType("BAS", Color.gray);
    public final SectorType asmSector = new SectorType("ASM", Color.orange);
    public final SectorType ovrSector = new SectorType("OVR", Color.magenta);
    public final SectorType macSector = new SectorType("MAC", Color.green);
    private int version;
    private final DefaultMutableTreeNode volumeNode;

    public CPMDisk(Disk disk) {
        super(disk);
        this.sectorTypesList.add(this.catalogSector);
        this.sectorTypesList.add(this.prnSector);
        this.sectorTypesList.add(this.comSector);
        this.sectorTypesList.add(this.basSector);
        this.sectorTypesList.add(this.docSector);
        this.sectorTypesList.add(this.asmSector);
        this.sectorTypesList.add(this.ovrSector);
        this.sectorTypesList.add(this.macSector);
        this.sectorTypesList.add(this.otherSector);
        this.setEmptyByte((byte)-27);
        int i = 8;
        while (i >= 4) {
            byte[] buffer = disk.readBlock(0, i);
            String text = new String(buffer, 16, 24);
            if ("DIR ERA TYPESAVEREN USER".equals(text)) {
                this.version = buffer[41] & 0xFF;
                break;
            }
            i -= 2;
        }
        DefaultMutableTreeNode rootNode = this.getCatalogTreeRoot();
        this.volumeNode = new DefaultMutableTreeNode();
        rootNode.add(this.volumeNode);
        int sector = 0;
        while (sector < 8) {
            DiskAddress da = disk.getDiskAddress(3, sector);
            this.sectorTypes[da.getBlockNo()] = this.catalogSector;
            byte[] buffer = disk.readBlock(da);
            int b1 = buffer[0] & 0xFF;
            int b2 = buffer[1] & 0xFF;
            if (b1 != 229 || b2 != 229 && b2 != 0) {
                if (b1 > 31 && b1 != 229 || b2 < 32 || b2 > 126 && b2 != 229) break;
                int i2 = 0;
                while (i2 < buffer.length) {
                    b1 = buffer[i2] & 0xFF;
                    b2 = buffer[i2 + 1] & 0xFF;
                    if (b1 != 229) {
                        if (b2 < 32 || b2 > 126 && b2 != 229) break;
                        DirectoryEntry entry = new DirectoryEntry(this, buffer, i2);
                        SectorType sectorType = this.getSectorType(entry.getType());
                        for (DiskAddress block : entry.getSectors()) {
                            if (disk.isBlockEmpty(block)) continue;
                            this.sectorTypes[block.getBlockNo()] = sectorType;
                        }
                        DirectoryEntry parent = this.findParent(entry);
                        if (parent == null) {
                            this.fileEntries.add(entry);
                            DefaultMutableTreeNode node = new DefaultMutableTreeNode(entry);
                            this.volumeNode.add(node);
                            node.setAllowsChildren(false);
                        } else {
                            parent.add(entry);
                        }
                    }
                    i2 += 32;
                }
            }
            ++sector;
        }
        this.volumeNode.setUserObject(this.getCatalog());
        this.makeNodeVisible(this.volumeNode.getFirstLeaf());
    }

    private SectorType getSectorType(String type) {
        if ("COM".equals(type)) {
            return this.comSector;
        }
        if ("DOC".equals(type)) {
            return this.docSector;
        }
        if ("BAS".equals(type)) {
            return this.basSector;
        }
        if ("PRN".equals(type)) {
            return this.prnSector;
        }
        if ("ASM".equals(type)) {
            return this.asmSector;
        }
        if ("OVR".equals(type)) {
            return this.ovrSector;
        }
        if ("MAC".equals(type)) {
            return this.macSector;
        }
        return this.otherSector;
    }

    @Override
    public List<DiskAddress> getFileSectors(int fileNo) {
        if (this.fileEntries.size() > 0 && this.fileEntries.size() > fileNo) {
            return ((AppleFileSource)this.fileEntries.get(fileNo)).getSectors();
        }
        return null;
    }

    private DirectoryEntry findParent(DirectoryEntry child) {
        for (AppleFileSource entry : this.fileEntries) {
            if (!((DirectoryEntry)entry).matches(child)) continue;
            return (DirectoryEntry)entry;
        }
        return null;
    }

    @Override
    public DataSource getFormattedSector(DiskAddress da) {
        SectorType type = this.sectorTypes[da.getBlockNo()];
        byte[] buffer = this.disk.readBlock(da);
        if (type == this.catalogSector) {
            return new CPMCatalogSector(this.disk, buffer, da);
        }
        return super.getFormattedSector(da);
    }

    @Override
    public AppleFileSource getCatalog() {
        String line = "----  ---------  --- - -  --   --   --   --   -----------------------------------------------\n";
        StringBuilder text = new StringBuilder();
        text.append(String.format("File : %s%n%n", this.getDisplayPath()));
        text.append("User  Name       Typ R S  Ex   S2   S1   RC   Blocks\n");
        text.append(line);
        for (AppleFileSource entry : this.fileEntries) {
            text.append(((DirectoryEntry)entry).line());
            text.append("\n");
        }
        text.append(line);
        if (this.version != 0) {
            text.append("Version: " + this.version);
        }
        return new DefaultAppleFileSource("CPM Disk ", text.toString(), (FormattedDisk)this);
    }

    public static boolean isCorrectFormat(AppleDisk disk) {
        boolean debug = false;
        disk.setInterleave(3);
        ArrayList<DiskAddress> catalog = new ArrayList<DiskAddress>();
        int i = 0;
        while (i < 8) {
            catalog.add(disk.getDiskAddress(3, i));
            ++i;
        }
        byte[] buffer = disk.readBlocks(catalog);
        if (debug) {
            System.out.println(HexFormatter.format(buffer));
        }
        int i2 = 0;
        while (i2 < 2) {
            int start = i2 * 1024;
            int end = start + 1024;
            int ptr = start;
            while (ptr < end) {
                if (buffer[ptr] == -27) {
                    if (buffer[ptr + 1] == -27 || buffer[ptr + 1] == 0) {
                        break;
                    }
                } else {
                    int userNo = buffer[ptr] & 0xFF;
                    if (userNo > 31) {
                        return false;
                    }
                    int j = 1;
                    while (j < 12) {
                        int ch = buffer[ptr + j] & 0x7F;
                        if (ch < 32 || ch > 126) {
                            return false;
                        }
                        ++j;
                    }
                    if (debug) {
                        String fileName = new String(buffer, ptr + 1, 8);
                        String fileType = new String(buffer, ptr + 9, 3);
                        System.out.printf("%2d  %s %s%n", userNo, fileName, fileType);
                    }
                }
                ptr += 32;
            }
            ++i2;
        }
        if (debug) {
            System.out.println("CP/M disk");
        }
        return true;
    }

    private static boolean isCorrectFormat2(AppleDisk disk) {
        byte[] buffer;
        disk.setInterleave(3);
        int i = 8;
        while (i >= 4) {
            buffer = disk.readBlock(0, i);
            String text = new String(buffer, 16, 24);
            if ("DIR ERA TYPESAVEREN USER".equals(text)) {
                int version = buffer[41] & 0xFF;
                System.out.printf("CPM version %d%n", version);
                return true;
            }
            i -= 2;
        }
        int sector = 0;
        while (sector < 8) {
            buffer = disk.readBlock(3, sector);
            System.out.println(HexFormatter.format(buffer));
            if (CPMDisk.bufferContainsAll(buffer, (byte)-27)) break;
            int b1 = buffer[0] & 0xFF;
            int b2 = buffer[1] & 0xFF;
            if (b1 != 229 || b2 != 229 && b2 != 0) {
                if (b1 > 31 && b1 != 229 || b2 < 32 || b2 > 126 && b2 != 229) break;
                int i2 = 0;
                while (i2 < buffer.length) {
                    b1 = buffer[i2] & 0xFF;
                    b2 = buffer[i2 + 1] & 0xFF;
                    if (b1 != 229 && (b2 < 32 || b2 > 126 && b2 != 229)) {
                        return false;
                    }
                    i2 += 32;
                }
            }
            ++sector;
        }
        return true;
    }

    private static boolean bufferContainsAll(byte[] buffer, byte value) {
        byte[] byArray = buffer;
        int n = buffer.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (b != value) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

