/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.appleworks;

import com.bytezone.diskbrowser.appleworks.AppleworksADBFile;
import com.bytezone.diskbrowser.appleworks.Record;
import com.bytezone.diskbrowser.appleworks.Report;

class TableReport
extends Report {
    private final int[] columnWidths = new int[33];
    private final int[] spaces = new int[33];
    private final int[] footTotals = new int[33];
    private final int[] justification = new int[33];
    private final int[] reportCategoryNames = new int[33];
    private final int[] calculatedColumn = new int[3];
    private final String[] calculatedCategory = new String[3];
    private final String[] calculatedRules = new String[3];
    private final int groupTotalColumn;
    private final boolean printGroupTotals;

    TableReport(AppleworksADBFile parent, byte[] buffer, int offset) {
        super(parent, buffer, offset);
        int i = 0;
        while (i < this.categoriesOnThisReport) {
            this.columnWidths[i] = buffer[offset + 20 + i] & 0xFF;
            this.spaces[i] = buffer[offset + 56 + i] & 0xFF;
            this.reportCategoryNames[i] = buffer[offset + 92 + i] & 0xFF;
            this.footTotals[i] = buffer[offset + 128 + i] & 0xFF;
            this.justification[i] = buffer[offset + 164 + i] & 0xFF;
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.calculatedColumn[i] = buffer[offset + 201 + i] & 0xFF;
            this.calculatedCategory[i] = this.pascalString(buffer, offset + 302 + i * 54);
            this.calculatedRules[i] = this.pascalString(buffer, offset + 324 + i * 54);
            ++i;
        }
        this.groupTotalColumn = buffer[offset + 204] & 0xFF;
        this.printGroupTotals = buffer[offset + 217] != 0;
    }

    @Override
    public String getText() {
        int i;
        StringBuilder text = new StringBuilder();
        if (this.printHeader && !this.titleLine.isEmpty()) {
            text.append(this.titleLine);
        } else {
            text.append("Report name: " + this.name);
        }
        text.append("\n\n");
        StringBuilder header = new StringBuilder();
        StringBuilder underline = new StringBuilder();
        int i2 = 0;
        while (i2 < this.categoriesOnThisReport) {
            Object categoryName;
            int category = this.reportCategoryNames[i2];
            if (category < 127) {
                categoryName = this.parent.categoryNames[category - 1];
            } else {
                int calcField = category - 128;
                categoryName = this.calculatedCategory[calcField];
            }
            if (((String)categoryName).length() > this.columnWidths[i2]) {
                categoryName = ((String)categoryName).substring(0, this.columnWidths[i2]);
            }
            header.append((String)categoryName);
            header.append("                                                                                             ".substring(0, this.columnWidths[i2] + this.spaces[i2] - ((String)categoryName).length()));
            underline.append("------------------------------------------------------------------------------------------\n".substring(0, this.columnWidths[i2]));
            underline.append("                                                                                             ".substring(0, this.spaces[i2]));
            ++i2;
        }
        header = this.trimRight(header);
        text.append(header.toString());
        text.append("\n");
        underline = this.trimRight(underline);
        text.append(underline.toString());
        text.append("\n");
        float[] totals = new float[33];
        for (Record record : this.parent.records) {
            i = 0;
            while (i < this.categoriesOnThisReport) {
                String item;
                int category = this.reportCategoryNames[i];
                if (category < 127) {
                    item = record.getItem(category - 1).trim();
                } else {
                    int calcField = category - 128;
                    String cond = this.calculatedRules[calcField];
                    int col = this.calculatedColumn[calcField] - 1;
                    String format = "%12." + this.justification[col] + "f";
                    item = String.format(format, record.calculateItem(calcField, i + 97, cond)).trim();
                }
                if (item.length() > this.columnWidths[i]) {
                    item = item.substring(0, this.columnWidths[i]);
                }
                if (this.footTotals[i] != 255 && !item.isEmpty() && !item.equals(" ")) {
                    try {
                        int n = i;
                        totals[n] = totals[n] + Float.parseFloat(item);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (this.justification[i] != 255) {
                    text.append("                                                                                             ".substring(0, this.columnWidths[i] - item.length()));
                    text.append(item);
                } else {
                    text.append(item);
                    text.append("                                                                                             ".substring(0, this.columnWidths[i] - item.length()));
                }
                text.append("                                                                                             ".substring(0, this.spaces[i]));
                ++i;
            }
            text = this.trimRight(text);
            text.append("\n");
        }
        text.append(underline.toString());
        text.append("\n");
        StringBuilder totalLine = new StringBuilder();
        underline = new StringBuilder();
        boolean hasTotals = false;
        i = 0;
        while (i < this.categoriesOnThisReport) {
            if (this.footTotals[i] == 255) {
                totalLine.append("                                                                                             ".substring(0, this.columnWidths[i]));
                underline.append("                                                                                             ".substring(0, this.columnWidths[i]));
            } else {
                hasTotals = true;
                String format = "%12." + this.footTotals[i] + "f";
                String value = String.format(format, Float.valueOf(totals[i])).trim();
                if (value.length() > this.columnWidths[i]) {
                    value = value.substring(0, this.columnWidths[i]);
                }
                totalLine.append("                                                                                             ".substring(0, this.columnWidths[i] - value.length()));
                totalLine.append(value);
                underline.append("------------------------------------------------------------------------------------------\n".substring(0, this.columnWidths[i]));
            }
            totalLine.append("                                                                                             ".substring(0, this.spaces[i]));
            underline.append("                                                                                             ".substring(0, this.spaces[i]));
            ++i;
        }
        if (hasTotals) {
            text.append(totalLine.toString());
            text.append("\n");
            text.append(underline.toString());
            text.append("\n");
        }
        return text.toString();
    }

    private StringBuilder trimRight(StringBuilder text) {
        while (text.length() > 0 && text.charAt(text.length() - 1) == ' ') {
            text.deleteCharAt(text.length() - 1);
        }
        return text;
    }

    @Override
    public String toString() {
        StringBuilder text = new StringBuilder(super.toString());
        text.append(String.format("Calculated ......... %d %d %d%n", this.calculatedColumn[0], this.calculatedColumn[1], this.calculatedColumn[2]));
        text.append(String.format("Group total ........ %d%n", this.groupTotalColumn));
        text.append(String.format("Print gr totals .... %s%n", this.printGroupTotals));
        text.append(String.format("Calc category1 ..... %s%n", this.calculatedCategory[0]));
        text.append(String.format("Calc rules1 ........ %s%n", this.calculatedRules[0]));
        text.append(String.format("Calc category2 ..... %s%n", this.calculatedCategory[1]));
        text.append(String.format("Calc rules2 ........ %s%n", this.calculatedRules[1]));
        text.append(String.format("Calc category3 ..... %s%n", this.calculatedCategory[2]));
        text.append(String.format("Calc rules3 ........ %s%n", this.calculatedRules[2]));
        text.append(String.format("%n  Width Space Name Foot Just%n", new Object[0]));
        int i = 0;
        while (i < this.categoriesOnThisReport) {
            text.append(String.format("    %2d    %2d   %02X   %02X   %02X %n", this.columnWidths[i], this.spaces[i], this.reportCategoryNames[i], this.footTotals[i], this.justification[i]));
            ++i;
        }
        return text.toString();
    }
}

