/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.appleworks;

import com.bytezone.diskbrowser.appleworks.AppleworksADBFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Record {
    AppleworksADBFile parent;
    int length;
    List<String> items = new ArrayList<String>();
    Map<Integer, Double> calculatedItems = new HashMap<Integer, Double>();

    /*
     * Unable to fully structure code
     */
    Record(AppleworksADBFile parent, byte[] buffer, int ptr) {
        super();
        this.parent = parent;
        while ((count = buffer[ptr++] & 255) != 255) {
            if (count >= 128) ** GOTO lbl28
            if (buffer[ptr] == -64) {
                year = new String(buffer, ptr + 1, 2);
                month = buffer[ptr + 3] - 64;
                day = new String(buffer, ptr + 4, 2).trim();
                if (day.length() == 1) {
                    day = "0" + day;
                }
                this.items.add(String.format("%2s/%02d/%2s", new Object[]{year, month, day}));
            } else if (buffer[ptr] == -44) {
                hour = buffer[ptr + 1] - 64;
                minute = new String(buffer, ptr + 2, 2);
                this.items.add(String.format("%02d:%s", new Object[]{hour, minute}));
            } else {
                this.items.add(new String(buffer, ptr, count));
            }
            ptr += count;
            continue;
lbl-1000:
            // 1 sources

            {
                this.items.add("");
lbl28:
                // 2 sources

                ** while (count-- > 128)
            }
lbl29:
            // 1 sources

        }
        if (this.items.size() > parent.categories) {
            System.out.println("Too many items");
        }
        while (this.items.size() < parent.categories) {
            this.items.add("");
        }
    }

    String getItem(int index) {
        return this.items.get(index);
    }

    double calculateItem(int pos, int name, String condition) {
        try {
            Pattern p = Pattern.compile("([A-Za-z]{1,2})(([-+*/]([A-Za-z]{1,2}|[0-9]))*)");
            Matcher m = p.matcher(condition);
            if (m.matches()) {
                String init = m.group(1);
                String rest = m.group(2);
                double val = Double.parseDouble(this.valueOf(init.charAt(0)));
                Pattern p2 = Pattern.compile("([-+*/])(([A-Za-z]{1,2})|([0-9]{1,6}))");
                Matcher m2 = p2.matcher(rest);
                while (m2.find()) {
                    String operator = m2.group(1).trim();
                    double nextVal = m2.group(3) != null ? Double.parseDouble(this.valueOf(m2.group(3).charAt(0))) : Double.parseDouble(m2.group(4));
                    if (operator.equals("+")) {
                        val += nextVal;
                        continue;
                    }
                    if (operator.equals("-")) {
                        val -= nextVal;
                        continue;
                    }
                    if (operator.equals("/")) {
                        val /= nextVal;
                        continue;
                    }
                    if (operator.equals("*")) {
                        val *= nextVal;
                        continue;
                    }
                    System.out.println("Unknown operator : " + operator);
                }
                this.calculatedItems.put(name, val);
                return val;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0.0;
        }
        return 0.0;
    }

    private String valueOf(int field) {
        int itemNo = field - 65;
        if (itemNo > 26) {
            if (this.calculatedItems.containsKey(field)) {
                return Double.toString(this.calculatedItems.get(field));
            }
            System.out.println("Didn't find : " + field);
        }
        if (itemNo < this.items.size()) {
            return this.items.get(itemNo);
        }
        System.out.printf(" -> can't find: %d out of %d%n", itemNo + 1, this.items.size());
        return "0.0";
    }

    String getReportLine(String format) {
        return String.format(format, this.items.toArray(new String[this.items.size()]));
    }

    String getReportLine() {
        StringBuilder text = new StringBuilder();
        String format = String.format("%%-%ds : %%s%%n", this.parent.maxCategoryName);
        int count = 0;
        for (String item : this.items) {
            if (count < this.parent.categoryNames.length) {
                text.append(String.format(format, this.parent.categoryNames[count++], item));
                continue;
            }
            text.append(String.valueOf(item) + "\n");
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        String format = "%-" + this.parent.maxCategoryName + "s [%s]%n";
        int category = 0;
        for (String item : this.items) {
            text.append(String.format(format, this.parent.categoryNames[category++], item));
        }
        return text.toString();
    }
}

