/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.appleworks;

import com.bytezone.diskbrowser.appleworks.Cell;
import com.bytezone.diskbrowser.appleworks.CellAddress;
import com.bytezone.diskbrowser.utilities.Utility;

class CellFormula {
    private static String[] tokens = new String[]{"@Deg", "@Rad", "@Pi", "@True", "@False", "@Not", "@IsBlank", "@IsNA", "@IsError", "@Exp", "@Ln", "@Log", "@Cos", "@Sin", "@Tan", "@ACos", "@ASin", "@ATan2", "@ATan", "@Mod", "@FV", "@PV", "@PMT", "@Term", "@Rate", "@Round", "@Or", "@And", "@Sum", "@Avg", "@Choose", "@Count", "@Error", "@IRR", "@If", "@Int", "@Lookup", "@Max", "@Min", "@NA", "@NPV", "@Sqrt", "@Abs", "", "<>", ">=", "<=", "=", ">", "<", ",", "^", ")", "-", "+", "/", "*", "(", "-", "+", "..."};
    String value;

    CellFormula(Cell cell, byte[] buffer, int offset, int length) {
        StringBuilder text = new StringBuilder();
        int i = 0;
        while (i < length) {
            int value = buffer[offset + i] & 0xFF;
            if (value < 253) {
                String token = tokens[value - 192];
                text.append(token);
                if (value == 224 || value == 231) {
                    i += 3;
                }
            } else if (value == 253) {
                double d = Utility.getSANEDouble(buffer, offset + i + 1);
                String num = String.format("%f", d).trim();
                while (num.endsWith("0")) {
                    num = num.substring(0, num.length() - 1);
                }
                if (num.endsWith(".")) {
                    num = num.substring(0, num.length() - 1);
                }
                text.append(num);
                i += 8;
            } else if (value == 254) {
                CellAddress address = new CellAddress(buffer, offset + i + 1);
                String cellName = Cell.getCellName(cell.row + address.rowRef, cell.column + address.colRef);
                i += 3;
                text.append(cellName);
            } else if (value == 255) {
                int len = buffer[offset + i + 1] & 0xFF;
                String word = new String(buffer, offset + i + 2, len);
                i += len + 1;
                System.out.println("Word: " + word);
            }
            ++i;
        }
        this.value = text.toString();
    }
}

