/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.appleworks;

class CellFormat {
    boolean labelAllowed;
    boolean valueAllowed;
    boolean display;
    boolean standard;
    boolean fixed;
    boolean dollars;
    boolean commas;
    boolean percent;
    boolean appropriate;
    int decimals;

    CellFormat(byte format) {
        this.display = (format & 0x40) == 0;
        this.labelAllowed = (format & 0x10) == 0;
        this.valueAllowed = (format & 8) == 0;
        int formatting = format & 7;
        this.standard = formatting == 1;
        this.fixed = formatting == 2;
        this.dollars = formatting == 3;
        this.commas = formatting == 4;
        this.percent = formatting == 5;
        this.appropriate = formatting == 6;
    }

    CellFormat(byte format, byte decimals) {
        this(format);
        this.decimals = decimals & 7;
    }

    String mask() {
        String fmt;
        String string = fmt = this.dollars ? "$%" : "%";
        if (this.commas) {
            fmt = String.valueOf(fmt) + ",";
        }
        fmt = String.valueOf(fmt) + "12." + this.decimals;
        fmt = String.valueOf(fmt) + "f";
        if (this.percent) {
            fmt = String.valueOf(fmt) + "%%";
        }
        return fmt;
    }
}

