/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.appleworks;

import com.bytezone.diskbrowser.applefile.AbstractFile;

public class AppleworksWPFile
extends AbstractFile {
    Header header = new Header();

    public AppleworksWPFile(String name, byte[] buffer) {
        super(name, buffer);
    }

    @Override
    public String getText() {
        int leftMargin = this.header.leftMargin;
        int ptr = 300;
        StringBuilder text = new StringBuilder(this.header.toString());
        text.append("\n");
        while (true) {
            int b1 = this.buffer[ptr] & 0xFF;
            int b2 = this.buffer[ptr + 1] & 0xFF;
            if (b1 == 255 && b2 == 255) break;
            switch (b2) {
                case 0: {
                    boolean cr;
                    int len = b1;
                    int b3 = this.buffer[ptr + 2] & 0xFF;
                    int b4 = this.buffer[ptr + 3] & 0xFF;
                    int lineMargin = b3 & 0x7F;
                    boolean containsTabs = (b3 & 0x80) != 0;
                    int textLen = b4 & 0x7F;
                    boolean bl = cr = (b4 & 0x80) != 0;
                    if (b3 == 255) {
                        text.append("--------- Ruler ----------\n");
                    } else {
                        int i = 0;
                        while (i < leftMargin) {
                            text.append(" ");
                            ++i;
                        }
                        i = 0;
                        while (i < lineMargin) {
                            text.append(" ");
                            ++i;
                        }
                        StringBuilder line = new StringBuilder();
                        int p = ptr + 4;
                        ptr += len;
                        len -= 2;
                        while (--len >= 0) {
                            char c;
                            if ((c = (char)this.buffer[p++]) >= ' ') {
                                line.append(c);
                                continue;
                            }
                            if (c != '\u0017') continue;
                            line.append(' ');
                        }
                        text.append(line.toString());
                    }
                    text.append("\n");
                    if (!cr) break;
                    text.append("\n");
                    break;
                }
                case 208: {
                    text.append("\n");
                    break;
                }
                case 217: {
                    leftMargin = b1;
                    break;
                }
                case 218: {
                    int rightMargin = b1;
                    break;
                }
                case 222: {
                    int indent = b1;
                    break;
                }
                case 226: {
                    int paperLength = b1;
                    break;
                }
                case 227: {
                    int topMargin = b1;
                    break;
                }
                case 228: {
                    int bottomMargin = b1;
                    break;
                }
                default: {
                    System.out.printf("Unknown value in %s: %02X %02X%n", this.getName(), b1, b2);
                }
            }
            ptr += 2;
        }
        return text.toString();
    }

    private class Header {
        private final char[] tabStops = new char[80];
        private final String tabs;
        private final boolean zoom;
        private final boolean paginated;
        private final int leftMargin;
        private final boolean mailMerge;
        private final int sfMinVers;
        private final boolean multipleRulers;

        public Header() {
            assert (AppleworksWPFile.this.buffer[4] == 79);
            int ptr = 5;
            int i = 0;
            while (i < 80) {
                this.tabStops[i] = (char)AppleworksWPFile.this.buffer[ptr++];
                ++i;
            }
            this.tabs = new String(this.tabStops);
            this.zoom = AppleworksWPFile.this.buffer[85] != 0;
            this.paginated = AppleworksWPFile.this.buffer[90] != 0;
            this.leftMargin = AppleworksWPFile.this.buffer[91] & 0xFF;
            this.mailMerge = AppleworksWPFile.this.buffer[92] != 0;
            this.multipleRulers = AppleworksWPFile.this.buffer[176] != 0;
            this.sfMinVers = AppleworksWPFile.this.buffer[183] & 0xFF;
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("Tabs ......... %s %n", this.tabs));
            text.append(String.format("Zoom ......... %s %n", this.zoom));
            text.append(String.format("Mail merge ... %s %n", this.mailMerge));
            text.append(String.format("Left margin .. %d %n", this.leftMargin));
            text.append(String.format("Min version .. %d %n", this.sfMinVers));
            text.append(String.format("Mult rulers .. %s %n", this.multipleRulers));
            text.append(String.format("Paginated .... %s %n", this.paginated));
            return text.toString();
        }
    }
}

