/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.appleworks;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.appleworks.LabelReport;
import com.bytezone.diskbrowser.appleworks.Record;
import com.bytezone.diskbrowser.appleworks.Report;
import com.bytezone.diskbrowser.appleworks.TableReport;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;

public class AppleworksADBFile
extends AbstractFile {
    static final String line = "------------------------------------------------------------------------------------------\n";
    private final int headerSize;
    private final int cursorDirectionSRL;
    private final char cursorDirectionMRL;
    private final char currentDisplay;
    final int categories;
    private final int totalReports;
    private final int totalRecords;
    private final int dbMinVersion;
    final String[] categoryNames;
    int maxCategoryName;
    private final int[] columnWidthsMRL = new int[30];
    private final int[] columnCategoryMRL = new int[30];
    private final int[] rowPositionSRL = new int[30];
    private final int[] columnPositionSRL = new int[30];
    private final int[] categorySRL = new int[30];
    private final int firstFrozenColumn;
    private final int lastFrozenColumn;
    private final int leftmostActiveColumn;
    private final int totalCategoriesMRL;
    private final int[] selectionRules = new int[3];
    private final int[] testTypes = new int[3];
    private final int[] continuation = new int[3];
    private final String[] comparison = new String[3];
    private final List<Report> reports = new ArrayList<Report>();
    final List<Record> records = new ArrayList<Record>();
    private final Record standardRecord;

    public AppleworksADBFile(String name, byte[] buffer) {
        super(name, buffer);
        this.dbMinVersion = buffer[218] & 0xFF;
        this.headerSize = Utility.getShort(buffer, 0);
        this.cursorDirectionSRL = buffer[30];
        this.cursorDirectionMRL = (char)buffer[31];
        this.currentDisplay = (char)buffer[34];
        this.categories = buffer[35] & 0xFF;
        this.categoryNames = new String[this.categories];
        this.totalReports = buffer[38] & 0xFF;
        int recs = Utility.getShort(buffer, 36);
        this.totalRecords = this.dbMinVersion == 0 ? recs : recs & Short.MAX_VALUE;
        int i = 0;
        while (i < 30) {
            this.columnWidthsMRL[i] = buffer[42 + i] & 0xFF;
            this.columnCategoryMRL[i] = buffer[78 + i] & 0xFF;
            this.columnPositionSRL[i] = buffer[114 + i] & 0xFF;
            this.rowPositionSRL[i] = buffer[150 + i] & 0xFF;
            this.categorySRL[i] = buffer[186 + i] & 0xFF;
            ++i;
        }
        this.firstFrozenColumn = buffer[219] & 0xFF;
        this.lastFrozenColumn = buffer[220] & 0xFF;
        this.leftmostActiveColumn = buffer[221] & 0xFF;
        this.totalCategoriesMRL = buffer[222] & 0xFF;
        i = 0;
        while (i < 3) {
            this.selectionRules[i] = Utility.getShort(buffer, 223 + i * 2);
            this.testTypes[i] = Utility.getShort(buffer, 229 + i * 2);
            this.continuation[i] = Utility.getShort(buffer, 235 + i * 2);
            this.comparison[i] = new String(buffer, 241 + i * 20, 20);
            ++i;
        }
        int ptr = 357;
        int i2 = 0;
        while (i2 < this.categoryNames.length) {
            this.categoryNames[i2] = new String(buffer, ptr + 1, buffer[ptr] & 0xFF);
            if (this.categoryNames[i2].length() > this.maxCategoryName) {
                this.maxCategoryName = this.categoryNames[i2].length();
            }
            ptr += 22;
            ++i2;
        }
        int reportNo = 0;
        while (reportNo < this.totalReports) {
            char reportFormat = (char)buffer[ptr + 214];
            if (reportFormat == 'H') {
                this.reports.add(new TableReport(this, buffer, ptr));
            } else if (reportFormat == 'V') {
                this.reports.add(new LabelReport(this, buffer, ptr));
            } else {
                System.out.println("Bollocks - report format not H or V : " + reportFormat);
            }
            ptr += 600;
            ++reportNo;
        }
        int length = Utility.getShort(buffer, ptr);
        ptr += 2;
        if (length == 0) {
            this.standardRecord = null;
        } else {
            this.standardRecord = new Record(this, buffer, ptr);
            ptr += length;
            int recordNo = 0;
            while (recordNo < this.totalRecords) {
                length = Utility.getShort(buffer, ptr);
                ptr += 2;
                if (length == 0) break;
                this.records.add(new Record(this, buffer, ptr));
                ptr += length;
                ++recordNo;
            }
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Header size ........ %d%n", this.headerSize));
        text.append(String.format("SRL cursor ......... %d  (1=default, 2=left->right, top->bottom)%n", this.cursorDirectionSRL));
        text.append(String.format("MRL cursor ......... %s  (D=down, R=right)%n", Character.valueOf(this.cursorDirectionMRL)));
        text.append(String.format("Display ............ %s  (R=SRL, /=MRL)%n", Character.valueOf(this.currentDisplay)));
        text.append(String.format("Categories ......... %d%n", this.categories));
        text.append(String.format("Reports ............ %d%n", this.totalReports));
        text.append(String.format("Records ............ %d%n", this.totalRecords));
        text.append(String.format("Standard Record .... %s%n", this.standardRecord != null));
        text.append(String.format("Min version ........ %d%n", this.dbMinVersion));
        text.append(String.format("1st Frozen col ..... %d%n", this.firstFrozenColumn));
        text.append(String.format("Last Frozen col .... %d%n", this.lastFrozenColumn));
        text.append(String.format("Left active col .... %d%n", this.leftmostActiveColumn));
        text.append(String.format("MRL categories ..... %d%n", this.totalCategoriesMRL));
        text.append("\n  Categories:\n");
        int i = 0;
        while (i < this.categories) {
            text.append(String.format("  %2d  %-30s %n", i + 1, this.categoryNames[i]));
            ++i;
        }
        text.append("\n");
        for (Report report : this.reports) {
            text.append(report);
            text.append("\n");
        }
        for (Report report : this.reports) {
            text.append(report.getText());
            text.append("\n");
        }
        text.append(line);
        for (Record record : this.records) {
            text.append(String.valueOf(record.getReportLine()) + "\n");
            text.append(line);
        }
        this.removeTrailing(text, '\n');
        return text.toString();
    }

    private void removeTrailing(StringBuilder text, char c) {
        while (text.charAt(text.length() - 1) == c) {
            text.deleteCharAt(text.length() - 1);
        }
    }
}

