/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;

public class StoredVariables
extends AbstractFile {
    public StoredVariables(String name, byte[] buffer) {
        super(name, buffer);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        String strValue = null;
        int intValue = 0;
        int strPtr = this.buffer.length;
        text.append("File length  : " + HexFormatter.format4(this.buffer.length));
        int totalLength = Utility.getShort(this.buffer, 0);
        text.append("\nTotal length : " + HexFormatter.format4(totalLength));
        int varLength = Utility.getShort(this.buffer, 2);
        text.append("\nVar length   : " + HexFormatter.format4(varLength));
        text.append("\n\n");
        int ptr = 5;
        while (ptr < varLength + 5) {
            String variableName = this.getVariableName(this.buffer[ptr], this.buffer[ptr + 1]);
            text.append(variableName);
            char suffix = variableName.charAt(variableName.length() - 1);
            if (suffix == '$') {
                int strLength = this.buffer[ptr + 2] & 0xFF;
                strValue = HexFormatter.getString(this.buffer, strPtr -= strLength, strLength);
                text.append(" = " + strValue);
            } else if (suffix == '%') {
                intValue = Utility.intValue(this.buffer[ptr + 3], this.buffer[ptr + 2]);
                if ((this.buffer[ptr + 2] & 0x80) != 0) {
                    intValue -= 65536;
                }
                text.append(" = " + intValue);
            } else if (this.hasValue(ptr + 2)) {
                String value = String.valueOf(Utility.floatValue(this.buffer, ptr + 2));
                if (value.endsWith(".0")) {
                    text.append(" = " + value.substring(0, value.length() - 2));
                } else {
                    text.append(" = " + value);
                }
            }
            text.append("\n");
            ptr += 7;
        }
        this.listArrays(text, ptr, totalLength, strPtr);
        return text.toString();
    }

    private String getVariableName(byte b1, byte b2) {
        char suffix;
        char c2;
        char c1;
        if ((b1 & 0x80) > 0) {
            c1 = (char)(b1 & 0x7F);
            c2 = (char)(b2 & 0x7F);
            suffix = '%';
        } else if ((b2 & 0x80) > 0) {
            c1 = (char)b1;
            c2 = (char)(b2 & 0x7F);
            suffix = '$';
        } else {
            c1 = (char)b1;
            c2 = (char)b2;
            suffix = ' ';
        }
        StringBuilder variableName = new StringBuilder();
        variableName.append(c1);
        if (c2 > ' ') {
            variableName.append(c2);
        }
        if (suffix != ' ') {
            variableName.append(suffix);
        }
        return variableName.toString();
    }

    private String getDimensionText(int[] values) {
        StringBuilder text = new StringBuilder("(");
        int i = 0;
        while (i < values.length) {
            text.append(values[i]);
            if (i < values.length - 1) {
                text.append(',');
            }
            ++i;
        }
        return text.append(')').toString();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private void listArrays(StringBuilder text, int ptr, int totalLength, int strPtr) {
        block0: while (ptr < totalLength + 5) {
            String variableName = this.getVariableName(this.buffer[ptr], this.buffer[ptr + 1]);
            text.append("\n");
            int offset = Utility.getShort(this.buffer, ptr + 2);
            int dimensions = this.buffer[ptr + 4] & 0xFF;
            int[] dimensionSizes = new int[dimensions];
            int totalElements = 0;
            int i = 0;
            while (i < dimensions) {
                int p = i * 2 + 5 + ptr;
                int elements = Utility.intValue(this.buffer[p + 1], this.buffer[p]);
                dimensionSizes[dimensions - i - 1] = elements - 1;
                totalElements = totalElements == 0 ? elements : (totalElements *= elements);
                ++i;
            }
            int headerSize = 5 + dimensions * 2;
            int elementSize = (offset - headerSize) / totalElements;
            int p = ptr + headerSize;
            int[] values = new int[dimensions];
            int i2 = 0;
            while (i2 < values.length) {
                values[i2] = 0;
                ++i2;
            }
            while (true) {
                int n;
                text.append(String.valueOf(variableName) + " " + this.getDimensionText(values) + " = ");
                if (elementSize == 2) {
                    int intValue = Utility.intValue(this.buffer[p + 1], this.buffer[p]);
                    if ((this.buffer[p] & 0x80) > 0) {
                        intValue -= 65536;
                    }
                    text.append(String.valueOf(intValue) + "\n");
                } else if (elementSize == 3) {
                    int strLength = this.buffer[p] & 0xFF;
                    if (strLength > 0) {
                        text.append(HexFormatter.getString(this.buffer, strPtr -= strLength, strLength));
                    }
                    text.append("\n");
                } else if (elementSize == 5) {
                    if (this.hasValue(p)) {
                        text.append(Utility.floatValue(this.buffer, p));
                    }
                    text.append("\n");
                }
                p += elementSize;
                int cp = 0;
                if (true) {
                    n = cp;
                    if ((values[n] = values[n] + 1) <= dimensionSizes[cp]) continue;
                }
                do {
                    values[cp++] = 0;
                    if (cp >= values.length) {
                        ptr += offset;
                        continue block0;
                    }
                    n = cp;
                } while ((values[n] = values[n] + 1) > dimensionSizes[cp]);
            }
        }
    }

    private boolean hasValue(int p) {
        int i = 0;
        while (i < 5) {
            if (this.buffer[p + i] != 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public String getHexDump() {
        StringBuffer text = new StringBuffer();
        text.append("File length  : " + HexFormatter.format4(this.buffer.length));
        int totalLength = Utility.getShort(this.buffer, 0);
        text.append("\nTotal length : " + HexFormatter.format4(totalLength));
        int varLength = Utility.getShort(this.buffer, 2);
        text.append("\nVar length   : " + HexFormatter.format4(varLength));
        int unknown = this.buffer[4] & 0xFF;
        text.append("\nUnknown      : " + HexFormatter.format2(unknown));
        text.append("\n\n");
        int ptr = 5;
        text.append("Simple variables : \n\n");
        while (ptr < varLength + 5) {
            text.append(String.valueOf(HexFormatter.format(this.buffer, ptr, 7, false, 0)) + "\n");
            ptr += 7;
        }
        text.append("\nArrays : \n\n");
        while (ptr < totalLength + 5) {
            int offset = Utility.getShort(this.buffer, ptr + 2);
            int dimensions = this.buffer[ptr + 4] & 0xFF;
            int[] dimensionSizes = new int[dimensions];
            int totalElements = 0;
            int i = 0;
            while (i < dimensions) {
                int elements;
                int p = i * 2 + 5 + ptr;
                dimensionSizes[dimensions - i - 1] = elements = Utility.intValue(this.buffer[p + 1], this.buffer[p]);
                totalElements = totalElements == 0 ? elements : (totalElements *= elements);
                ++i;
            }
            int headerSize = 5 + dimensions * 2;
            text.append(String.valueOf(HexFormatter.format(this.buffer, ptr, headerSize, false, 0)) + "\n\n");
            text.append(String.valueOf(HexFormatter.format(this.buffer, ptr + headerSize, offset - headerSize, false, 0)) + "\n\n");
            ptr += offset;
        }
        text.append("Strings : \n\n");
        int length = this.buffer.length - ptr;
        text.append(String.valueOf(HexFormatter.format(this.buffer, ptr, length, false, 0)) + "\n\n");
        return text.toString();
    }
}

