/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.Shape;
import com.bytezone.diskbrowser.utilities.Utility;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class ShapeTable
extends AbstractFile {
    private final List<Shape> shapes = new ArrayList<Shape>();
    int maxWidth = 0;
    int maxHeight = 0;

    public ShapeTable(String name, byte[] buffer) {
        super(name, buffer);
        int minRow = 200;
        int minCol = 200;
        int maxRow = 200;
        int maxCol = 200;
        int totalShapes = buffer[0] & 0xFF;
        int i = 0;
        while (i < totalShapes) {
            Shape shape = new Shape(buffer, i);
            if (shape.valid) {
                this.shapes.add(shape);
                minRow = Math.min(minRow, shape.minRow);
                minCol = Math.min(minCol, shape.minCol);
                maxRow = Math.max(maxRow, shape.maxRow);
                maxCol = Math.max(maxCol, shape.maxCol);
            }
            ++i;
        }
        this.maxHeight = maxRow - minRow + 1;
        this.maxWidth = maxCol - minCol + 1;
        for (Shape shape : this.shapes) {
            shape.convertGrid(minRow, minCol, this.maxHeight, this.maxWidth);
        }
        int cols = (int)Math.sqrt(this.shapes.size());
        int rows = (this.shapes.size() - 1) / cols + 1;
        this.image = new BufferedImage((cols + 1) * (this.maxWidth + 5), (rows + 1) * (this.maxHeight + 5), 10);
        int x = 10;
        int y = 10;
        int count = 0;
        Graphics2D g2d = this.image.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        for (Shape shape : this.shapes) {
            g2d.drawImage((Image)shape.image, x, y, null);
            x += this.maxWidth + 5;
            if (++count % cols != 0) continue;
            x = 10;
            y += this.maxHeight + 5;
        }
        g2d.dispose();
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("File Name      : %s%n", this.name));
        text.append(String.format("File size      : %,d%n", this.buffer.length));
        text.append(String.format("Total shapes   : %d%n", this.shapes.size()));
        text.append(String.format("Max dimensions : %d x %d%n%n", this.maxWidth, this.maxHeight));
        for (Shape shape : this.shapes) {
            shape.drawText(text);
            text.append("\n");
        }
        return text.toString();
    }

    public static boolean isShapeTable(byte[] buffer) {
        if (buffer.length == 0) {
            return false;
        }
        int totalShapes = buffer[0] & 0xFF;
        if (totalShapes == 0) {
            return false;
        }
        if (totalShapes * 500 < buffer.length) {
            return false;
        }
        int i = 0;
        while (i < totalShapes) {
            int ptr = i * 2 + 2;
            if (ptr >= buffer.length - 1) {
                return false;
            }
            int offset = Utility.getShort(buffer, ptr);
            if (offset == 0 || offset >= buffer.length) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

