/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.utilities.Utility;

public class SegmentDictionary {
    private final boolean isValid;
    private int[] codeAddress = new int[16];
    private int[] codeLength = new int[16];
    private String[] segName = new String[16];

    public SegmentDictionary(String name, byte[] buffer) {
        this.isValid = !name.equals("SYSTEM.INTERP");
        int ptr = 0;
        int seg = 0;
        while (seg < 16) {
            this.codeAddress[seg] = Utility.getShort(buffer, ptr);
            this.codeLength[seg] = Utility.getShort(buffer, ptr += 2);
            ptr += 2;
            ++seg;
        }
        ptr = 64;
        seg = 0;
        while (seg < 16) {
            this.segName[seg] = new String(buffer, ptr, 8);
            ptr += 8;
            ++seg;
        }
    }

    public boolean isValid() {
        return this.isValid;
    }
}

