/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.HiResImage;
import com.bytezone.diskbrowser.nufx.LZW3;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.ArrayList;
import java.util.List;

public class SHRPictureFile2
extends HiResImage {
    HiResImage.ColorTable[] colorTables;
    byte[] controlBytes;
    int rows = 200;
    List<Integer> framePointers = new ArrayList<Integer>();
    int frameNumber;
    int delay;

    public SHRPictureFile2(String name, byte[] buffer, int fileType, int auxType, int eof) {
        super(name, buffer, fileType, auxType, eof);
        switch (fileType) {
            case 192: {
                this.doPnt();
                break;
            }
            case 193: {
                this.doPic();
                break;
            }
            case 194: {
                this.doPic();
                this.doAnimation();
                break;
            }
            default: {
                System.out.println("unknown filetype " + fileType);
            }
        }
        if (this.colorTables != null) {
            this.createImage();
        }
    }

    private void doPnt() {
        switch (this.auxType) {
            case 0: 
            case 32768: {
                this.colorTables = new HiResImage.ColorTable[1];
                this.colorTables[0] = new HiResImage.ColorTable(0, this.buffer, 0);
                byte[] newBuffer = new byte[this.calculateBufferSize(this.buffer, 546)];
                this.unpack(this.buffer, 546, this.buffer.length, newBuffer, 0);
                this.buffer = newBuffer;
                this.rows = this.buffer.length / 160;
                this.controlBytes = new byte[this.rows];
                break;
            }
            case 1: {
                byte[] newBuffer = new byte[this.calculateBufferSize(this.buffer, 0)];
                this.unpack(this.buffer, 0, this.buffer.length, newBuffer, 0);
                this.buffer = newBuffer;
                this.controlBytes = new byte[this.rows];
                System.arraycopy(this.buffer, 32000, this.controlBytes, 0, this.controlBytes.length);
                this.colorTables = new HiResImage.ColorTable[16];
                int i = 0;
                while (i < this.colorTables.length) {
                    this.colorTables[i] = new HiResImage.ColorTable(i, this.buffer, 32256 + i * 32);
                    ++i;
                }
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                System.out.printf("%s: PNT aux 3 (QuickDraw PICT) not written yet%n", this.name);
                this.failureReason = "not written yet";
                byte[] newBuffer = new byte[this.calculateBufferSize(this.buffer, 0)];
                this.unpack(this.buffer, 0, this.buffer.length, newBuffer, 0);
                this.buffer = newBuffer;
                int mode = Utility.getShort(this.buffer, 0);
                int rect1 = Utility.getLong(this.buffer, 2);
                int rect2 = Utility.getLong(this.buffer, 6);
                int version = Utility.getShort(this.buffer, 10);
                break;
            }
            case 4: {
                System.out.printf("%s: PNT aux 4 (Packed SHR Brooks Image) not tested yet%n", this.name);
            }
            case 99: {
                this.colorTables = new HiResImage.ColorTable[200];
                int i = 0;
                while (i < this.colorTables.length) {
                    this.colorTables[i] = new HiResImage.ColorTable(i, this.buffer, 4 + i * 32);
                    this.colorTables[i].reverse();
                    ++i;
                }
                byte[] newBuffer = new byte[this.calculateBufferSize(this.buffer, 6404)];
                this.unpack(this.buffer, 6404, this.buffer.length, newBuffer, 0);
                this.buffer = newBuffer;
                break;
            }
            case 4096: {
                if (this.buffer.length < 32768) {
                    this.failureReason = "file size not 32,768";
                    break;
                }
                this.controlBytes = new byte[this.rows];
                System.arraycopy(this.buffer, 32000, this.controlBytes, 0, this.controlBytes.length);
                this.colorTables = new HiResImage.ColorTable[16];
                int i = 0;
                while (i < this.colorTables.length) {
                    this.colorTables[i] = new HiResImage.ColorTable(i, this.buffer, 32256 + i * 32);
                    ++i;
                }
                break;
            }
            case 32773: {
                int ptr = this.buffer.length - 17;
                int imageType = Utility.getShort(this.buffer, ptr);
                int imageHeight = Utility.getShort(this.buffer, ptr + 2);
                int imageWidth = Utility.getShort(this.buffer, ptr + 4);
                String id = HexFormatter.getPascalString(this.buffer, ptr + 6);
                assert ("DreamWorld".equals(id));
                int expectedLen = 32512;
                expectedLen = imageType == 0 ? (expectedLen += 768) : (expectedLen += 6400);
                byte[] dstBuffer = new byte[expectedLen + 1024];
                LZW3 lzw3 = new LZW3();
                int bytes = lzw3.unpack(this.buffer, dstBuffer, expectedLen);
                this.buffer = dstBuffer;
                this.colorTables = new HiResImage.ColorTable[imageHeight];
                int i = 0;
                while (i < this.colorTables.length) {
                    this.colorTables[i] = new HiResImage.ColorTable(i, this.buffer, 32000 + i * 32);
                    this.colorTables[i].reverse();
                    ++i;
                }
                break;
            }
            default: {
                System.out.printf("%s: PNT unknown aux: %04X%n", this.name, this.auxType);
                this.failureReason = "unknown PNT aux";
            }
        }
    }

    private void doAnimation() {
        int ptr;
        this.delay = Utility.getLong(this.buffer, 32772);
        if (this.delay > 60) {
            this.delay = 10;
        }
        this.delay = this.delay * 1000 / 60;
        int start = ptr = 32780;
        while (ptr < this.buffer.length) {
            int off = Utility.getShort(this.buffer, ptr);
            ptr += 4;
            if (off != 0) continue;
            this.framePointers.add(start);
            start = ptr;
        }
    }

    private void doPic() {
        switch (this.auxType) {
            case 0: 
            case 66: 
            case 67: 
            case 8192: 
            case 16640: 
            case 18768: {
                this.controlBytes = new byte[this.rows];
                System.arraycopy(this.buffer, 32000, this.controlBytes, 0, this.controlBytes.length);
                this.colorTables = new HiResImage.ColorTable[16];
                int i = 0;
                while (i < this.colorTables.length) {
                    this.colorTables[i] = new HiResImage.ColorTable(i, this.buffer, 32256 + i * 32);
                    ++i;
                }
                break;
            }
            case 1: {
                System.out.printf("%s: PIC aux 1 (QuickDraw PICT) not written yet%n", this.name);
                this.failureReason = "not written yet";
                break;
            }
            case 2: {
                int cfr_ignored_0 = this.buffer.length;
                int maxTables = (this.buffer.length - 32000) / 32;
                this.colorTables = new HiResImage.ColorTable[maxTables];
                int i = 0;
                while (i < this.colorTables.length) {
                    this.colorTables[i] = new HiResImage.ColorTable(i, this.buffer, 32000 + i * 32);
                    this.colorTables[i].reverse();
                    ++i;
                }
                break;
            }
            default: {
                System.out.printf("PIC unknown aux: %04X%n ", this.auxType);
                this.failureReason = "unknown PIC aux";
            }
        }
    }

    @Override
    void createMonochromeImage() {
        System.out.println("monochrome not written");
    }

    @Override
    void createColourImage() {
        int imageWidth = 640;
        this.image = new BufferedImage(imageWidth, this.rows * 2, 1);
        DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
        int element = 0;
        int ptr = 0;
        boolean mode320 = true;
        boolean fillMode = false;
        HiResImage.ColorTable colorTable = null;
        int max = 160;
        int line = 0;
        while (line < this.rows) {
            if (this.controlBytes != null) {
                int controlByte = this.controlBytes[line] & 0xFF;
                colorTable = this.colorTables[controlByte & 0xF];
                mode320 = (controlByte & 0x80) == 0;
                fillMode = (controlByte & 0x20) != 0;
            } else {
                colorTable = line < this.colorTables.length ? this.colorTables[line] : null;
            }
            ptr = mode320 ? this.mode320Line(ptr, element, max, colorTable, dataBuffer, imageWidth) : this.mode640Line(ptr, element, max, colorTable, dataBuffer, imageWidth);
            element += imageWidth * 2;
            ++line;
        }
    }

    public void nextFrame() {
        int offset;
        int ptr = this.framePointers.get(this.frameNumber++);
        this.frameNumber %= this.framePointers.size();
        while ((offset = Utility.getShort(this.buffer, ptr)) != 0) {
            this.buffer[offset] = this.buffer[ptr + 2];
            this.buffer[offset + 1] = this.buffer[ptr + 3];
            ptr += 4;
        }
        this.createImage();
    }

    public int getDelay() {
        return this.delay;
    }

    @Override
    public String getText() {
        int i;
        StringBuilder text = new StringBuilder(super.getText());
        text.append("\n\n");
        if (this.controlBytes != null) {
            text.append("SCB\n---\n");
            i = 0;
            while (i < this.controlBytes.length) {
                int j = 0;
                while (j < 8) {
                    if (i + j >= this.controlBytes.length) break;
                    text.append(String.format("  %3d:  %02X  ", i + j, this.controlBytes[i + j]));
                    ++j;
                }
                text.append("\n");
                i += 8;
            }
            text.append("\n");
        }
        if (this.colorTables != null) {
            text.append("Color Table\n\n #");
            i = 0;
            while (i < 16) {
                text.append(String.format("   %02X ", i));
                ++i;
            }
            text.append("\n--");
            i = 0;
            while (i < 16) {
                text.append("  ----");
                ++i;
            }
            text.append("\n");
            HiResImage.ColorTable[] colorTableArray = this.colorTables;
            int n = this.colorTables.length;
            int n2 = 0;
            while (n2 < n) {
                HiResImage.ColorTable colorTable = colorTableArray[n2];
                text.append(colorTable.toLine());
                text.append("\n");
                ++n2;
            }
        }
        text.append("\nScreen lines\n\n");
        int i2 = 0;
        while (i2 < 200) {
            text.append(String.format("Line: %02X  %<3d%n", i2));
            text.append(HexFormatter.format(this.buffer, i2 * 160, 160));
            text.append("\n\n");
            ++i2;
        }
        text.deleteCharAt(text.length() - 1);
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }
}

