/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.prodos.DirectoryHeader;
import com.bytezone.diskbrowser.prodos.ProdosConstants;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class ProdosDirectory
extends AbstractFile
implements ProdosConstants {
    static final DateTimeFormatter df = DateTimeFormatter.ofPattern("d-LLL-yy");
    static final DateTimeFormatter tf = DateTimeFormatter.ofPattern("H:mm");
    static final String UNDERLINE = "----------------------------------------------------\n";
    private static final String NO_DATE = "<NO DATE>";
    private final ProdosDisk parentFD;
    private final int totalBlocks;
    private final int freeBlocks;
    private final int usedBlocks;

    public ProdosDirectory(FormattedDisk parent, String name, byte[] buffer, int totalBlocks, int freeBlocks, int usedBlocks) {
        super(name, buffer);
        this.parentFD = (ProdosDisk)parent;
        this.totalBlocks = totalBlocks;
        this.freeBlocks = freeBlocks;
        this.usedBlocks = usedBlocks;
    }

    @Override
    public String getText() {
        if (showDebugText) {
            return this.getDebugText();
        }
        return this.getDirectoryText();
    }

    private String getDebugText() {
        List<DirectoryHeader> directoryHeaders = this.parentFD.getDirectoryHeaders();
        StringBuilder text = new StringBuilder();
        for (DirectoryHeader directoryHeader : directoryHeaders) {
            text.append(UNDERLINE);
            text.append(directoryHeader.getText());
            text.append("\n");
            text.append(UNDERLINE);
            directoryHeader.listFileEntries(text);
        }
        return text.toString();
    }

    private String getDirectoryText() {
        StringBuilder text = new StringBuilder();
        text.append("File : " + this.parentFD.getDisplayPath() + "\n\n");
        int i = 0;
        while (i < this.buffer.length) {
            int storageType = (this.buffer[i] & 0xF0) >> 4;
            if (storageType != 0) {
                int nameLength = this.buffer[i] & 0xF;
                String filename = HexFormatter.getString(this.buffer, i + 1, nameLength);
                String subType = "";
                switch (storageType) {
                    case 14: 
                    case 15: {
                        String root = storageType == 15 ? "/" : "";
                        text.append(String.valueOf(root) + filename + "\n\n");
                        text.append(" NAME           TYPE  BLOCKS  MODIFIED         CREATED          ENDFILE SUBTYPE\n\n");
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 13: {
                        int type = this.buffer[i + 16] & 0xFF;
                        int blocks = Utility.getShort(this.buffer, i + 19);
                        LocalDateTime createdDate = Utility.getAppleDate(this.buffer, i + 24);
                        LocalDateTime modifiedDate = Utility.getAppleDate(this.buffer, i + 33);
                        String dateC = createdDate == null ? NO_DATE : createdDate.format(df).toUpperCase();
                        String dateM = modifiedDate == null ? NO_DATE : modifiedDate.format(df).toUpperCase();
                        String timeC = createdDate == null ? "" : createdDate.format(tf);
                        String timeM = modifiedDate == null ? "" : modifiedDate.format(tf);
                        int eof = Utility.intValue(this.buffer[i + 21], this.buffer[i + 22], this.buffer[i + 23]);
                        int fileType = this.buffer[i + 16] & 0xFF;
                        String locked = (this.buffer[i + 30] & 0xE0) == 224 ? " " : "*";
                        switch (fileType) {
                            case 4: {
                                int aux = Utility.getShort(this.buffer, i + 31);
                                subType = String.format("R=%5d", aux);
                                break;
                            }
                            case 6: 
                            case 8: 
                            case 192: 
                            case 193: {
                                int aux = Utility.getShort(this.buffer, i + 31);
                                subType = String.format("A=$%4X", aux);
                                break;
                            }
                            case 26: {
                                int aux = Utility.intValue(this.buffer[i + 32], this.buffer[i + 31]);
                                if (aux == 0) break;
                                filename = this.convert(filename, aux);
                                break;
                            }
                            default: {
                                subType = "";
                            }
                        }
                        String forkFlag = storageType == 5 ? "+" : " ";
                        text.append(String.format("%s%-15s %3s%s  %5d  %9s %5s  %9s %5s %8d %7s%n", locked, filename, ProdosConstants.fileTypes[type], forkFlag, blocks, dateM, timeM, dateC, timeC, eof, subType));
                        break;
                    }
                    default: {
                        text.append(" <Unknown strage type : " + storageType + "\n");
                    }
                }
            }
            i += 39;
        }
        text.append(String.format("%nBLOCKS FREE:%5d     BLOCKS USED:%5d     TOTAL BLOCKS:%5d%n", this.freeBlocks, this.usedBlocks, this.totalBlocks));
        return text.toString();
    }

    private String convert(String name, int flags) {
        char[] newName = name.toCharArray();
        int i = 0;
        int weight = 32768;
        while (i < newName.length) {
            if ((flags & weight) != 0) {
                if (newName[i] == '.') {
                    newName[i] = 32;
                } else if (newName[i] >= 'A' && newName[i] <= 'Z') {
                    int n = i;
                    newName[n] = (char)(newName[n] + 32);
                }
            }
            ++i;
            weight >>>= 1;
        }
        return new String(newName);
    }
}

