/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.Palette;
import java.util.ArrayList;
import java.util.List;

public class PaletteFactory {
    private final List<Palette> palettes = new ArrayList<Palette>();
    private int currentPalette;

    public PaletteFactory() {
        int[] nArray = new int[16];
        nArray[1] = 0xDD0033;
        nArray[2] = 0x885500;
        nArray[3] = 0xFF6600;
        nArray[4] = 30498;
        nArray[5] = 0x555555;
        nArray[6] = 0x11DD00;
        nArray[7] = 0xFFFF00;
        nArray[8] = 153;
        nArray[9] = 0xDD22DD;
        nArray[10] = 0xAAAAAA;
        nArray[11] = 0xFF9988;
        nArray[12] = 0x2222FF;
        nArray[13] = 0x66AAFF;
        nArray[14] = 0x44FF99;
        nArray[15] = 0xFFFFFF;
        this.palettes.add(new Palette("Virtual II", nArray));
        this.palettes.add(new Palette("Applewin (old)", new int[]{this.rgb(0, 0, 0), this.rgb(208, 0, 48), this.rgb(128, 80, 0), this.rgb(255, 128, 0), this.rgb(0, 128, 0), this.rgb(128, 128, 128), this.rgb(0, 255, 0), this.rgb(255, 255, 0), this.rgb(0, 0, 128), this.rgb(255, 0, 255), this.rgb(192, 192, 192), this.rgb(255, 144, 128), this.rgb(0, 0, 255), this.rgb(96, 160, 255), this.rgb(64, 255, 144), this.rgb(255, 255, 255)}));
        int[] nArray2 = new int[16];
        nArray2[1] = 10291558;
        nArray2[2] = 0x555500;
        nArray2[3] = 15883776;
        nArray2[4] = 30234;
        nArray2[5] = 0x808080;
        nArray2[6] = 3721984;
        nArray2[7] = 14013722;
        nArray2[8] = 2763493;
        nArray2[9] = 13055231;
        nArray2[10] = 0xC0C0C0;
        nArray2[11] = 16746981;
        nArray2[12] = 893439;
        nArray2[13] = 0xAAAAFF;
        nArray2[14] = 6485657;
        nArray2[15] = 0xFFFFFF;
        this.palettes.add(new Palette("Applewin (new)", nArray2));
        this.palettes.add(new Palette("Kegs", new int[]{this.rgb(0, 0, 0), this.rgb(221, 0, 51), this.rgb(136, 85, 34), this.rgb(255, 102, 0), this.rgb(0, 119, 0), this.rgb(85, 85, 85), this.rgb(0, 221, 0), this.rgb(255, 255, 0), this.rgb(0, 0, 153), this.rgb(221, 0, 221), this.rgb(170, 170, 170), this.rgb(255, 153, 136), this.rgb(34, 34, 255), this.rgb(102, 170, 255), this.rgb(0, 255, 153), this.rgb(255, 255, 255)}));
        int[] nArray3 = new int[16];
        nArray3[1] = 0xD00030;
        nArray3[2] = 0x805000;
        nArray3[3] = 0xF06000;
        nArray3[4] = 28704;
        nArray3[5] = 0x505050;
        nArray3[6] = 0x10D000;
        nArray3[7] = 0xF0F000;
        nArray3[8] = 144;
        nArray3[9] = 0xD020D0;
        nArray3[10] = 0xA0A0A0;
        nArray3[11] = 15765632;
        nArray3[12] = 0x2020F0;
        nArray3[13] = 6332656;
        nArray3[14] = 4255888;
        nArray3[15] = 0xFFFFFF;
        this.palettes.add(new Palette("Authentic", nArray3));
        int[] nArray4 = new int[16];
        nArray4[1] = 0xD00030;
        nArray4[2] = 0x805000;
        nArray4[3] = 0xFF8000;
        nArray4[4] = 32768;
        nArray4[5] = 0x808080;
        nArray4[6] = 65280;
        nArray4[7] = 0xFFFF00;
        nArray4[8] = 128;
        nArray4[9] = 0xFF00FF;
        nArray4[10] = 0xC0C0C0;
        nArray4[11] = 16748672;
        nArray4[12] = 255;
        nArray4[13] = 6332671;
        nArray4[14] = 4259728;
        nArray4[15] = 0xFFFFFF;
        this.palettes.add(new Palette("Tweaked", nArray4));
        int[] nArray5 = new int[16];
        nArray5[1] = 9443136;
        nArray5[2] = 0x405400;
        nArray5[3] = 13658650;
        nArray5[4] = 26944;
        nArray5[5] = 0x808080;
        nArray5[6] = 3128346;
        nArray5[7] = 12571482;
        nArray5[8] = 4205733;
        nArray5[9] = 13648869;
        nArray5[10] = 0x808080;
        nArray5[11] = 16750271;
        nArray5[12] = 3118565;
        nArray5[13] = 0xBFABFF;
        nArray5[14] = 7334079;
        nArray5[15] = 0xFFFFFF;
        this.palettes.add(new Palette("NTSC corrected", nArray5));
        this.palettes.add(new Palette("Wikipedia", new int[]{this.rgb(0, 0, 0), this.rgb(114, 38, 64), this.rgb(64, 76, 0), this.rgb(228, 101, 1), this.rgb(14, 89, 64), this.rgb(128, 128, 128), this.rgb(27, 203, 1), this.rgb(191, 204, 128), this.rgb(64, 51, 127), this.rgb(228, 52, 254), this.rgb(128, 128, 128), this.rgb(241, 166, 191), this.rgb(27, 154, 254), this.rgb(191, 179, 255), this.rgb(141, 217, 191), this.rgb(255, 255, 255)}));
    }

    public Palette cyclePalette(CycleDirection direction) {
        switch (direction) {
            case FORWARDS: {
                ++this.currentPalette;
                if (this.currentPalette < this.palettes.size()) break;
                this.currentPalette = 0;
                break;
            }
            case BACKWARDS: {
                --this.currentPalette;
                if (this.currentPalette >= 0) break;
                this.currentPalette = this.palettes.size() - 1;
            }
        }
        return this.getCurrentPalette();
    }

    public List<Palette> getPalettes() {
        return this.palettes;
    }

    public Palette getCurrentPalette() {
        return this.palettes.get(this.currentPalette);
    }

    public int getCurrentPaletteIndex() {
        return this.currentPalette;
    }

    public void setCurrentPalette(int index) {
        assert (index >= 0 && index < this.palettes.size());
        this.currentPalette = index;
    }

    public void setCurrentPalette(Palette palette) {
        int count = 0;
        for (Palette p : this.palettes) {
            if (p == palette) {
                this.currentPalette = count;
                break;
            }
            ++count;
        }
    }

    public Palette get(int index) {
        return this.palettes.get(index);
    }

    private int rgb(int red, int green, int blue) {
        return red << 16 | green << 8 | blue;
    }

    public static enum CycleDirection {
        FORWARDS,
        BACKWARDS;

    }
}

