/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.HiResImage;
import com.bytezone.diskbrowser.applefile.Palette;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;

public class OriginalHiResImage
extends HiResImage {
    private static final int WHITE = 0xFFFFFF;
    private static final int BLACK = 0;
    private static final int[][] paletteTable = new int[][]{{9, 6}, {12, 3}};
    private static boolean matchColourBits = false;
    private final int[] line = new int[280];
    private final int[] colourBits = new int[280];

    public OriginalHiResImage(String name, byte[] buffer, int loadAddress) {
        super(name, buffer, loadAddress);
        this.createImage();
    }

    public OriginalHiResImage(String name, byte[] buffer, int loadAddress, boolean scrunched) {
        super(name, buffer, loadAddress, scrunched);
        this.createImage();
    }

    public OriginalHiResImage(String name, byte[] buffer, int fileType, int auxType, int eof) {
        super(name, buffer, fileType, auxType, eof);
    }

    @Override
    protected void createMonochromeImage() {
        int rows = this.buffer.length <= 8192 ? 192 : 384;
        this.image = new BufferedImage(280, rows, 10);
        DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
        int element = 0;
        int page = 0;
        while (page < rows / 192) {
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 8) {
                    int k = 0;
                    while (k < 8) {
                        int base = page * 8192 + i * 40 + j * 128 + k * 1024;
                        int max = Math.min(base + 40, this.buffer.length);
                        int ptr = base;
                        while (ptr < max) {
                            int value = this.buffer[ptr] & 0x7F;
                            if ((this.buffer[ptr] & 0x80) != 0) {
                                System.out.printf("bit shift pixel found in %s%n", this.name);
                            }
                            int px = 0;
                            while (px < 7) {
                                int val = value >> px & 1;
                                dataBuffer.setElem(element++, val == 0 ? 0 : 255);
                                ++px;
                            }
                            ++ptr;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++page;
        }
    }

    @Override
    protected void createColourImage() {
        this.paletteIndex = paletteFactory.getCurrentPaletteIndex();
        int rows = this.buffer.length <= 8192 ? 192 : 384;
        this.image = new BufferedImage(280, rows, 1);
        DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
        int element = 0;
        int page = 0;
        while (page < rows / 192) {
            int i = 0;
            while (i < 3) {
                int j = 0;
                while (j < 8) {
                    int k = 0;
                    while (k < 8) {
                        this.fillLine(page * 8192 + i * 40 + j * 128 + k * 1024);
                        int[] nArray = this.line;
                        int n = this.line.length;
                        int n2 = 0;
                        while (n2 < n) {
                            int pixel = nArray[n2];
                            dataBuffer.setElem(element++, pixel);
                            ++n2;
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            ++page;
        }
    }

    private void fillLine(int base) {
        Palette palette = paletteFactory.getCurrentPalette();
        int[] colours = palette.getColours();
        int max = Math.min(base + 40, this.buffer.length);
        int linePtr = 0;
        assert (this.colourBits != null);
        int ptr = base;
        while (ptr < max) {
            int colourBit = (this.buffer[ptr] & 0x80) >> 7;
            int value = this.buffer[ptr] & 0x7F;
            int px = 0;
            while (px < 7) {
                this.colourBits[linePtr] = colourBit;
                int val = value >> px & 1;
                int column = (ptr + px) % 2;
                this.line[linePtr++] = val == 0 ? 0 : colours[paletteTable[colourBit][column]];
                ++px;
            }
            ++ptr;
        }
        int x = 1;
        while (x < this.line.length) {
            if (!matchColourBits || this.colourBits[x - 1] == this.colourBits[x]) {
                int px0 = this.line[x - 1];
                int px1 = this.line[x];
                if (px0 != 0 && px1 != 0) {
                    this.line[x] = 0xFFFFFF;
                    this.line[x - 1] = 0xFFFFFF;
                }
            }
            ++x;
        }
        if (colourQuirks) {
            this.applyColourQuirks();
        }
    }

    private boolean isColoured(int pixel) {
        return pixel != 0 && pixel != 0xFFFFFF;
    }

    private void applyColourQuirks() {
        int x = 3;
        while (x < this.line.length) {
            if (!matchColourBits || this.colourBits[x - 2] == this.colourBits[x - 1]) {
                int px0 = this.line[x - 3];
                int px1 = this.line[x - 2];
                int px2 = this.line[x - 1];
                int px3 = this.line[x];
                if (px1 == 0) {
                    if (px3 == 0 && px0 == px2 && this.isColoured(px0)) {
                        this.line[x - 2] = px0;
                    } else if (px3 == 0xFFFFFF && px2 == 0xFFFFFF && this.isColoured(px0)) {
                        this.line[x - 2] = px0;
                    }
                } else if (px2 == 0) {
                    if (px0 == 0 && px1 == px3 && this.isColoured(px3)) {
                        this.line[x - 1] = px3;
                    } else if (px0 == 0xFFFFFF && px1 == 0xFFFFFF && this.isColoured(px3)) {
                        this.line[x - 1] = px3;
                    }
                }
            }
            ++x;
        }
    }
}

