/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.SegmentHeader;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;

public class ObjectModule
extends AbstractFile {
    List<SegmentHeader> segmentHeaders = new ArrayList<SegmentHeader>();

    public ObjectModule(String name, byte[] buffer, int auxType) {
        super(name, buffer);
        int ptr = 0;
        while (ptr < buffer.length - 4) {
            int byteCount = Utility.getLong(buffer, ptr);
            if (byteCount == 0) break;
            this.segmentHeaders.add(new SegmentHeader(buffer, ptr));
            ptr += byteCount;
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder("Name : " + this.name + "\n\n");
        text.append("Object Module\n\n");
        for (SegmentHeader segmentHeader : this.segmentHeaders) {
            text.append(segmentHeader);
            text.append("\n");
        }
        return text.toString();
    }
}

