/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;

public class MerlinSource
extends AbstractFile {
    int ptr;
    private static int[] tabs = new int[]{12, 19, 35};
    private static int TAB_POS = tabs[2];
    private final int recordLength;
    private final int eof;
    private boolean prodosFile;

    public MerlinSource(String name, byte[] buffer, int recordLength, int eof) {
        super(name, buffer);
        this.eof = eof;
        this.recordLength = recordLength;
        this.prodosFile = true;
    }

    public MerlinSource(String name, byte[] buffer, int loadAddress) {
        super(name, buffer);
        this.eof = 0;
        this.recordLength = 0;
        this.loadAddress = loadAddress;
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append("Merlin source : " + this.name + "\n");
        if (this.prodosFile) {
            text.append(String.format("Record length : %,8d%n", this.recordLength));
            text.append(String.format("EOF (aux)     : %,8d%n", this.eof));
        } else {
            text.append(String.format("Buffer size   : %04X   %<,8d%n", this.buffer.length));
            text.append(String.format("Load address  : %04X   %<,8d%n", this.loadAddress));
        }
        text.append("\n");
        this.ptr = 0;
        while (this.ptr < this.buffer.length && this.buffer[this.ptr] != 0) {
            text.append(String.valueOf(this.getLine()) + "\n");
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    private String getLine() {
        StringBuilder line = new StringBuilder();
        boolean comment = false;
        boolean string = false;
        while (this.ptr < this.buffer.length) {
            int val;
            if ((val = this.buffer[this.ptr++] & 0x7F) == 13) break;
            if (val == 42 && line.length() == 0) {
                comment = true;
            }
            if (val == 34) {
                boolean bl = string = !string;
            }
            if (val == 59 && !comment) {
                comment = true;
                while (line.length() < TAB_POS) {
                    line.append(' ');
                }
            }
            if (val == 32 && !comment && !string) {
                if ((line = this.tab(line)).length() < tabs[2]) continue;
                comment = true;
                continue;
            }
            line.append((char)val);
        }
        return line.toString();
    }

    private StringBuilder tab(StringBuilder text) {
        int nextTab = 0;
        int[] nArray = tabs;
        int n = tabs.length;
        int n2 = 0;
        while (n2 < n) {
            int tab = nArray[n2];
            if (text.length() < tab) {
                nextTab = tab;
                break;
            }
            ++n2;
        }
        while (text.length() < nextTab) {
            text.append(' ');
        }
        return text;
    }
}

