/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;

public class LodeRunner
extends AbstractFile {
    private static char[] chars = new char[]{' ', '-', '=', '+', '^', '~', '#', '$', '*', 'x'};

    public LodeRunner(String name, byte[] buffer) {
        super(name, buffer);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append("Lode Runner Level\n\n");
        int level = 0;
        while (level < 150) {
            int ptr = level * 256 + 226;
            String levelName = "";
            if (this.buffer[ptr] != 0 && this.buffer[ptr] != -1) {
                levelName = HexFormatter.sanitiseString(this.buffer, ptr, 15);
            }
            text.append(String.format("Level %d  %s%n%n", level + 1, levelName));
            ptr = 0;
            int i = level * 256;
            int max = i + 224;
            while (i < max) {
                String val = String.format("%02X", this.buffer[i]);
                text = this.addPosition(text, val.charAt(0));
                text.append(' ');
                text = this.addPosition(text, val.charAt(1));
                text.append(' ');
                if (++ptr % 14 == 0) {
                    text.append("\n");
                }
                ++i;
            }
            text.append("\n\n");
            ++level;
        }
        return text.toString();
    }

    private StringBuilder addPosition(StringBuilder text, char c) {
        if (c >= '\u0000' && c <= '\t') {
            text.append(chars[c]);
        } else {
            text.append(c);
        }
        return text;
    }
}

