/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.applefile.BasicProgram;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;

public class IntegerBasicProgram
extends BasicProgram {
    private static String[] tokens = new String[]{"?", "?", "?", " : ", "?", "?", "?", "?", "?", "?", "?", "?", "CLR", "?", "?", "?", "HIMEM: ", "LOMEM: ", " + ", " - ", " * ", " / ", " = ", " # ", " >= ", " > ", " <= ", " <> ", " < ", " AND ", " OR ", " MOD ", "^", "+", "(", ",", " THEN ", " THEN ", ",", ",", "\"", "\"", "(", "!", "!", "(", "PEEK ", "RND ", "SGN", "ABS", "PDL", "RNDX", "(", "+", "-", "NOT ", "(", "=", "#", "LEN(", "ASC(", "SCRN(", ",", "(", "$", "$", "(", ", ", ",", ";", ";", ";", ",", ",", ",", "TEXT", "GR ", "CALL ", "DIM ", "DIM ", "TAB ", "END", "INPUT ", "INPUT ", "INPUT ", "FOR ", " = ", " TO ", " STEP ", "NEXT ", ",", "RETURN", "GOSUB ", "REM ", "LET ", "GOTO ", "IF ", "PRINT ", "PRINT ", "PRINT", "POKE ", ",", "COLOR=", "PLOT", ",", "HLIN", ",", " AT ", "VLIN ", ",", " AT ", "VTAB ", " = ", " = ", ")", ")", "LIST ", ",", "LIST ", "POP ", "NODSP ", "NODSP ", "NOTRACE ", "DSP ", "DSP ", "TRACE ", "PR#", "IN#"};

    public IntegerBasicProgram(String name, byte[] buffer) {
        super(name, buffer);
    }

    @Override
    public String getText() {
        StringBuilder pgm = new StringBuilder();
        pgm.append("Name    : " + this.name + "\n");
        pgm.append(String.format("Length  : $%04X (%<,d)%n%n", this.buffer.length));
        int ptr = 0;
        boolean looksLikeAssembler = this.checkForAssembler();
        boolean looksLikeSCAssembler = this.checkForSCAssembler();
        while (ptr < this.buffer.length) {
            int lineLength = this.buffer[ptr] & 0xFF;
            int p2 = ptr + lineLength - 1;
            if (p2 < 0 || p2 >= this.buffer.length || this.buffer[p2] != 1 && this.buffer[p2] != 0) {
                pgm.append("\nPossible assembler code follows\n");
                break;
            }
            if (lineLength <= 0) break;
            if (looksLikeSCAssembler) {
                this.appendSCAssembler(pgm, ptr);
            } else if (looksLikeAssembler) {
                this.appendAssembler(pgm, ptr, lineLength);
            } else {
                this.appendInteger(pgm, ptr, lineLength);
            }
            pgm.append("\n");
            ptr += lineLength;
        }
        if (ptr + 4 < this.buffer.length) {
            int address = Utility.intValue(this.buffer[ptr + 2], this.buffer[ptr + 3]);
            int remainingBytes = this.buffer.length - ptr - 5;
            byte[] newBuffer = new byte[remainingBytes];
            System.arraycopy(this.buffer, ptr + 4, newBuffer, 0, remainingBytes);
            AssemblerProgram ap = new AssemblerProgram("embedded", newBuffer, address);
            pgm.append("\n" + ap.getText() + "\n");
        }
        pgm.deleteCharAt(pgm.length() - 1);
        return pgm.toString();
    }

    private void appendAssembler(StringBuilder pgm, int ptr, int lineLength) {
        int i = ptr + 3;
        while (i < ptr + lineLength - 1) {
            if ((this.buffer[i] & 0x80) == 128) {
                int spaces = this.buffer[i] & 0xF;
                int j = 0;
                while (j < spaces) {
                    pgm.append(' ');
                    ++j;
                }
            } else {
                int b = this.buffer[i] & 0xFF;
                pgm.append((char)b);
            }
            ++i;
        }
    }

    private boolean checkForAssembler() {
        int ptr = 0;
        while (ptr < this.buffer.length) {
            int p2;
            int lineLength = this.buffer[ptr] & 0xFF;
            if (lineLength == 255) {
                System.out.printf("Line length %d%n", lineLength);
            }
            if ((p2 = ptr + lineLength - 1) < 0 || p2 >= this.buffer.length || this.buffer[p2] != 1 && this.buffer[p2] != 0 || lineLength <= 0) break;
            if (this.buffer[ptr + 3] == 59 || this.buffer[ptr + 3] == 42) {
                return true;
            }
            ptr += lineLength;
        }
        return false;
    }

    private boolean checkForSCAssembler() {
        if (this.buffer.length == 0) {
            System.out.println("Empty buffer array");
            return false;
        }
        int lineLength = this.buffer[0] & 0xFF;
        if (lineLength <= 0) {
            return false;
        }
        return this.buffer[lineLength - 1] == 0;
    }

    private void appendSCAssembler(StringBuilder text, int ptr) {
        int lineNumber = (this.buffer[ptr + 2] & 0xFF) * 256 + (this.buffer[ptr + 1] & 0xFF);
        text.append(String.format("%4d: ", lineNumber));
        int p2 = ptr + 3;
        while (this.buffer[p2] != 0) {
            if (this.buffer[p2] == -64) {
                int repeat = this.buffer[p2 + 1];
                i = 0;
                while (i < repeat) {
                    text.append((char)this.buffer[p2 + 2]);
                    ++i;
                }
                p2 += 2;
            } else if ((this.buffer[p2] & 0x80) != 0) {
                int spaces = this.buffer[p2] & 0x7F;
                i = 0;
                while (i < spaces) {
                    text.append(' ');
                    ++i;
                }
            } else {
                text.append((char)this.buffer[p2]);
            }
            ++p2;
        }
    }

    private void appendInteger(StringBuilder text, int ptr, int lineLength) {
        int lineNumber = Utility.intValue(this.buffer[ptr + 1], this.buffer[ptr + 2]);
        boolean inString = false;
        boolean inRemark = false;
        String lineText = String.format("%5d ", lineNumber);
        int lineTab = lineText.length();
        text.append(lineText);
        int p = ptr + 3;
        while (p < ptr + lineLength - 1) {
            int b = this.buffer[p] & 0xFF;
            if (b == 3 && !inString && !inRemark && this.buffer[p + 1] != 1) {
                text.append(":\n" + "         ".substring(0, lineTab));
            } else if (b >= 176 && b <= 185 && (this.buffer[p - 1] & 0x80) == 0 && !inString && !inRemark) {
                text.append(Utility.intValue(this.buffer[p + 1], this.buffer[p + 2]));
                p += 2;
            } else if (b >= 128) {
                if ((b -= 128) >= 32) {
                    text.append((char)b);
                } else {
                    text.append("<ctrl-" + (char)(b + 64) + ">");
                }
            } else if (!tokens[b].equals("?")) {
                text.append(tokens[b]);
                if (!(b != 40 && b != 41 || inRemark)) {
                    boolean bl = inString = !inString;
                }
                if (b == 93) {
                    inRemark = true;
                }
            } else {
                text.append(" ." + HexFormatter.format2(b) + ". ");
            }
            ++p;
        }
    }

    @Override
    public String getHexDump() {
        StringBuffer pgm = new StringBuffer();
        pgm.append("Name : " + this.name + "\n");
        pgm.append("Length : $" + HexFormatter.format4(this.buffer.length) + " (" + this.buffer.length + ")\n\n");
        int ptr = 0;
        while (ptr < this.buffer.length) {
            int lineLength = this.buffer[ptr] & 0xFF;
            int p2 = ptr + lineLength - 1;
            if (p2 < 0 || p2 >= this.buffer.length || this.buffer[p2] > 1) {
                System.out.println("invalid line");
                break;
            }
            pgm.append(HexFormatter.formatNoHeader(this.buffer, ptr, lineLength));
            pgm.append("\n");
            if (lineLength <= 0) {
                System.out.println("looping");
                break;
            }
            ptr += lineLength;
            pgm.append("\n");
        }
        if (pgm.length() > 0) {
            pgm.deleteCharAt(pgm.length() - 1);
        }
        return pgm.toString();
    }
}

