/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.HiResImage;
import com.bytezone.diskbrowser.prodos.ProdosConstants;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.ArrayList;
import java.util.List;

public class IconFile
extends AbstractFile
implements ProdosConstants {
    private final int iBlkNext;
    private final int iBlkID;
    private final int iBlkPath;
    private final String iBlkName;
    private final List<Icon> icons = new ArrayList<Icon>();
    private final boolean debug = false;

    public IconFile(String name, byte[] buffer) {
        super(name, buffer);
        int base;
        int dataLen;
        this.iBlkNext = Utility.getLong(buffer, 0);
        this.iBlkID = Utility.getShort(buffer, 4);
        this.iBlkPath = Utility.getLong(buffer, 6);
        this.iBlkName = HexFormatter.getHexString(buffer, 10, 16);
        int ptr = 26;
        while ((dataLen = Utility.getShort(buffer, ptr)) != 0 && dataLen + ptr <= buffer.length) {
            Icon icon = new Icon(buffer, ptr);
            if (icon.smallImage != null) {
                this.icons.add(icon);
            }
            ptr += dataLen;
        }
        int maxHeight = 0;
        int maxWidth = 0;
        for (Icon icon : this.icons) {
            maxHeight = Math.max(maxHeight, icon.largeImage.iconHeight);
            maxWidth = Math.max(maxWidth, icon.largeImage.iconWidth);
        }
        int x = base = 10;
        int y = base;
        int gap = 5;
        int columns = Math.min(this.icons.size(), 4);
        int rows = (this.icons.size() - 1) / columns + 1;
        this.image = new BufferedImage(Utility.dimension(columns, base, maxWidth, gap), Utility.dimension(rows, base, maxHeight, gap), 1);
        Graphics2D graphics = this.image.createGraphics();
        graphics.setBackground(Color.WHITE);
        graphics.clearRect(0, 0, this.image.getWidth(), this.image.getHeight());
        Graphics2D g2d = this.image.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        int count = 0;
        for (Icon icon : this.icons) {
            g2d.drawImage((java.awt.Image)icon.largeImage.image, x, y, null);
            x += maxWidth + gap;
            if (++count % columns != 0) continue;
            x = base;
            y += maxHeight + gap;
        }
        g2d.dispose();
        graphics.dispose();
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder("Name : " + this.name + "\n\n");
        text.append(String.format("Next Icon file .. %d%n", this.iBlkNext));
        text.append(String.format("Block ID ........ %d%n", this.iBlkID));
        text.append(String.format("Block path ...... %d%n", this.iBlkPath));
        text.append(String.format("Block name ...... %s%n", this.iBlkName));
        text.append("\n");
        for (Icon icon : this.icons) {
            text.append(icon);
            text.append("\n\n");
        }
        return text.toString();
    }

    class Icon {
        byte[] buffer;
        int iDataLen;
        String pathName;
        String dataName;
        int iDataType;
        int iDataAux;
        Image largeImage;
        Image smallImage;

        public Icon(byte[] fullBuffer, int ptr) {
            this.iDataLen = Utility.getShort(fullBuffer, ptr);
            this.buffer = new byte[this.iDataLen];
            System.arraycopy(fullBuffer, ptr, this.buffer, 0, this.buffer.length);
            int len = this.buffer[2] & 0xFF;
            this.pathName = new String(this.buffer, 3, len);
            len = this.buffer[66] & 0xFF;
            this.dataName = new String(this.buffer, 67, len);
            this.iDataType = Utility.getShort(this.buffer, 82);
            this.iDataAux = Utility.getShort(this.buffer, 84);
            try {
                this.largeImage = new Image(this.buffer, 86);
                this.smallImage = new Image(this.buffer, 86 + this.largeImage.size());
            }
            catch (InvalidImageException e) {
                System.out.println(e.getMessage());
            }
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("Data length .. %04X%n", this.iDataLen));
            text.append(String.format("Path name .... %s%n", this.pathName));
            text.append(String.format("Data name .... %s%n", this.dataName));
            text.append("\n");
            text.append(this.largeImage);
            text.append("\n");
            text.append("\n");
            text.append(this.smallImage);
            return text.toString();
        }
    }

    class Image {
        int iconType;
        int iconSize;
        int iconHeight;
        int iconWidth;
        byte[] iconImage;
        byte[] iconMask;
        boolean colour;
        private final BufferedImage image;

        public Image(byte[] buffer, int ptr) throws InvalidImageException {
            this.iconType = Utility.getShort(buffer, ptr);
            this.iconSize = Utility.getShort(buffer, ptr + 2);
            this.iconHeight = Utility.getShort(buffer, ptr + 4);
            this.iconWidth = Utility.getShort(buffer, ptr + 6);
            if (this.iconWidth == 0 || this.iconHeight == 0) {
                throw new InvalidImageException(String.format("Invalid icon: Height: %d, Width: %d", this.iconHeight, this.iconWidth));
            }
            if (this.iconType != 0 && this.iconType != 32768 && this.iconType != 65535 && this.iconType != 255) {
                throw new InvalidImageException(String.format("Bad icon type: %04X", this.iconType));
            }
            this.iconImage = new byte[this.iconSize];
            this.iconMask = new byte[this.iconSize];
            this.colour = (this.iconType & 0x80) != 0;
            System.arraycopy(buffer, ptr + 8, this.iconImage, 0, this.iconSize);
            System.arraycopy(buffer, ptr + 8 + this.iconSize, this.iconMask, 0, this.iconSize);
            int[] colours = HiResImage.getPaletteFactory().get(0).getColours();
            this.image = new BufferedImage(this.iconWidth, this.iconHeight, 1);
            DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
            int element = 0;
            int rowBytes = (this.iconWidth - 1) / 2 + 1;
            int i = 0;
            while (i < this.iconImage.length) {
                int max = Math.min(i + rowBytes, dataBuffer.getSize());
                int j = i;
                while (j < max) {
                    byte left = (byte)((this.iconImage[j] & 0xF0) >>> 4);
                    byte right = (byte)(this.iconImage[j] & 0xF);
                    byte maskLeft = (byte)((this.iconMask[j] & 0xF0) >>> 4);
                    byte maskRight = (byte)(this.iconMask[j] & 0xF);
                    if (element < dataBuffer.getSize()) {
                        dataBuffer.setElem(element++, colours[left & maskLeft]);
                        dataBuffer.setElem(element++, colours[right & maskRight]);
                    }
                    ++j;
                }
                i += rowBytes;
            }
        }

        public int size() {
            return 8 + this.iconSize * 2;
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("Icon type .... %04X%n", this.iconType));
            text.append(String.format("Icon size .... %d%n", this.iconSize));
            text.append(String.format("Icon height .. %d%n", this.iconHeight));
            text.append(String.format("Icon width ... %d%n%n", this.iconWidth));
            this.appendIcon(text, this.iconImage);
            text.append("\n\n");
            this.appendIcon(text, this.iconMask);
            return text.toString();
        }

        private void appendIcon(StringBuilder text, byte[] buffer) {
            int rowBytes = (this.iconWidth - 1) / 2 + 1;
            int i = 0;
            while (i < this.iconImage.length) {
                int ptr = i;
                int max = i + rowBytes;
                while (ptr < max) {
                    byte left = (byte)((buffer[ptr] & 0xF0) >>> 4);
                    byte right = (byte)(buffer[ptr] & 0xF);
                    text.append(String.format("%X %X ", left, (int)right));
                    ++ptr;
                }
                text.append("\n");
                i += rowBytes;
            }
            if (text.length() > 0) {
                text.deleteCharAt(text.length() - 1);
            }
        }
    }

    class InvalidImageException
    extends Exception {
        public InvalidImageException(String message) {
            super(message);
        }
    }
}

