/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.SegmentHeader;
import com.bytezone.diskbrowser.utilities.HexFormatter;

public class FileSystemTranslator
extends AbstractFile {
    private final String text1;
    private final String text2;
    private final String text3;
    private final String text4;

    public FileSystemTranslator(String name, byte[] buffer) {
        super(name, buffer);
        this.text1 = HexFormatter.getPascalString(buffer, 54);
        this.text2 = HexFormatter.getPascalString(buffer, 252);
        int len1 = buffer[252] & 0xFF;
        this.text3 = HexFormatter.getPascalString(buffer, 252 + len1 + 1);
        int len2 = buffer[252 + len1 + 1] & 0xFF;
        this.text4 = HexFormatter.getPascalString(buffer, 252 + len1 + len2 + 4);
        SegmentHeader segmentHeader = new SegmentHeader(buffer, 0);
        System.out.println(segmentHeader);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder("Name : " + this.name + "\n\n");
        text.append("File System Translator\n\n");
        text.append(String.format("Text 1 ....... %s%n", this.text1));
        text.append(String.format("Text 2 ....... %s%n", this.text2));
        text.append(String.format("Text 3 ....... %s%n", this.text3));
        text.append(String.format("Text 4 ....... %s%n", this.text4));
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }
}

