/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.DoubleScrunch;
import com.bytezone.diskbrowser.applefile.HiResImage;
import com.bytezone.diskbrowser.applefile.Palette;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;

public class DoubleHiResImage
extends HiResImage {
    private static int[] swap;
    private final byte[] auxBuffer;
    private DoubleScrunch doubleScrunch;
    byte[] packedBuffer;

    static {
        int[] nArray = new int[16];
        nArray[1] = 8;
        nArray[2] = 4;
        nArray[3] = 12;
        nArray[4] = 2;
        nArray[5] = 10;
        nArray[6] = 6;
        nArray[7] = 14;
        nArray[8] = 1;
        nArray[9] = 9;
        nArray[10] = 5;
        nArray[11] = 13;
        nArray[12] = 3;
        nArray[13] = 11;
        nArray[14] = 7;
        nArray[15] = 15;
        swap = nArray;
    }

    public DoubleHiResImage(String name, byte[] buffer, byte[] auxBuffer) {
        super(name, buffer);
        this.auxBuffer = auxBuffer;
        this.createImage();
    }

    public DoubleHiResImage(String name, byte[] buffer) {
        super(name, buffer);
        if (name.endsWith(".PAC")) {
            this.packedBuffer = buffer;
            this.doubleScrunch = new DoubleScrunch(buffer);
            this.auxBuffer = this.doubleScrunch.memory[0];
            this.buffer = this.doubleScrunch.memory[1];
        } else {
            this.auxBuffer = new byte[8192];
            this.buffer = new byte[8192];
            System.arraycopy(buffer, 0, this.auxBuffer, 0, 8192);
            System.arraycopy(buffer, 8192, this.buffer, 0, 8192);
        }
        this.createImage();
    }

    @Override
    protected void createMonochromeImage() {
        int WIDTH = 560;
        int HEIGHT = 384;
        this.image = new BufferedImage(WIDTH, HEIGHT, 10);
        DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
        int ndx = 0;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 8) {
                int k = 0;
                while (k < 8) {
                    int base = i * 40 + j * 128 + k * 1024;
                    int max = Math.min(base + 40, this.buffer.length);
                    int ptr = base;
                    while (ptr < max) {
                        int value = this.auxBuffer[ptr] & 0x7F | (this.buffer[ptr] & 0x7F) << 7 | (this.auxBuffer[ptr + 1] & 0x7F) << 14 | (this.buffer[ptr + 1] & 0x7F) << 21;
                        int px = 0;
                        while (px < 28) {
                            int val = value >> px & 1;
                            int pixel = val == 0 ? 0 : 255;
                            dataBuffer.setElem(ndx, pixel);
                            dataBuffer.setElem(ndx + WIDTH, pixel);
                            ++ndx;
                            ++px;
                        }
                        ptr += 2;
                    }
                    ndx += WIDTH;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected void createColourImage() {
        this.paletteIndex = paletteFactory.getCurrentPaletteIndex();
        Palette palette = paletteFactory.getCurrentPalette();
        int[] colours = palette.getColours();
        this.image = new BufferedImage(280, 192, 1);
        DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
        int ndx = 0;
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 8) {
                int k = 0;
                while (k < 8) {
                    int base = i * 40 + j * 128 + k * 1024;
                    int max = Math.min(base + 40, this.buffer.length);
                    int ptr = base;
                    while (ptr < max) {
                        int value = this.auxBuffer[ptr] & 0x7F | (this.buffer[ptr] & 0x7F) << 7 | (this.auxBuffer[ptr + 1] & 0x7F) << 14 | (this.buffer[ptr + 1] & 0x7F) << 21;
                        int px = 0;
                        while (px < 28) {
                            int val = value >>> px & 0xF;
                            int val2 = swap[val];
                            dataBuffer.setElem(ndx++, colours[val2]);
                            dataBuffer.setElem(ndx++, colours[val2]);
                            px += 4;
                        }
                        ptr += 2;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public String getHexDump() {
        StringBuilder text = new StringBuilder();
        if (this.packedBuffer != null) {
            text.append("Packed buffer:\n\n");
            text.append(HexFormatter.format(this.packedBuffer));
        }
        text.append("\n\nAuxilliary buffer:\n\n");
        text.append(HexFormatter.format(this.auxBuffer));
        text.append("\n\nPrimary buffer:\n\n");
        text.append(HexFormatter.format(this.buffer));
        return text.toString();
    }
}

