/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import com.bytezone.diskbrowser.utilities.Utility;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class DosMasterFile
extends AbstractFile {
    private static final String base = "/Users/denismolony/Dropbox/Examples/Testing/";

    public DosMasterFile(String name, byte[] buffer) {
        super(name, buffer);
    }

    public static boolean isDos33(ProdosDisk parentDisk, byte[] buffer) {
        System.out.printf("%nHighest Block: %04X (%<,d)%n", parentDisk.getDisk().getTotalBlocks() - 1);
        System.out.print("\nSlots/Drives: ");
        int i = 0;
        while (i < 8) {
            System.out.printf("%02X    ", buffer[56 + i]);
            if (i % 2 == 1) {
                System.out.print(": ");
            }
            ++i;
        }
        System.out.print("\nFirst Block : ");
        i = 0;
        while (i < 16) {
            System.out.printf("%04X  ", Utility.getShort(buffer, 64 + i));
            if (i % 4 == 2) {
                System.out.print(": ");
            }
            i += 2;
        }
        System.out.print("\nLast Block  : ");
        i = 0;
        while (i < 8) {
            System.out.printf("%04X        : ", Utility.getShort(buffer, 80 + i));
            i += 2;
        }
        System.out.print("\nImage Size  : ");
        i = 0;
        while (i < 8) {
            System.out.printf("%04X        : ", Utility.getShort(buffer, 88 + i));
            i += 2;
        }
        System.out.print("\nAddress     : ");
        i = 0;
        while (i < 8) {
            System.out.printf("%04X        : ", Utility.getShort(buffer, 96 + i));
            i += 2;
        }
        System.out.println();
        System.out.println();
        System.out.println("#      S  D  B Lo  B Hi  Size  Vols  Secs");
        Disk disk = parentDisk.getDisk();
        int i2 = 0;
        while (i2 < 8) {
            int slotDrive = buffer[56 + i2] & 0xFF;
            if (slotDrive != 0) {
                int slot = (slotDrive & 0x70) >>> 4;
                int drive = ((slotDrive & 0x80) >>> 7) + 1;
                int firstBlock = Utility.getShort(buffer, 64 + i2 * 2);
                int skip = i2 / 2 * 2;
                int lastBlock = Utility.getShort(buffer, 80 + skip);
                int volSize = Utility.getShort(buffer, 88 + skip);
                int originalFirstBlock = firstBlock;
                if (firstBlock > lastBlock) {
                    firstBlock -= 65536;
                }
                int vols = (lastBlock - firstBlock) / volSize - 1;
                int sectors = volSize * 2;
                System.out.printf("%d  %02X  %d  %d  %04X  %04X  %04X   %3d  %4d%n", i2, buffer[56 + i2], slot, drive, originalFirstBlock, lastBlock, volSize, vols, sectors);
                if (vols > 0) {
                    int volNo = 1;
                    int firstDiskBlock = firstBlock + volNo * volSize;
                    int lastDiskBlock = firstDiskBlock + volSize;
                    ArrayList<DiskAddress> daList = new ArrayList<DiskAddress>();
                    int block = firstDiskBlock;
                    while (block < lastDiskBlock) {
                        daList.add(disk.getDiskAddress(block));
                        ++block;
                    }
                    byte[] byArray = disk.readBlocks(daList);
                }
            }
            ++i2;
        }
        return false;
    }

    private static void createDisk(String name, byte[] buffer) {
        File file = new File(name);
        if (file.exists()) {
            System.out.printf("File: %s already exists%n", name);
            return;
        }
        try {
            Path path = Paths.get(name, new String[0]);
            Files.write(path, buffer, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void oldCode(ProdosDisk parentDisk, byte[] buffer) {
        int slots = 56;
        int v0 = slots + 8;
        int size = v0 + 16;
        int vsiz = size + 8;
        System.out.println();
        System.out.println("Slots  v0   size  vsiz    d    d0   s/d   ptr   strt     sz      end    vols");
        StringBuilder text = new StringBuilder();
        int d = 0;
        while (d < 8) {
            int d0 = d / 2 * 2;
            int s = buffer[slots + d] & 0xFF;
            if (s != 0) {
                System.out.printf(" %02X    %02X    %02X    %02X    %02X    %02X    %02X", slots, v0, size, vsiz, d, d0, s);
                int dr = 0;
                if (s > 127) {
                    s -= 128;
                    dr = 1;
                }
                text.append(String.format("Slot %d, Drive %d has", s / 16, dr + 1));
                int ptr = v0 + 2 * d0 + 2 * dr;
                int st = Utility.getShort(buffer, ptr);
                int v = Utility.getShort(buffer, size + d0);
                int sz = Utility.getShort(buffer, vsiz + d0);
                if (st > v) {
                    st -= 65536;
                }
                int num = (v - st) / sz - 1;
                text.append(String.format(" %d volumes of %d sectors%n", num, sz * 2));
                System.out.printf("   %02X    %04X    %04X    %04X    %04X%n", ptr, st, sz, v, num);
                Disk disk = parentDisk.getDisk();
            }
            ++d;
        }
        System.out.println();
        System.out.println(text.toString());
    }
}

