/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;

public class DeviceDriver
extends AbstractFile {
    private final int auxType;
    private final int classifications;
    private final int driverClass;
    private final boolean inactive;

    public DeviceDriver(String name, byte[] buffer, int auxType) {
        super(name, buffer);
        this.auxType = auxType;
        this.classifications = auxType & 0xFF;
        this.driverClass = (auxType & 0x7F00) >>> 8;
        this.inactive = (auxType & 0x8000) != 0;
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder("Name : " + this.name + "\n\n");
        text.append("Apple IIGS Device Driver File\n\n");
        text.append(String.format("Classifications ... %02X%n", this.classifications));
        text.append(String.format("Driver Class ...... %02X%n", this.driverClass));
        text.append(String.format("Aux type .......... %d%n", this.auxType));
        text.append(String.format("Inactive .......... %s%n", this.inactive ? "True" : "False"));
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }
}

