/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.Utility;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.util.ArrayList;
import java.util.List;

abstract class CharacterList
extends AbstractFile {
    static final int borderX = 3;
    static final int borderY = 3;
    static final int gapX = 3;
    static final int gapY = 3;
    static final int sizeX = 7;
    static final int sizeY = 8;
    List<Character> characters = new ArrayList<Character>();

    public CharacterList(String name, byte[] buffer) {
        super(name, buffer);
    }

    void buildImage(int borderX, int borderY, int gapX, int gapY, int sizeX, int sizeY, int charsX) {
        int charsY = (this.characters.size() - 1) / charsX + 1;
        this.image = new BufferedImage(Utility.dimension(charsX, borderX, sizeX, gapX), Utility.dimension(charsY, borderY, sizeY, gapY), 10);
        Graphics2D g2d = this.image.createGraphics();
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        int count = 0;
        int x = borderX;
        int y = borderY;
        for (Character character : this.characters) {
            g2d.drawImage((Image)character.image, x, y, null);
            if (++count % charsX == 0) {
                x = borderX;
                y += sizeY + gapY;
                continue;
            }
            x += sizeX + gapX;
        }
        g2d.dispose();
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder("Name : " + this.name + "\n\n");
        for (Character character : this.characters) {
            text.append(character);
            text.append("\n");
        }
        return text.toString();
    }

    class Character {
        BufferedImage image;

        public Character(int sizeX, int sizeY) {
            this.image = new BufferedImage(sizeX, sizeY, 10);
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
            int element = 0;
            int i = 0;
            while (i < 8) {
                int j = 0;
                while (j < 7) {
                    text.append(dataBuffer.getElem(element++) == 0 ? "." : "X");
                    ++j;
                }
                text.append("\n");
                ++i;
            }
            return text.toString();
        }
    }
}

