/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.TextBuffer;
import com.bytezone.diskbrowser.applefile.TextFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.util.List;

public class BasicTextFile
extends TextFile {
    private static String underline = "------------------------------------------------------------------------------\n";
    private static String fullUnderline = "----------  -------  " + underline;
    private int recordLength;
    private List<TextBuffer> buffers;
    private int eof;
    private boolean prodosFile;

    public BasicTextFile(String name, byte[] buffer) {
        super(name, buffer);
    }

    public BasicTextFile(String name, byte[] buffer, int auxType, int eof) {
        super(name, buffer);
        this.eof = eof;
        this.recordLength = auxType;
        this.prodosFile = true;
    }

    public BasicTextFile(String name, List<TextBuffer> buffers, int auxType, int eof) {
        super(name, null);
        this.buffers = buffers;
        this.eof = eof;
        this.recordLength = auxType;
        this.prodosFile = true;
    }

    @Override
    public String getHexDump() {
        if (this.buffers == null || this.recordLength <= 1) {
            return super.getHexDump();
        }
        StringBuilder text = new StringBuilder();
        for (TextBuffer tb : this.buffers) {
            int i = 0;
            int rec = 0;
            while (i < tb.buffer.length) {
                text.append("\nRecord #" + (tb.firstRecNo + rec) + "\n");
                text.append(String.valueOf(HexFormatter.format(tb.buffer, i, tb.reclen)) + "\n");
                i += tb.reclen;
                ++rec;
            }
        }
        return text.toString();
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        if (BasicTextFile.textPreferences.showHeader) {
            text.append("Name          : " + this.name + "\n");
            if (this.prodosFile) {
                text.append(String.format("Record length : %,8d%n", this.recordLength));
                text.append(String.format("End of file   : %,8d%n", this.eof));
            } else {
                text.append(String.format("End of file   : %,8d%n", this.buffer.length));
            }
            text.append("\n");
        }
        if (this.buffers != null) {
            return this.treeFileText(text);
        }
        if (this.recordLength <= 0) {
            return this.unknownLength(text).toString();
        }
        if (BasicTextFile.textPreferences.showTextOffsets && this.recordLength > 1) {
            text.append("    Offset  Record#  Text values\n");
            text.append(fullUnderline);
        } else {
            text.append("Text values\n");
            text.append(underline);
        }
        return this.knownLength(text, 0).toString();
    }

    private String treeFileText(StringBuilder text) {
        if (this.recordLength == 1) {
            for (TextBuffer textBuffer : this.buffers) {
                this.buffer = textBuffer.buffer;
                text = this.unknownLength(text);
            }
            return text.toString();
        }
        if (BasicTextFile.textPreferences.showTextOffsets) {
            text.append("    Offset  Record#  Text values\n");
            text.append(fullUnderline);
        } else {
            text.append("Text values\n");
            text.append(underline);
        }
        for (TextBuffer textBuffer : this.buffers) {
            this.buffer = textBuffer.buffer;
            text = this.knownLength(text, textBuffer.firstRecNo);
        }
        return text.toString();
    }

    private StringBuilder knownLength(StringBuilder text, int recNo) {
        int ptr = 0;
        while (ptr < this.buffer.length) {
            if (this.buffer[ptr] == 0) {
                ++recNo;
            } else {
                int len = this.buffer.length - ptr;
                int bytes = Math.min(len, this.recordLength);
                while (this.buffer[ptr + bytes - 1] == 0) {
                    --bytes;
                }
                if ((this.buffer[ptr + bytes - 1] & 0x7F) == 13) {
                    --bytes;
                }
                String line = HexFormatter.getString(this.buffer, ptr, bytes);
                if (BasicTextFile.textPreferences.showTextOffsets) {
                    line = line.replaceAll("\\n", "\n                     ");
                    text.append(String.format("%,10d %,8d  %s%n", recNo * this.recordLength, recNo, line));
                } else {
                    text.append(String.format("%s%n", line));
                }
                ++recNo;
            }
            ptr += this.recordLength;
        }
        return text;
    }

    private StringBuilder unknownLength(StringBuilder text) {
        int nulls = 0;
        int ptr = 0;
        int size = this.buffer.length;
        int lastVal = 0;
        if (BasicTextFile.textPreferences.showTextOffsets) {
            text.append("  Offset    Text values\n");
            text.append("----------  " + underline);
        } else {
            text.append(" Text values\n");
            text.append(underline);
        }
        if (this.buffer.length == 0) {
            return text;
        }
        if (this.buffer[0] != 0 && BasicTextFile.textPreferences.showTextOffsets) {
            text.append(String.format("%,10d  ", ptr));
        }
        int gcd = 0;
        while (ptr < size) {
            int val;
            if ((val = this.buffer[ptr++] & 0x7F) == 0) {
                ++nulls;
            } else if (val == 13) {
                text.append("\n");
            } else {
                if (nulls > 0) {
                    if (BasicTextFile.textPreferences.showTextOffsets) {
                        text.append(String.format("%,10d  ", ptr - 1));
                    }
                    nulls = 0;
                    gcd = gcd == 0 ? ptr - 1 : this.gcd(gcd, ptr - 1);
                } else if (lastVal == 13 && BasicTextFile.textPreferences.showTextOffsets) {
                    text.append(String.format("%,10d  ", ptr - 1));
                }
                text.append((char)val);
            }
            lastVal = val;
        }
        if (gcd > 0) {
            text.append(String.format("%nGCD: %,d", gcd));
        } else if (text.length() > 0 && text.charAt(text.length() - 1) == '\n') {
            text.deleteCharAt(text.length() - 1);
        }
        return text;
    }

    private int gcd(int a, int b) {
        return a == 0 ? b : this.gcd(b % a, a);
    }
}

