/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.ApplesoftBasicProgram;
import com.bytezone.diskbrowser.applefile.ApplesoftConstants;
import com.bytezone.diskbrowser.applefile.BasicFormatter;
import com.bytezone.diskbrowser.gui.BasicPreferences;
import com.bytezone.diskbrowser.utilities.Utility;

public class AppleBasicFormatter
extends BasicFormatter {
    private final LineFormatter flatFormatter = new FlatLine();
    private final LineFormatter wrapFormatter = new WrapLine();

    public AppleBasicFormatter(ApplesoftBasicProgram program, BasicPreferences basicPreferences) {
        super(program, basicPreferences);
    }

    @Override
    public void append(StringBuilder fullText) {
        int linkField;
        int loadAddress = this.getLoadAddress();
        int ptr = 0;
        StringBuilder currentLine = new StringBuilder();
        LineFormatter formatter = this.basicPreferences.appleLineWrap ? this.wrapFormatter : this.flatFormatter;
        while ((linkField = Utility.getShort(this.buffer, ptr)) != 0) {
            int lineNumber = Utility.getShort(this.buffer, ptr + 2);
            currentLine.append(String.format(" %d ", lineNumber));
            ptr += 4;
            ptr = formatter.formatLine(currentLine, ptr);
            if (ptr != linkField - loadAddress) {
                System.out.printf("%s: ptr: %04X, nextLine: %04X%n", this.program.name, ptr + loadAddress, linkField);
            }
            currentLine.append("\n");
            fullText.append((CharSequence)currentLine);
            currentLine.setLength(0);
        }
    }

    class FlatLine
    implements LineFormatter {
        FlatLine() {
        }

        @Override
        public int formatLine(StringBuilder currentLine, int ptr) {
            byte b;
            block5: while ((b = AppleBasicFormatter.this.buffer[ptr++]) != 0) {
                if (Utility.isHighBitSet(b)) {
                    String token = String.format(" %s ", ApplesoftConstants.tokens[b & 0x7F]);
                    currentLine.append(token);
                    continue;
                }
                switch (b) {
                    case 13: {
                        currentLine.append("\n");
                        break;
                    }
                    case 8: {
                        if (currentLine.length() <= 0) continue block5;
                        currentLine.deleteCharAt(currentLine.length() - 1);
                        break;
                    }
                    case 10: {
                        int indent = Utility.getIndent(currentLine);
                        currentLine.append("\n");
                        int i = 0;
                        while (i < indent) {
                            currentLine.append(" ");
                            ++i;
                        }
                        continue block5;
                    }
                    default: {
                        currentLine.append((char)b);
                    }
                }
            }
            return ptr;
        }
    }

    static interface LineFormatter {
        public int formatLine(StringBuilder var1, int var2);
    }

    class WrapLine
    implements LineFormatter {
        private static final int LEFT_MARGIN = 5;
        private static final int RIGHT_MARGIN = 33;

        WrapLine() {
        }

        @Override
        public int formatLine(StringBuilder currentLine, int ptr) {
            byte b;
            int cursor = currentLine.length();
            block5: while ((b = AppleBasicFormatter.this.buffer[ptr++]) != 0) {
                if (Utility.isHighBitSet(b)) {
                    String token = String.format(" %s ", ApplesoftConstants.tokens[b & 0x7F]);
                    currentLine.append(token);
                    cursor = this.incrementCursor(currentLine, cursor, token.length());
                    continue;
                }
                switch (b) {
                    case 13: {
                        currentLine.append("\n");
                        cursor = 0;
                        break;
                    }
                    case 8: {
                        if (cursor <= 0) continue block5;
                        currentLine.deleteCharAt(currentLine.length() - 1);
                        --cursor;
                        break;
                    }
                    case 10: {
                        currentLine.append("\n");
                        int i = 0;
                        while (i < cursor) {
                            currentLine.append(" ");
                            ++i;
                        }
                        continue block5;
                    }
                    default: {
                        currentLine.append((char)b);
                        cursor = this.incrementCursor(currentLine, cursor, 1);
                    }
                }
            }
            return ptr;
        }

        private int incrementCursor(StringBuilder currentLine, int cursor, int size) {
            assert (size <= 9);
            if ((cursor += size) >= 33) {
                cursor = cursor >= 40 ? cursor - 40 : 5;
                currentLine.append("\n     ".substring(0, cursor + 1));
            }
            return cursor;
        }
    }
}

