/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.ApplesoftConstants;
import com.bytezone.diskbrowser.applefile.SubLine;

class Alignment
implements ApplesoftConstants {
    int equalsPosition;
    int targetLength;
    SubLine firstSubLine;
    SubLine lastSubLine;

    Alignment() {
    }

    void reset() {
        this.equalsPosition = 0;
        this.targetLength = 0;
        this.firstSubLine = null;
        this.lastSubLine = null;
    }

    void setFirst(SubLine subline) {
        this.reset();
        this.firstSubLine = subline;
        this.check(subline);
    }

    void check(SubLine subline) {
        int temp;
        if (this.equalsPosition < subline.equalsPosition) {
            this.equalsPosition = subline.equalsPosition;
        }
        if (this.targetLength < (temp = subline.endPosition - subline.equalsPosition)) {
            this.targetLength = temp;
        }
        this.lastSubLine = subline;
    }

    public String getAlignedText(SubLine subline) {
        StringBuilder line = subline.toStringBuilder();
        if (this.equalsPosition == 0 || subline.is((byte)-78)) {
            return line.toString();
        }
        int alignEqualsPos = this.equalsPosition;
        int targetLength = subline.endPosition - this.equalsPosition;
        while (alignEqualsPos-- > subline.equalsPosition) {
            line.insert(subline.equalsPosition, ' ');
        }
        if (line.charAt(line.length() - 1) == ':') {
            while (targetLength++ <= this.targetLength) {
                line.append(" ");
            }
        }
        return line.toString();
    }

    public String toString() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("Equals position ..... %d%n", this.equalsPosition));
        text.append(String.format("Target length ....... %d%n", this.targetLength));
        text.append(String.format("First subline ....... %s%n", this.firstSubLine));
        text.append(String.format("Last subline ........ %s", this.lastSubLine));
        return text.toString();
    }
}

